'\"
'\" Copyright 1991-1997 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
.so man.macros
.HS intro BLT 
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
BLT \- Introduction to the BLT library
.BE
.SH DESCRIPTION
BLT is a library of extensions to the Tk library.  It adds new
commands and variables to the application's interpreter.
.LP
.SH COMMANDS
The following commands are added to the interpreter from the BLT library:
.TP 15
\fBtable\fR 
A table geometry manager for Tk.  You specify window placements as table 
row,column positions and windows can also span multiple rows or columns. 
It also has many options for setting and/or bounding window sizes.
.TP 15
\fBgraph\fR 
A 2D plotting widget.  Plots two variable data in a window with an optional 
legend and annotations.   It has of several components; coordinate axes, 
crosshairs, a legend, and a collection of elements and tags.
.TP 15
\fBbarchart\fR 
A barchart widget.  Plots two-variable data as rectangular bars in a 
window.  The x-coordinate values designate the position of the bar along 
the x-axis, while the y-coordinate values designate the magnitude.
The \fBbarchart\fR widget has of several components; coordinate axes, 
crosshairs, a legend, and a collection of elements and tags.
.TP 15
\fBvector\fR 
Creates a vector of floating point values.  The vector's components
can be manipulated in three ways: through a Tcl array variable, a Tcl
command, or the C API.
.TP
\fBspline\fR
Computes a spline fitting a set of data points (x and y vectors) and
produces a vector of the interpolated images (y-coordinates) at a
given set of x-coordinates.
.TP 15
\fBbgexec\fR 
Like Tcl's \fBexec\fR command, \fBbgexec\fR runs a pipeline of Unix 
commands in the background.  Unlike \fBexec\fR, the output of the last
process is collected and a global Tcl variable is set upon its completion.
\fBbgexec\fR can be used with \fBtkwait\fR to wait for Unix commands
to finish while still handling expose events.  Intermediate output is
also available while the pipeline is active.
.TP 15
\fBbusy\fR 
Creates a "busy window" which prevents user-interaction when an
application is busy.  The busy window also provides an easy way 
to have temporary busy cursors (such as a watch or hourglass).
.TP 15
\fBbitmap\fR 
Reads and writes bitmaps from Tcl.  New X bitmaps can be defined
on-the-fly from Tcl, obviating the need to copy around bitmap files.  
Other options query loaded X bitmap's dimensions and data.
.TP 15
\fBdrag&drop\fR 
Provides a drag-and-drop facility for Tk.  Information (represented
by a token window) can be dragged to and from any Tk window, including
those of another Tk application.  \fBdrag&drop\fR acts as a 
coordinator, directing Tk \fBsend\fR commands between (or within) TCL/Tk 
applications. 
.TP 15
\fBhtext\fR 
A simple hypertext widget.  Combines text and Tk widgets into a single
scroll-able window.  Tcl commands can be embedded into text, which are
invoked as the text is parsed.  In addition, Tk widgets can be
appended to the window at the current point in the text.  \fBHtext\fR
can be also used to create scrolled windows of Tk widgets.
.TP 15
\fBwinop\fR 
Raise, lower, map, or, unmap any window.  The raise and lower functions
are useful for stacking windows above or below "busy windows".
.TP 15
\fBwatch\fR 
Arranges for Tcl procedures to be called before and/or after the execution
of every Tcl command. This command
may be used in the logging, profiling, or tracing of Tcl code.
.TP 15
\fBbltdebug\fR 
A simple Tcl command tracing facility useful for debugging Tcl code.  
Displays each Tcl command before and after substitution along its level 
in the interpreter on standard error.
.SH VARIABLES
.PP
The following Tcl variables are either set or used by BLT at various times
in its execution:
.TP 15
\fBblt_library\fR
This variable contains the name of a directory containing a library
of Tcl scripts and other files related to BLT.  Currently, this 
directory contains the \fBdrag&drop\fR protocol scripts and the 
PostScript prolog
used by \fBgraph\fR and \fBbarchart\fR.
The value of this variable is taken from the BLT_LIBRARY environment
variable, if one exists, or else from a default value compiled into
the \fBBLT\fR library.
.TP 15
\fBblt_versions\fR 
This variable is set in the interpreter for each application. It is an 
array of the current version numbers for each 
of the BLT commands in the form \fImajor\fR.\fIminor\fR.  \fIMajor\fR and
\fIminor\fR are integers.  The major version number increases in
any command that includes changes that are not backward compatible
(i.e. whenever existing applications and scripts may have to change to
work with the new release).  The minor version number increases with
each new release of a command, except that it resets to zero whenever the
major version number changes.  The array is indexed by the individual 
command name.
.SH ADDING BLT TO YOUR APPLICATIONS
It's easy to add BLT to an existing Tk application.  BLT requires no 
patches or edits to the Tcl or Tk libraries.  To add BLT, simply add the 
following code snippet to your application's tkAppInit.c file.  
.DS
if (Blt_Init(interp) != TCL_OK) {
    return TCL_ERROR;
}
.DE
Recompile and link with the BLT library (libBLT.a) and that's it.
.PP
Alternately, you can dynamically load BLT, simply by invoking the
command
.DS
package require BLT
.DE
from your Tcl script.
.SH BUGS
Send bug reports, requests, suggestions, etc. to 
gah@bell-labs.com or ghowlett@fast.net
.SH KEYWORDS
BLT
