'\"
'\" Copyright (c) 1998-2000 by Scriptics Corporation.
'\" All rights reserved.
'\" 
'\" RCS: @(#) $Id: colors.n,v 1.1.1.1 2002/04/02 03:49:38 khan Exp $
'\" 
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1.1.1 2002/04/02 03:49:38 khan Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH colors n 8.3 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
colors \- symbolic color names recognized by Tk
.BE
.SH DESCRIPTION
.PP
Tk recognizes many symbolic color names (eg, \fBred\fR) when
specifying colors.  The symbolic names recognized by Tk and their
8-bit RGB values are:
.CS
alice blue                 240   248   248
AliceBlue                  240   248   248
antique white              250   235   235
AntiqueWhite               250   235   235
AntiqueWhite1              255   239   239
AntiqueWhite2              238   223   223
AntiqueWhite3              205   192   192
AntiqueWhite4              139   131   131
aquamarine                 127   255   255
aquamarine1                127   255   255
aquamarine2                118   238   238
aquamarine3                102   205   205
aquamarine4                 69   139   139
azure                      240   255   255
azure1                     240   255   255
azure2                     224   238   238
azure3                     193   205   205
azure4                     131   139   139
beige                      245   245   245
bisque                     255   228   228
bisque1                    255   228   228
bisque2                    238   213   213
bisque3                    205   183   183
bisque4                    139   125   125
black                        0     0     0
blanched almond            255   235   235
BlanchedAlmond             255   235   235
blue                         0     0     0
blue violet                138    43    43
blue1                        0     0     0
blue2                        0     0     0
blue3                        0     0     0
blue4                        0     0     0
BlueViolet                 138    43    43
brown                      165    42    42
brown1                     255    64    64
brown2                     238    59    59
brown3                     205    51    51
brown4                     139    35    35
burlywood                  222   184   184
burlywood1                 255   211   211
burlywood2                 238   197   197
burlywood3                 205   170   170
burlywood4                 139   115   115
cadet blue                  95   158   158
CadetBlue                   95   158   158
CadetBlue1                 152   245   245
CadetBlue2                 142   229   229
CadetBlue3                 122   197   197
CadetBlue4                  83   134   134
chartreuse                 127   255   255
chartreuse1                127   255   255
chartreuse2                118   238   238
chartreuse3                102   205   205
chartreuse4                 69   139   139
chocolate                  210   105   105
chocolate1                 255   127   127
chocolate2                 238   118   118
chocolate3                 205   102   102
chocolate4                 139    69    69
coral                      255   127   127
coral1                     255   114   114
coral2                     238   106   106
coral3                     205    91    91
coral4                     139    62    62
cornflower blue            100   149   149
CornflowerBlue             100   149   149
cornsilk                   255   248   248
cornsilk1                  255   248   248
cornsilk2                  238   232   232
cornsilk3                  205   200   200
cornsilk4                  139   136   136
cyan                         0   255   255
cyan1                        0   255   255
cyan2                        0   238   238
cyan3                        0   205   205
cyan4                        0   139   139
dark blue                    0     0     0
dark cyan                    0   139   139
dark goldenrod             184   134   134
dark gray                  169   169   169
dark green                   0   100   100
dark grey                  169   169   169
dark khaki                 189   183   183
dark magenta               139     0     0
dark olive green            85   107   107
dark orange                255   140   140
dark orchid                153    50    50
dark red                   139     0     0
dark salmon                233   150   150
dark sea green             143   188   188
dark slate blue             72    61    61
dark slate gray             47    79    79
dark slate grey             47    79    79
dark turquoise               0   206   206
dark violet                148     0     0
DarkBlue                     0     0     0
DarkCyan                     0   139   139
DarkGoldenrod              184   134   134
DarkGoldenrod1             255   185   185
DarkGoldenrod2             238   173   173
DarkGoldenrod3             205   149   149
DarkGoldenrod4             139   101   101
DarkGray                   169   169   169
DarkGreen                    0   100   100
DarkGrey                   169   169   169
DarkKhaki                  189   183   183
DarkMagenta                139     0     0
DarkOliveGreen              85   107   107
DarkOliveGreen1            202   255   255
DarkOliveGreen2            188   238   238
DarkOliveGreen3            162   205   205
DarkOliveGreen4            110   139   139
DarkOrange                 255   140   140
DarkOrange1                255   127   127
DarkOrange2                238   118   118
DarkOrange3                205   102   102
DarkOrange4                139    69    69
DarkOrchid                 153    50    50
DarkOrchid1                191    62    62
DarkOrchid2                178    58    58
DarkOrchid3                154    50    50
DarkOrchid4                104    34    34
DarkRed                    139     0     0
DarkSalmon                 233   150   150
DarkSeaGreen               143   188   188
DarkSeaGreen1              193   255   255
DarkSeaGreen2              180   238   238
DarkSeaGreen3              155   205   205
DarkSeaGreen4              105   139   139
DarkSlateBlue               72    61    61
DarkSlateGray               47    79    79
DarkSlateGray1             151   255   255
DarkSlateGray2             141   238   238
DarkSlateGray3             121   205   205
DarkSlateGray4              82   139   139
DarkSlateGrey               47    79    79
DarkTurquoise                0   206   206
DarkViolet                 148     0     0
deep pink                  255    20    20
deep sky blue                0   191   191
DeepPink                   255    20    20
DeepPink1                  255    20    20
DeepPink2                  238    18    18
DeepPink3                  205    16    16
DeepPink4                  139    10    10
DeepSkyBlue                  0   191   191
DeepSkyBlue1                 0   191   191
DeepSkyBlue2                 0   178   178
DeepSkyBlue3                 0   154   154
DeepSkyBlue4                 0   104   104
dim gray                   105   105   105
dim grey                   105   105   105
DimGray                    105   105   105
DimGrey                    105   105   105
dodger blue                 30   144   144
DodgerBlue                  30   144   144
DodgerBlue1                 30   144   144
DodgerBlue2                 28   134   134
DodgerBlue3                 24   116   116
DodgerBlue4                 16    78    78
firebrick                  178    34    34
firebrick1                 255    48    48
firebrick2                 238    44    44
firebrick3                 205    38    38
firebrick4                 139    26    26
floral white               255   250   250
FloralWhite                255   250   250
forest green                34   139   139
ForestGreen                 34   139   139
gainsboro                  220   220   220
ghost white                248   248   248
GhostWhite                 248   248   248
gold                       255   215   215
gold1                      255   215   215
gold2                      238   201   201
gold3                      205   173   173
gold4                      139   117   117
goldenrod                  218   165   165
goldenrod1                 255   193   193
goldenrod2                 238   180   180
goldenrod3                 205   155   155
goldenrod4                 139   105   105
gray                       190   190   190
gray0                        0     0     0
gray1                        3     3     3
gray2                        5     5     5
gray3                        8     8     8
gray4                       10    10    10
gray5                       13    13    13
gray6                       15    15    15
gray7                       18    18    18
gray8                       20    20    20
gray9                       23    23    23
gray10                      26    26    26
gray11                      28    28    28
gray12                      31    31    31
gray13                      33    33    33
gray14                      36    36    36
gray15                      38    38    38
.CE
.CS
gray16                      41    41    41
gray17                      43    43    43
gray18                      46    46    46
gray19                      48    48    48
gray20                      51    51    51
gray21                      54    54    54
gray22                      56    56    56
gray23                      59    59    59
gray24                      61    61    61
gray25                      64    64    64
gray26                      66    66    66
gray27                      69    69    69
gray28                      71    71    71
gray29                      74    74    74
gray30                      77    77    77
gray31                      79    79    79
gray32                      82    82    82
gray33                      84    84    84
gray34                      87    87    87
gray35                      89    89    89
gray36                      92    92    92
gray37                      94    94    94
gray38                      97    97    97
gray39                      99    99    99
gray40                     102   102   102
gray41                     105   105   105
gray42                     107   107   107
gray43                     110   110   110
gray44                     112   112   112
gray45                     115   115   115
gray46                     117   117   117
gray47                     120   120   120
gray48                     122   122   122
gray49                     125   125   125
gray50                     127   127   127
gray51                     130   130   130
gray52                     133   133   133
gray53                     135   135   135
gray54                     138   138   138
gray55                     140   140   140
gray56                     143   143   143
gray57                     145   145   145
gray58                     148   148   148
gray59                     150   150   150
gray60                     153   153   153
gray61                     156   156   156
gray62                     158   158   158
gray63                     161   161   161
gray64                     163   163   163
gray65                     166   166   166
gray66                     168   168   168
gray67                     171   171   171
gray68                     173   173   173
gray69                     176   176   176
gray70                     179   179   179
gray71                     181   181   181
gray72                     184   184   184
gray73                     186   186   186
gray74                     189   189   189
gray75                     191   191   191
gray76                     194   194   194
gray77                     196   196   196
gray78                     199   199   199
gray79                     201   201   201
gray80                     204   204   204
gray81                     207   207   207
gray82                     209   209   209
gray83                     212   212   212
gray84                     214   214   214
gray85                     217   217   217
gray86                     219   219   219
gray87                     222   222   222
gray88                     224   224   224
gray89                     227   227   227
gray90                     229   229   229
gray91                     232   232   232
gray92                     235   235   235
gray93                     237   237   237
gray94                     240   240   240
gray95                     242   242   242
gray96                     245   245   245
gray97                     247   247   247
gray98                     250   250   250
gray99                     252   252   252
gray100                    255   255   255
green                        0   255   255
green yellow               173   255   255
green1                       0   255   255
green2                       0   238   238
green3                       0   205   205
green4                       0   139   139
GreenYellow                173   255   255
grey                       190   190   190
grey0                        0     0     0
grey1                        3     3     3
grey2                        5     5     5
grey3                        8     8     8
grey4                       10    10    10
grey5                       13    13    13
grey6                       15    15    15
grey7                       18    18    18
grey8                       20    20    20
grey9                       23    23    23
grey10                      26    26    26
grey11                      28    28    28
grey12                      31    31    31
grey13                      33    33    33
grey14                      36    36    36
grey15                      38    38    38
grey16                      41    41    41
grey17                      43    43    43
grey18                      46    46    46
grey19                      48    48    48
grey20                      51    51    51
grey21                      54    54    54
grey22                      56    56    56
grey23                      59    59    59
grey24                      61    61    61
grey25                      64    64    64
grey26                      66    66    66
grey27                      69    69    69
grey28                      71    71    71
grey29                      74    74    74
grey30                      77    77    77
grey31                      79    79    79
grey32                      82    82    82
grey33                      84    84    84
grey34                      87    87    87
grey35                      89    89    89
grey36                      92    92    92
grey37                      94    94    94
grey38                      97    97    97
grey39                      99    99    99
grey40                     102   102   102
grey41                     105   105   105
grey42                     107   107   107
grey43                     110   110   110
grey44                     112   112   112
grey45                     115   115   115
grey46                     117   117   117
grey47                     120   120   120
grey48                     122   122   122
grey49                     125   125   125
grey50                     127   127   127
grey51                     130   130   130
grey52                     133   133   133
grey53                     135   135   135
grey54                     138   138   138
grey55                     140   140   140
grey56                     143   143   143
grey57                     145   145   145
grey58                     148   148   148
grey59                     150   150   150
grey60                     153   153   153
grey61                     156   156   156
grey62                     158   158   158
grey63                     161   161   161
grey64                     163   163   163
grey65                     166   166   166
grey66                     168   168   168
grey67                     171   171   171
grey68                     173   173   173
grey69                     176   176   176
grey70                     179   179   179
grey71                     181   181   181
grey72                     184   184   184
grey73                     186   186   186
grey74                     189   189   189
grey75                     191   191   191
grey76                     194   194   194
grey77                     196   196   196
grey78                     199   199   199
grey79                     201   201   201
grey80                     204   204   204
grey81                     207   207   207
grey82                     209   209   209
grey83                     212   212   212
grey84                     214   214   214
grey85                     217   217   217
grey86                     219   219   219
grey87                     222   222   222
grey88                     224   224   224
grey89                     227   227   227
grey90                     229   229   229
grey91                     232   232   232
grey92                     235   235   235
grey93                     237   237   237
grey94                     240   240   240
grey95                     242   242   242
grey96                     245   245   245
grey97                     247   247   247
grey98                     250   250   250
grey99                     252   252   252
grey100                    255   255   255
honeydew                   240   255   255
honeydew1                  240   255   255
honeydew2                  224   238   238
honeydew3                  193   205   205
honeydew4                  131   139   139
hot pink                   255   105   105
.CE
.CS
HotPink                    255   105   105
HotPink1                   255   110   110
HotPink2                   238   106   106
HotPink3                   205    96    96
HotPink4                   139    58    58
indian red                 205    92    92
IndianRed                  205    92    92
IndianRed1                 255   106   106
IndianRed2                 238    99    99
IndianRed3                 205    85    85
IndianRed4                 139    58    58
ivory                      255   255   255
ivory1                     255   255   255
ivory2                     238   238   238
ivory3                     205   205   205
ivory4                     139   139   139
khaki                      240   230   230
khaki1                     255   246   246
khaki2                     238   230   230
khaki3                     205   198   198
khaki4                     139   134   134
lavender                   230   230   230
lavender blush             255   240   240
LavenderBlush              255   240   240
LavenderBlush1             255   240   240
LavenderBlush2             238   224   224
LavenderBlush3             205   193   193
LavenderBlush4             139   131   131
lawn green                 124   252   252
LawnGreen                  124   252   252
lemon chiffon              255   250   250
LemonChiffon               255   250   250
LemonChiffon1              255   250   250
LemonChiffon2              238   233   233
LemonChiffon3              205   201   201
LemonChiffon4              139   137   137
light blue                 173   216   216
light coral                240   128   128
light cyan                 224   255   255
light goldenrod            238   221   221
light goldenrod yellow     250   250   250
light gray                 211   211   211
light green                144   238   238
light grey                 211   211   211
light pink                 255   182   182
light salmon               255   160   160
light sea green             32   178   178
light sky blue             135   206   206
light slate blue           132   112   112
light slate gray           119   136   136
light slate grey           119   136   136
light steel blue           176   196   196
light yellow               255   255   255
LightBlue                  173   216   216
LightBlue1                 191   239   239
LightBlue2                 178   223   223
LightBlue3                 154   192   192
LightBlue4                 104   131   131
LightCoral                 240   128   128
LightCyan                  224   255   255
LightCyan1                 224   255   255
LightCyan2                 209   238   238
LightCyan3                 180   205   205
LightCyan4                 122   139   139
LightGoldenrod             238   221   221
LightGoldenrod1            255   236   236
LightGoldenrod2            238   220   220
LightGoldenrod3            205   190   190
LightGoldenrod4            139   129   129
LightGoldenrodYellow       250   250   250
LightGray                  211   211   211
LightGreen                 144   238   238
LightGrey                  211   211   211
LightPink                  255   182   182
LightPink1                 255   174   174
LightPink2                 238   162   162
LightPink3                 205   140   140
LightPink4                 139    95    95
LightSalmon                255   160   160
LightSalmon1               255   160   160
LightSalmon2               238   149   149
LightSalmon3               205   129   129
LightSalmon4               139    87    87
LightSeaGreen               32   178   178
LightSkyBlue               135   206   206
LightSkyBlue1              176   226   226
LightSkyBlue2              164   211   211
LightSkyBlue3              141   182   182
LightSkyBlue4               96   123   123
LightSlateBlue             132   112   112
LightSlateGray             119   136   136
LightSlateGrey             119   136   136
LightSteelBlue             176   196   196
LightSteelBlue1            202   225   225
LightSteelBlue2            188   210   210
LightSteelBlue3            162   181   181
LightSteelBlue4            110   123   123
LightYellow                255   255   255
LightYellow1               255   255   255
LightYellow2               238   238   238
LightYellow3               205   205   205
LightYellow4               139   139   139
lime green                  50   205   205
LimeGreen                   50   205   205
linen                      250   240   240
magenta                    255     0     0
magenta1                   255     0     0
magenta2                   238     0     0
magenta3                   205     0     0
magenta4                   139     0     0
maroon                     176    48    48
maroon1                    255    52    52
maroon2                    238    48    48
maroon3                    205    41    41
maroon4                    139    28    28
medium aquamarine          102   205   205
medium blue                  0     0     0
medium orchid              186    85    85
medium purple              147   112   112
medium sea green            60   179   179
medium slate blue          123   104   104
medium spring green          0   250   250
medium turquoise            72   209   209
medium violet red          199    21    21
MediumAquamarine           102   205   205
MediumBlue                   0     0     0
MediumOrchid               186    85    85
MediumOrchid1              224   102   102
MediumOrchid2              209    95    95
MediumOrchid3              180    82    82
MediumOrchid4              122    55    55
MediumPurple               147   112   112
MediumPurple1              171   130   130
MediumPurple2              159   121   121
MediumPurple3              137   104   104
MediumPurple4               93    71    71
MediumSeaGreen              60   179   179
MediumSlateBlue            123   104   104
MediumSpringGreen            0   250   250
MediumTurquoise             72   209   209
MediumVioletRed            199    21    21
midnight blue               25    25    25
MidnightBlue                25    25    25
mint cream                 245   255   255
MintCream                  245   255   255
misty rose                 255   228   228
MistyRose                  255   228   228
MistyRose1                 255   228   228
MistyRose2                 238   213   213
MistyRose3                 205   183   183
MistyRose4                 139   125   125
moccasin                   255   228   228
navajo white               255   222   222
NavajoWhite                255   222   222
NavajoWhite1               255   222   222
NavajoWhite2               238   207   207
NavajoWhite3               205   179   179
NavajoWhite4               139   121   121
navy                         0     0     0
navy blue                    0     0     0
NavyBlue                     0     0     0
old lace                   253   245   245
OldLace                    253   245   245
olive drab                 107   142   142
OliveDrab                  107   142   142
OliveDrab1                 192   255   255
OliveDrab2                 179   238   238
OliveDrab3                 154   205   205
OliveDrab4                 105   139   139
orange                     255   165   165
orange red                 255    69    69
orange1                    255   165   165
orange2                    238   154   154
orange3                    205   133   133
orange4                    139    90    90
OrangeRed                  255    69    69
OrangeRed1                 255    69    69
OrangeRed2                 238    64    64
OrangeRed3                 205    55    55
OrangeRed4                 139    37    37
orchid                     218   112   112
orchid1                    255   131   131
orchid2                    238   122   122
orchid3                    205   105   105
orchid4                    139    71    71
pale goldenrod             238   232   232
pale green                 152   251   251
pale turquoise             175   238   238
pale violet red            219   112   112
PaleGoldenrod              238   232   232
PaleGreen                  152   251   251
PaleGreen1                 154   255   255
PaleGreen2                 144   238   238
PaleGreen3                 124   205   205
PaleGreen4                  84   139   139
PaleTurquoise              175   238   238
PaleTurquoise1             187   255   255
PaleTurquoise2             174   238   238
PaleTurquoise3             150   205   205
PaleTurquoise4             102   139   139
.CE
.CS
PaleVioletRed              219   112   112
PaleVioletRed1             255   130   130
PaleVioletRed2             238   121   121
PaleVioletRed3             205   104   104
PaleVioletRed4             139    71    71
papaya whip                255   239   239
PapayaWhip                 255   239   239
peach puff                 255   218   218
PeachPuff                  255   218   218
PeachPuff1                 255   218   218
PeachPuff2                 238   203   203
PeachPuff3                 205   175   175
PeachPuff4                 139   119   119
peru                       205   133   133
pink                       255   192   192
pink1                      255   181   181
pink2                      238   169   169
pink3                      205   145   145
pink4                      139    99    99
plum                       221   160   160
plum1                      255   187   187
plum2                      238   174   174
plum3                      205   150   150
plum4                      139   102   102
powder blue                176   224   224
PowderBlue                 176   224   224
purple                     160    32    32
purple1                    155    48    48
purple2                    145    44    44
purple3                    125    38    38
purple4                     85    26    26
red                        255     0     0
red1                       255     0     0
red2                       238     0     0
red3                       205     0     0
red4                       139     0     0
rosy brown                 188   143   143
RosyBrown                  188   143   143
RosyBrown1                 255   193   193
RosyBrown2                 238   180   180
RosyBrown3                 205   155   155
RosyBrown4                 139   105   105
royal blue                  65   105   105
RoyalBlue                   65   105   105
RoyalBlue1                  72   118   118
RoyalBlue2                  67   110   110
RoyalBlue3                  58    95    95
RoyalBlue4                  39    64    64
saddle brown               139    69    69
SaddleBrown                139    69    69
salmon                     250   128   128
salmon1                    255   140   140
salmon2                    238   130   130
salmon3                    205   112   112
salmon4                    139    76    76
sandy brown                244   164   164
SandyBrown                 244   164   164
sea green                   46   139   139
SeaGreen                    46   139   139
SeaGreen1                   84   255   255
SeaGreen2                   78   238   238
SeaGreen3                   67   205   205
SeaGreen4                   46   139   139
seashell                   255   245   245
seashell1                  255   245   245
seashell2                  238   229   229
seashell3                  205   197   197
seashell4                  139   134   134
sienna                     160    82    82
sienna1                    255   130   130
sienna2                    238   121   121
sienna3                    205   104   104
sienna4                    139    71    71
sky blue                   135   206   206
SkyBlue                    135   206   206
SkyBlue1                   135   206   206
SkyBlue2                   126   192   192
SkyBlue3                   108   166   166
SkyBlue4                    74   112   112
slate blue                 106    90    90
slate gray                 112   128   128
slate grey                 112   128   128
SlateBlue                  106    90    90
SlateBlue1                 131   111   111
SlateBlue2                 122   103   103
SlateBlue3                 105    89    89
SlateBlue4                  71    60    60
SlateGray                  112   128   128
SlateGray1                 198   226   226
SlateGray2                 185   211   211
SlateGray3                 159   182   182
SlateGray4                 108   123   123
SlateGrey                  112   128   128
snow                       255   250   250
snow1                      255   250   250
snow2                      238   233   233
snow3                      205   201   201
snow4                      139   137   137
spring green                 0   255   255
SpringGreen                  0   255   255
SpringGreen1                 0   255   255
SpringGreen2                 0   238   238
SpringGreen3                 0   205   205
SpringGreen4                 0   139   139
steel blue                  70   130   130
SteelBlue                   70   130   130
SteelBlue1                  99   184   184
SteelBlue2                  92   172   172
SteelBlue3                  79   148   148
SteelBlue4                  54   100   100
tan                        210   180   180
tan1                       255   165   165
tan2                       238   154   154
tan3                       205   133   133
tan4                       139    90    90
thistle                    216   191   191
thistle1                   255   225   225
thistle2                   238   210   210
thistle3                   205   181   181
thistle4                   139   123   123
tomato                     255    99    99
tomato1                    255    99    99
tomato2                    238    92    92
tomato3                    205    79    79
tomato4                    139    54    54
turquoise                   64   224   224
turquoise1                   0   245   245
turquoise2                   0   229   229
turquoise3                   0   197   197
turquoise4                   0   134   134
violet                     238   130   130
violet red                 208    32    32
VioletRed                  208    32    32
VioletRed1                 255    62    62
VioletRed2                 238    58    58
VioletRed3                 205    50    50
VioletRed4                 139    34    34
wheat                      245   222   222
wheat1                     255   231   231
wheat2                     238   216   216
wheat3                     205   186   186
wheat4                     139   126   126
white                      255   255   255
white smoke                245   245   245
WhiteSmoke                 245   245   245
yellow                     255   255   255
yellow green               154   205   205
yellow1                    255   255   255
yellow2                    238   238   238
yellow3                    205   205   205
yellow4                    139   139   139
YellowGreen                154   205   205
.CE

.SH KEYWORDS
color, option
