#
# Config.mk --
#
# Master configuration file for CXrL SHADOW. This contains all (most?)
# of the system-dependent stuff, such as installation directory paths,
# location of various programs, etc and are set by configure for each
# particular machine. 
#
# DO NOT EDIT Config.mk by hand. It's created automatically by configure
# from Config.mk.in. Edit Config.mk.in instead.
#
# Mumit Khan <khan@xraylith.wisc.edu>
#
# Created: 29-Jul-02
#


#------------------------------------------------------------------------------
# local directory information, such as where the source tree root is,
# where the install tree root is, etc.
#
#
# PRODUCT: CXrL SHADOW product name
# VERSION: What version of product we're building here.
#
# src_root: This is the root of the source tree.
# build_root: This is the root of the build tree (usually == SRC_ROOT)
# CPU: Architecture
# OS: OS name
# PLATFORM: This is the canonical platform name (usually CPU-COMPANY-OS)
#------------------------------------------------------------------------------

PRODUCT=SHADOW
VERSION=2.3.3
build_day=29-Jul-02

src_root=/home/khan/src/cntech/shadow
build_root=/home/khan/src/cntech/BUILD/shadow
CPU=i686
OS=linux-gnu
PLATFORM=i686-pc-linux-gnu

ifeq ($(strip $(srcdir)),)
    srcdir=.
endif

#
# Build EXCON?
#

BUILD_EXCON=yes

#------------------------------------------------------------------------------
#
# Model specific defines. These are also used to pre-process files for
# non-unix systems such as VMS etc.
#
#------------------------------------------------------------------------------

GENERICDEFINES=-DELLWIGG -DSCATTER
VMSDEFINES=$(GENERICDEFINES) -UUNIX -Uunix -Dvms -DVMS
MACDEFINES=$(GENERICDEFINES) -DUNIX -Dunix -Uvms -UVMS \
    $(DEFS) $(CPPFLAGS) $(XCPPFLAGS)

#
# The sources files to pre-process are always named *.F. Might cause 
# problems if junk files are left around with .F extension, but such
# is life.
#
PREPROCSRCS=$(patsubst %.F,%.for,$(shell cd $(srcdir); echo *.F))

ifeq ($(strip $(PREPROCSRCS)),*.for)
    PREPROCSRCS=
endif

#------------------------------------------------------------------------------
#
# SHADOW libraries that other tools need.
#
#------------------------------------------------------------------------------

USE_LIB_FILENAME=yes
ifeq ($(strip $(USE_LIB_FILENAME)),no)
  SHADOW_LIB=-L$(build_root)/src/lib -lshadow
  SHADOW_MATH_LIB=-L$(build_root)/src/tools/math -lmath
  SPG_LIB=-L$(build_root)/src/tools/spg -lspg
  TOOLSET_LIB=-L$(build_root)/src/tools/io -ltoolset
  TEK_GRAPHICS_LIB=-L$(build_root)/src/tools/tek-graphics -ltek-graphics
  MENU_LIB=-L$(build_root)/src/tools/menu -lmenu
  OPCON_LIB=-L$(build_root)/src/tools/opcon -lopcon

  SOURCE_LIB=-L$(build_root)/src/source -lsource
  SOURCE_BM_LIB=-L$(build_root)/src/source/bm -lbm
  SOURCE_ID_LIB=-L$(build_root)/src/source/id -lid

  TRACE_LIB=-L$(build_root)/src/trace -ltrace
else
  SHADOW_LIB=$(build_root)/src/lib/libshadow.a
  SHADOW_MATH_LIB=$(build_root)/src/tools/math/libmath.a
  SPG_LIB=$(build_root)/src/tools/spg/libspg.a
  TOOLSET_LIB=$(build_root)/src/tools/io/libtoolset.a
  TEK_GRAPHICS_LIB=$(build_root)/src/tools/tek-graphics/libtek-graphics.a
  MENU_LIB=$(build_root)/src/tools/menu/libmenu.a
  OPCON_LIB=$(build_root)/src/tools/opcon/libopcon.a

  SOURCE_LIB=$(build_root)/src/source/libsource.a
  SOURCE_BM_LIB=$(build_root)/src/source/bm/libbm.a
  SOURCE_ID_LIB=$(build_root)/src/source/id/libid.a

  TRACE_LIB=$(build_root)/src/trace/libtrace.a
endif

#------------------------------------------------------------------------------
#
# Weird libraries that only exist for some SVR4 machines, such as solaris.
#
#------------------------------------------------------------------------------
SOCKET_LIBS=

#------------------------------------------------------------------------------
# X is often in strange places, override what configure figured out if
# its wrong.
#------------------------------------------------------------------------------

HAVE_XWINDOWS=yes
#
# if HAVE_XWINDOWS = no, then the following two variables *HAVE TO BE* 
# empty.
#
XINCLUDES=-I/usr/X11R6/include
XLIBSW=-L/usr/X11R6/lib -lX11 ${SOCKET_LIBS}

#------------------------------------------------------------------------------
# The directory containing Curses/Ncurses/etc. Linux needs ncurses, SunOS
# needs SYSV curses, Cygwin uses ncurses ... 
#
# For i686-*-mingw*, use the following:
#    CURSES_LIBS=$(CURSES_LIBDIR)/pdcurses.a -lkernel32 -luser32
# configure should've done this already.
#
#------------------------------------------------------------------------------

USE_PDCURSES=no
CURSES_INCDIR=/usr/include/ncurses
CURSES_LIBDIR=-L/home/khan/src/cntech/BUILD/shadow/lib

CURSES_INCLUDES=-I$(CURSES_INCDIR)
CURSES_LIBS=-L$(CURSES_LIBDIR) -lncurses

#------------------------------------------------------------------------------
# C compiler and debug/optimization/profiling flag to use.  Set by configure,
# and are normally overridden on the make command line (make CFLAGS=-g).  The
# can also be overridden here.
#------------------------------------------------------------------------------

CROSS_COMPILING=no

CPP=gcc -E
DEFS= -DHAVE_LIMITS_H=1 -DHAVE_STRING_H=1 -DHAVE_UNISTD_H=1 -DHAVE_DRAND48=1 -DHAVE_GETCWD=1 -DHAVE_GETWD=1 -DHAVE_UNION_WAIT=1 -DHAVE_XWINDOWS=1  
CPPFLAGS=-I. -I$(srcdir) -I/home/khan/src/cntech/BUILD/shadow/src/include -I/home/khan/src/cntech/shadow/src/include
HOST_CPPFLAGS=-DLINUX_F2C_MAIN_HACK=1 -DG77 -DHAVE_F77_CPP=1 -DNEED_ACOSD=1 -DLINUX -Dunix -DUSE_C_IO=1
ALL_CPPFLAGS=$(DEFS) $(CPPFLAGS) $(HOST_CPPFLAGS) $(XCPPFLAGS)
# note the difference between ALL_CPPFLAGS and ALL_FCPPFLAGS. This is
# necessary since some of the FORTRAN preprocs won't allow macros
# with double quotes and it gets messy (eg., on Solaris 2.x).
ALL_FCPPFLAGS=$(DEFS) $(CPPFLAGS) $(HOST_CPPFLAGS) $(XFCPPFLAGS)

CC=gcc
USING_GCC=yes
CFLAGS=-g -O2
HOST_CFLAGS=
CC_DEBUG_FLAGS=@CC_DEBUG_FLAGS@
CC_OPTIM_FLAGS=@CC_OPTIM_FLAGS@
ALL_CFLAGS=$(CFLAGS) $(HOST_CFLAGS) $(XCFLAGS)

CXX=c++
USING_GXX=yes
CXXFLAGS=-g -O2
CXX_DEBUG_FLAGS=@CXX_DEBUG_FLAGS@
CXX_OPTIM_FLAGS=@CXX_OPTIM_FLAGS@
# CXX_TEMPLATE_FLAGS=
CXX_TEMPLATE_FLAGS=
HOST_CXXFLAGS=
ALL_CXXFLAGS=$(CXX_TEMPLATE_FLAGS) $(HOST_CXXFLAGS) \
    $(CXXFLAGS) $(XCXXFLAGS)

SUNPRO_CXX=
COMPAQ_CXX=

FC=g77
USING_G77=yes
FC_CPP=gcc -E
HOST_FFLAGS=-fdollar-ok -DG77 -Dunix  -fno-automatic
HOST_FLIBS=
FFLAGS=-O
FC_DEBUG_FLAGS=@FC_DEBUG_FLAGS@
FC_OPTIM_FLAGS=@FC_OPTIM_FLAGS@
ALL_FFLAGS=$(HOST_FFLAGS) $(FFLAGS) $(XFFLAGS)

NEED_G77_COMPAT_LIB=no

BRAINDEAD_FC_DRIVER=no
HP_F77_BUGGY_NAMELIST=no

#
# OSF fortran needs -nofor_main if the main not a FORTRAN program.
#
HOST_FFLAGS_C_MAIN=

# some machines need special libraries (eg., -ladvapi32 for win32 to access
# registry functions. HOST_FLIBS is typically set to this, and that's what
# FORTRAN programs use at link time; C programs should use this instead.
HOST_LIBS=

HOST_LDFLAGS=-Wl,-u,MAIN__  -Wl,-rpath,/usr/local/shadow-2.3.3/lib:
LDFLAGS=
ALL_LDFLAGS=$(HOST_LDFLAGS) $(LDFLAGS) $(XLDFLAGS)

CXX_LD=$(CXX) $(ALL_LDFLAGS)
CC_LD=$(CC) $(ALL_LDFLAGS)
FC_LD=$(FC) $(ALL_LDFLAGS)

MATH_LIBS=-lieee -lm

#------------------------------------------------------------------------------
# EXtra flags:
#   o XCFLAGS - Extra compiler flags on all compiles and links
#   o XLDFLAGS - Extra compiler flags to specify at link time.
#   o XLDLIBS - Extra libraries to use at link time.
#
# These are specified in local makefiles.
#------------------------------------------------------------------------------

XCPPFLAGS=
XCFLAGS=
XCXXFLAGS=
XFFLAGS=
XLDFLAGS=
XLDLIBS=

#------------------------------------------------------------------------------
# Definition of programs you wish to use. All but "ar" and "strip" are set by
# configure in the Makefiles, but they can be overridden here.
#------------------------------------------------------------------------------

RANLIB=ranlib
INSTALL=/usr/bin/install -c
INSTALL_BINFLAGS=-s
INSTALL_LIBFLAGS=-m 0644
INSTALL_DATAFLAGS=-m 0444
INSTALL_SCRIPTFLAGS=
INSTALL_HEADERFLAGS=-m 0444
INSTALL_TCLFLAGS=-m 0444

LN_S=ln -s
AR=ar
ARFLAGS=crv
NM=nm
STRIP=strip
ECHO=echo
CHMOD=/bin/chmod

STRIPPROG=strip
export STRIPPROG

exeext=
objext=.o
libext=.a
scriptext=

#------------------------------------------------------------------------------
# Where to install various things.
#
# SHADOW_BIN_DIR: binaries
# SHADOW_LIB_DIR: various libraries and binary data files.
# SHADOW_DATA_DIR: Runtime data files needed by various programs.
# SHADOW_TCL_DIR: Tcl scripts
# SHADOW_SCRIPTS_DIR: Various interpreted scripts.
# SHADOW_INCLUDE_DIR: Include files
# SHADOW_MAN_DIR: Man pages
#
#------------------------------------------------------------------------------

# ==================== Where To Install Things ====================

# The default location for installation.  Everything is placed in
# subdirectories of this directory.  The default values for many of
# the variables below are expressed in terms of this one, so you may
# not need to change them.  This defaults to /usr/local.
prefix=/usr/local/shadow-2.3.3

# Like `prefix', but used for architecture-specific files.
exec_prefix=${prefix}

SHADOW_BIN_DIR=${exec_prefix}/bin
SHADOW_LIB_DIR=${exec_prefix}/lib
SHADOW_DATA_DIR=${prefix}/data
SHADOW_SCRIPTS_DIR=${prefix}/scripts
SHADOW_TCL_DIR=${prefix}/lib/tcl
SHADOW_INCLUDE_DIR=${prefix}/include
SHADOW_MAN_DIR=${prefix}/man

#==============================================================================

#
# default install targets.
#


STANDARD_TARGETS := \
    all install includes test \
    install_lib install_bin install_script install_data install_binary_data \
    install_hdr install_tcl install_demo install_test \
    clean clean_bin clean_lib clean_binary_data distclean depend relink

.PHONY : $(STANDARD_TARGETS)

all:
$(STANDARD_TARGETS):

.PHONY : do_install
do_install: do_all \
    do_install_lib do_install_bin do_install_script do_install_data \
    do_install_hdr do_install_tcl

.PHONY : do_all
do_all: all $(LIBRARIES) $(PROGRAMS) $(DATAFILES) $(BINARYDATA) \
    $(SCRIPTS) $(TCL_SCRIPTS)

.PHONY : do_install_lib
do_install_lib: $(LIBRARIES)
	@if [ -z "$(LIBRARIES)" ]; then \
	    exit 0; \
	else \
	    if [ ! -d $(SHADOW_LIB_DIR) ]; then \
		echo "Creating target directory $(SHADOW_LIB_DIR)"; \
		mkdir $(SHADOW_LIB_DIR); \
	    fi; \
	fi; \
	for i in `echo $(LIBRARIES)`; do \
	    echo "installing library $$i as $(SHADOW_LIB_DIR)/`basename $$i`"; \
	    $(INSTALL) $(INSTALL_LIBFLAGS) $$i $(SHADOW_LIB_DIR)/`basename $$i`; \
	    $(RANLIB) $(SHADOW_LIB_DIR)/`basename $$i`; \
	done

.PHONY : do_install_bin
do_install_bin: $(PROGRAMS)
	@if [ -z "$(PROGRAMS)" ]; then \
	    exit 0; \
	else \
	    if [ ! -d $(SHADOW_BIN_DIR) ]; then \
		echo "Creating target directory $(SHADOW_BIN_DIR)"; \
		mkdir $(SHADOW_BIN_DIR); \
	    fi; \
	fi; \
	for i in `echo $(PROGRAMS)`; do \
	    dest="$(SHADOW_BIN_DIR)/`basename $$i`";\
	    echo "installing binary $$i as $$dest"; \
	    $(INSTALL) $(INSTALL_BINFLAGS) $$i $$dest; \
	done

.PHONY : do_install_script
do_install_script: $(SCRIPTS)
	@if [ -z "$(SCRIPTS)" ]; then \
	    exit 0; \
	else \
	    if [ ! -d $(SHADOW_BIN_DIR) ]; then \
		echo "Creating target directory $(SHADOW_BIN_DIR)"; \
		mkdir $(SHADOW_BIN_DIR); \
	    fi; \
	fi; \
	for i in `echo $(SCRIPTS)`; do \
	    dest="$(SHADOW_BIN_DIR)/`basename $$i`$(scriptext)";\
	    if test -f $$i; then \
	        src=$$i; \
	    else \
	        src=$(srcdir)/$$i; \
	    fi; \
	    echo "installing script $$src as $$dest"; \
	    $(INSTALL) $(INSTALL_SCRIPTFLAGS) $$src $$dest; \
	done

.PHONY : do_install_data
do_install_data: $(DATAFILES)
	@if [ -z "$(DATAFILES)" ]; then \
	    exit 0; \
	else \
	    if [ ! -d $(SHADOW_DATA_DIR) ]; then \
		echo "Creating target directory $(SHADOW_DATA_DIR)"; \
		mkdir $(SHADOW_DATA_DIR); \
	    fi; \
	fi; \
	for i in `echo $(DATAFILES)`; do \
	    dest="$(SHADOW_DATA_DIR)/`basename $$i`";\
	    if test -f $$i; then \
	        src=$$i; \
	    else \
	        src=$(srcdir)/$$i; \
	    fi; \
	    echo "installing data $$src as $$dest"; \
	    $(INSTALL) $(INSTALL_DATAFLAGS) $$src $$dest; \
	done

.PHONY : do_install_hdr
do_install_hdr: $(HEADERS)
	@if [ -z "$(HEADERS)" ]; then \
	    exit 0; \
	else \
	    if [ ! -d $(SHADOW_INCLUDE_DIR) ]; then \
		echo "Creating target directory $(SHADOW_INCLUDE_DIR)"; \
		mkdir $(SHADOW_INCLUDE_DIR); \
	    fi; \
	fi; \
	if [ ! -z "$(PACKAGE)" -a ! -d $(SHADOW_INCLUDE_DIR)/$(PACKAGE) ]; then \
	    echo "Creating target directory $(SHADOW_INCLUDE_DIR)/$(PACKAGE)"; \
	    mkdir $(SHADOW_INCLUDE_DIR)/$(PACKAGE); \
	fi; \
	for i in `echo $(HEADERS)`; do \
	    if test -f $$i; then \
	        src_hdr=$$i; \
	    else \
		src_hdr=$(srcdir)/$$i; \
	    fi; \
	    target_hdr=$(SHADOW_INCLUDE_DIR)/$(PACKAGE)/`basename $$i`; \
	    diff $$src_hdr $$target_hdr >/dev/null 2>&1; \
	    if [ $$? -ne 0 ]; then \
		echo "installing header $$src_hdr as $$target_hdr"; \
		$(INSTALL) $(INSTALL_HEADERFLAGS) $$src_hdr $$target_hdr; \
	    else \
		true; \
	    fi \
	done

#
# NEEDS WORK.
#
# How about running auto_mkindex and friends?
#
.PHONY : do_install_tcl
do_install_tcl: $(TCL_SCRIPTS)
	@if [ -z "$(TCL_SCRIPTS)" ]; then \
	    exit 0; \
	else \
	    if [ ! -d $(SHADOW_TCL_DIR) ]; then \
		echo "Creating target directory $(SHADOW_TCL_DIR)"; \
		mkdir $(SHADOW_TCL_DIR); \
	    fi; \
	fi; \
	if [ ! -z "$(PACKAGE)" -a ! -d $(SHADOW_TCL_DIR)/$(PACKAGE) ]; then \
	    echo "Creating target directory $(SHADOW_TCL_DIR)/$(PACKAGE)"; \
	    mkdir $(SHADOW_TCL_DIR)/$(PACKAGE); \
	fi; \
	for i in `echo $(TCL_SCRIPTS)`; do \
	    src_tcl=$(srcdir)/$$i; \
	    target_tcl=$(SHADOW_TCL_DIR)/$(PACKAGE)/`basename $$i`; \
	    diff $$src_tcl $$target_tcl >/dev/null 2>&1; \
	    if [ $$? -ne 0 ]; then \
		echo "installing tcl script $$src_tcl as $$target_tcl"; \
		$(INSTALL) $(INSTALL_TCLFLAGS) $$src_tcl $$target_tcl; \
	    else \
		true; \
	    fi \
	done

.PHONY : do_clean
do_clean: do_clean_bin do_clean_lib do_clean_binary_data
	-rm -f $(OBJS) *.o core a.out *~ 
ifeq ("$(COMPAQ_CXX)","yes")
	-rm -rf cxx_repository
endif

.PHONY : do_clean_lib
do_clean_lib: 
	-if test -n "$(LIBRARIES)"; then rm -f $(LIBRARIES); fi

.PHONY : do_clean_bin
do_clean_bin:
	-if test -n "$(PROGRAMS)"; then rm -f $(PROGRAMS); fi

.PHONY : do_clean_binary_data
do_clean_binary_data: 
	-if test -n "$(BINARYDATA)"; then rm -f $(BINARYDATA); fi

.PHONY : do_distclean
do_distclean: clean
	-rm -f Makefile deps.mk

.PHONY : subdir_do
subdir_do: 
	@case '${MFLAGS}' in *[ik]*) set +e;; esac; \
	for x in `echo $(SUBDIRS)`; \
    	do \
		${MAKE} -C $$x ${MFLAGS} $(DO); \
	done

relink: do_clean_bin

do_preprocess: $(PREPROCSRCS)

preprocess: do_preprocess
	@if test -n "$(SUBDIRS)"; then \
	    case '${MFLAGS}' in *[ik]*) set +e;; esac; \
	    for x in `echo $(SUBDIRS)`; \
	    do \
		    ${MAKE} -C $$x ${MFLAGS} preprocess; \
	    done; \
	fi

make-vms-files:
	-@if test -n "$(VMSFILES)"; then \
	    vmsfiles=$(patsubst %,$(srcdir)/%,$(VMSFILES)); \
	    cp $$vmsfiles . ;\
	    $(ECHO) "## Copying VMSFILES $(VMSFILES) ... Done"; \
	fi
	@$(MAKE) $(MFLAGS) ALL_CPPFLAGS='$(VMSDEFINES)' do_preprocess
	@$(MAKE) $(MFLAGS) ALL_CPPFLAGS='$(VMSDEFINES)' DO=$@ subdir_do

make-mac-files:
	-@if test -n "$(MACFILES)"; then \
	    vmsfiles=$(patsubst %,$(srcdir)/%,$(MACFILES)); \
	    cp $$vmsfiles . ;\
	    $(ECHO) "## Copying MACFILES $(MACFILES) ... Done"; \
	fi
	@$(MAKE) $(MFLAGS) ALL_CPPFLAGS='$(MACDEFINES)' do_preprocess
	@$(MAKE) $(MFLAGS) ALL_CPPFLAGS='$(MACDEFINES)' DO=$@ subdir_do


#------------------------------------------------------------------------------
# 
# How to build things. Various rules.
#
#------------------------------------------------------------------------------

# How to make .o files from .c files:

%.obj: %.c
	$(CC) -o $@ -c $(ALL_CPPFLAGS) $(ALL_CFLAGS) $<

%.o: %.c
	$(CC) -o $@ -c $(ALL_CPPFLAGS) $(ALL_CFLAGS) $<

%.o: %.cc
	$(CXX) -o $@ -c $(ALL_CPPFLAGS) $(ALL_CXXFLAGS) $<

%.obj: %.cc
	$(CXX) -o $@ -c $(ALL_CPPFLAGS) $(ALL_CXXFLAGS) $<

ifeq ($(BRAINDEAD_FC_DRIVER),yes)
%.obj: %.F
	-rm -f $*..f
	$(FC_CPP) -P $(ALL_FCPPFLAGS) $< > $*..f && \
	$(FC) -c $(ALL_FFLAGS) -o $*$(objext) $*..f && rm -f $*..f
%.o: %.F
	-rm -f $*..f
	$(FC_CPP) -P $(ALL_FCPPFLAGS) $< > $*..f && \
	$(FC) -c $(ALL_FFLAGS) -o $*$(objext) $*..f && rm -f $*..f
else
%.obj: %.F
	$(FC) -o $@ -c $(ALL_FCPPFLAGS) $(ALL_FFLAGS) $<
%.o: %.F
	$(FC) -o $@ -c $(ALL_FCPPFLAGS) $(ALL_FFLAGS) $<
endif
%.obj: %.f
	$(FC) -o $@ -c $(ALL_FFLAGS) $<
%.o: %.f
	$(FC) -o $@ -c $(ALL_FFLAGS) $<

%.for: %.F
	$(FC_CPP) -P $(ALL_FCPPFLAGS) $< > $@
