#!/bin/sh
#
# excon-cleanup: cleanup script to clean unneeded files
#
# Author: Mumit Khan <khan@xraylith.wisc.edu>
#
# ----------------------------------------------
#	       SHADOW
#    Center for X-ray Lithography
#  University of Wisconsin-Madison
#  3731 Schneider Dr., Stoughton, WI, 53589
# ------------------------------------------------
#
#

# environment variables that this shell script sets/changes:
# export VARIABLES.

# error message function
error () {
    echo "`basename $0`: $@" 1>&2
    exit 1
}

# usage message function
usage () {
    if [ ! -z "$@" ]; then
	echo "`basename $0`: $@" 1>&2
    fi
    echo "Usage: `basename $0` -g GFILE [-help] [-debug]" 1>&2
    exit 1
}


# don't bother to continue if SHADOW environmet isn't set up properly.
if [ -z "${SHADOW_ROOT}" ]; then
	error \
"SHADOW environment is not properly setup for this script
to run.  Set the environment variables via the \`\`.shadowrc'' shell script 
provided with SHADOW distribution."
fi

# Now all the programs that we need to run.

#
# set up the variables, including the ones from EXCON.
#
GFILE=				# name of gfile to read from.
SCREENFILES=			# screen files to delete
CLEANUP=all			# all/screen/mirr
VERBOSE=0			# 0 for quiet

# Parse command line args.
while [ $# -gt 0 ]; do
    case "$1" in
	-g)
	    if [ $# -lt 2 ]; then
		usage "$1 option requires a gfile name"
	    fi
	    shift
	    GFILE="$1"
	    ;;
	-debug|-d)
	    set -x
	    ;;
	-verbose|-v)
	    VERBOSE=1
	    ;;
	-help|-h)
	    usage ""
	    ;;
	*)
	    usage "Illegal command line option $1"
	    ;;
    esac
    shift
done


#
# check sanity
#

# FUNCTION get a parameter value from a gfile.
getgparam() {
    echo `cat "$GFILE" | grep -i "$1" | awk -F= '{print $2}'`
}

#
# don't need any gfiles for now. Fix later.
#

#if [ -z "${GFILE}" ]; then
#    usage "No GFILE name supplied."
#fi

#
# check whether to use -n, \c, or newline-tab for echo
#
if (echo "testing\c"; echo 1,2,3) | grep c >/dev/null; then
  # Stardent Vistra SVR4 grep lacks -e, says ghazi@caip.rutgers.edu.
  if (echo -n testing; echo 1,2,3) | sed s/-n/xn/ | grep xn >/dev/null;
then
    ac_n= ac_c='
' ac_t='        '
  else
    ac_n=-n ac_c= ac_t=
  fi
else
  ac_n= ac_c='\c' ac_t=
fi

# 
# FUN begins.
#


#
# for now we delete all MIRR and SCREEN files. Eventually will add some
# parameters to specify exactly which ones to kill.
#
#

SCREENFILES="`/bin/ls screen.[0-9][0-9][0-9][0-9].screen.trace* 2>/dev/null`"

if [ ! -z "$SCREENFILES" ]; then
    echo "Deleting screen files:"
    for i in ${SCREENFILES}; do
	echo $ac_n "    $i ... " $ac_c
	rm $i </dev/null 
	if [ -f $i -o !? -ne 0 ]; then
	    echo " ERROR: cannot delete."
	else
	    echo " deleted."
	fi
    done
fi

exit 0
