'\"
'\" $Id: tix.n,v 1.1.1.1 2002/04/02 03:50:26 khan Exp $
'\"
'\" Copyright (c) 1993-1999 Ioi Kim Lam.
'\" Copyright (c) 2000-2001 Tix Project Group.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1.1.1 2002/04/02 03:50:26 khan Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
'\" copyrighted: (c) 1990 The Regents of the University of California.
'\"              (c) 1994-1995 Sun Microsystems, Inc.
'\" The license terms of the Tcl/Tk distrobution are in the file
'\" license.tcl.
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1.1.1 2002/04/02 03:50:26 khan Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH tix n 8.0 Tix "Tix Built-In Commands"
.BS
'\"
.SH NAME
tix \- Manipulate internal states of the Tix library
'\"
.SH SYNOPSIS
\fBtix\fR \fIoption \fR?\fIarg arg ...\fR?
'\"
'\"----------------------------------------------------------------------
.SH "CONFIGURATION OPTIONS"
'\"
This manual page descripts the \fBtix\fR command, which manipulates
the internal states of the Tix library. If you're looking for a general
introduction to the Tix library, please refer to the \fBTixIntro\fR
manual page.
.PP
The Tix application context supports the following configuration
options. Usually, these options are set using the X resource database,
i.e., in the user's \fB\.Xdefault\fR file. For example, to choose a
different color scheme for the Tix widgets, these two lines can be
added to the user's \fB\.Xdefault\fR file:
.RS
.CS
*TixScheme:  Gray
*TixFontSet: 14Point
.CE
.RE
'\"
'\"----------BEGIN
.OP -binding binding Binding
This is an obsolete option.
'\"----------END
'\"
'\"----------BEGIN
.OP \-debug debug Debug
Specifies whether the Tix widgets should run in debug mode.
'\"----------END
'\"
'\"
'\"----------BEGIN
.OP \-fontset tixFontSet TixFontSet
Specifies the fontset to use for the Tix widgets. Valid options are
\fBWmDefault\fR,
\fBTK\fR, \fBTkWin\fR, \fB12Point\fR and \fB14Point\fR. \fBTK\fR specifies that the
standard TK fonts should be used. The default value is \fBWmDefault\fR.
'\"----------END
'\"
'\"----------BEGIN
.OP \-scheme tixScheme TixScheme
Specifies the color scheme to use for the Tix widgets. Valid options
are \fBWmDefault\fR,
\fBTK\fR, \fBTkWin\fR, \fBGray\fR, \fBBlue\fR, \fBBisque\fR, \fBSGIGray\fR and
\fBTixGray\fR. If you want the
standard TK color scheme, you can use the value \fBTK\fR. 
The default value is \fBWmDefault\fR.
 '\"----------END
'\"
'\"
'\"----------BEGIN
.OP \-schemepriority tixSchemePriority TixSchemePriority
Specifies the priority level of the TK options set by th Tix
schemes. Please refer to the TK \fBoption(n)\fR manual page for a
discussion of the priority level of Tix options. The default value is
79, which makes the Tix schemes at a higher priority than the
settings in the .Xdefaults file. If you want to allow the Tix schemes
to be overridden by the settings in the .Xdefaults file, you can set
the following line in you .Xdefaults file:
.CS
*TixSchemePriority: 21
.CE
'\"----------END
'\"
.BE
.SH DESCRIPTION
.PP
The \fBtix\fR command provides access to miscellaneous elements of
Tix's internal state and the Tix \fBapplication context\fR.  Most of
the information manipulated by this command pertains to the
application as a whole, or to a screen or display, rather than to a
particular window.  The command can take any of a number of different
forms depending on the \fIoption\fR argument.  The legal forms are:
'\"
.TP
\fBtix addbitmapdir\fR \fIdirectory\fR
'\"
Tix maintains a list of directory under which which the \fBtix
getimage\fR and \fBtix getbitmap\fR commands will search for image
files. The standard bitmap directory is
\fB$TIX_LIBRARY/bitmaps\fR. The \fBaddbitmapdir\fR command adds
\fIdirectory\fR into this list. By using this command, the image files
of an applications can also be located using the \fBtix getimage\fR ot
\fBtix getbitmap\fR command.
'\"
.TP
\fBtix cget\fR \fIoption\fR
'\"
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may be any of the options described in the
\fBCONFIGURATION OPTIONS\fR section.
'\"
.TP
\fBtix configure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'\"
Query or modify the configuration options of the Tix application
context. If no \fIoption\fR is specified, returns a list describing
all of the available options (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s); in this case
the command returns an empty string. \fIOption\fR may be any of the
options described in the \fBCONFIGURATION OPTIONS\fR section.
'\"
'\"
.TP
\fBtix filedialog \fR?\fIclass\fR?
'\"
Returns the file selection dialog that may be shared among different
modules of this application. This command will create a file selection
dialog widget when it is called the first time. This dialog will be
returned by all subsequent calls to \fBtix filedialog\fR. An optional
\fIclass\fR parameter can be passed to specified what type of file
selection dialog widget is desired. Possible options are
\fBtixFileSelectDialog\fR or \fBtixExFileSelectDialog.\fR
'\"
.TP
\fBtix getbitmap \fIname\fR
'\"
Locates a bitmap file of the name \fIname\fR.xpm or \fIname\fR in one
of the bitmap directories (see the \fBaddbitmapdir\fR command
above). By using \fBtix getbitmap\fR, you can advoid hard coding the
pathnames of the bitmap files in your application. When successful, it
returns the complete pathname of the bitmap file, prefixed with the
character \fB@\fR.  The returned value can be used to configure the
\fB\-bitmap\fR option of the TK and Tix widgets.
'\"
.TP
\fBtix getimage \fIname\fR
'\"
Locates an image file of the name \fIname\fR.xpm, \fIname\fR.xbm or
\fIname\fR.ppm in one of the bitmap directories (see the
\fBaddbitmapdir\fR command above). If more than one file with the same
name (but different extensions) exist, then the image type is chosen
according to the depth of the X display: xbm images are chosen on
monochrome displays and color images are chosen on color displays. By
using \fBtix getimage\fR, you can advoid hard coding the pathnames of
the image files in your application. When successful, this command
returns the name of the newly created image, which can be used to
configure the \fB\-image\fR option of the TK and Tix widgets.
'\"
'\"
.TP
\fBtix option\fR ?\fIargs ...\fR?
'\"
Manipulates the options manitained by the Tix scheme
mechanism. Available options are:
.CS
active_bg   active_fg   bg
bold_font   dark1_bg    dark1_fg
dark2_bg    dark2_fg    disabled_fg
fg          fixed_font  font    
inactive_bg inactive_fg input1_bg    
input2_bg   italic_font light1_bg
light1_fg   light2_bg   light2_fg
menu_font   output1_bg  output2_bg
select_bg   select_fg   selector
.CE
The arguments to the \fBtix option\fR command can take the
following form(s):
.RS
.TP
\fBtix option get\fR \fIoption\fR
'\"
Returns the current value of \fIoption\fR.
.RE
'\"
'\"
.TP
\fBtix resetoptions\fR \fInewScheme newFontSet\fR ?\fInewScmPrio\fR?
'\"
'\"
Resets the scheme and fontset of the Tix application to
\fInewScheme\fR and \fInewFontSet\fR, respectively. This affects only
those widgets created \fBafter\fR this call. Therefore, it is best to
call the \fBresetoptions\fR command \fBbefore\fR the creation of any
widgets in a Tix application.

The optional parameter \fInewScmPrio\fR can be given to reset the
priority level of the TK options set by the Tix schemes.
'\"
'\"
.SH BUGS
'\"
.IP [1]
In this release of Tix, the following configuration options have been
disabled. Assigning values to them will cause no effect:
.CS
-binding
-debug
-fontset
-scheme
-schemepriority
.CE
In addition, the following options to the \fBtix\fR command have been
disabled. Invoking the \fBtix\fR command with these options will cause
no effect:
.CS
resetoptions
.CE
.IP [2]
Because of the way TK handles the X option database, after tixwish has
started up, it is not possible to reset the color schemes and font
sets using the \fBtix config\fR command. Instead, the \fBtix
resetoptions\fR command must be used.
'\"
.PP
The tk_setPalette command does not work very well under Tix. To use
it, one must follow these steps:
.RS
.CS
tix resetoptions TK TK
tk_setPalette lightblue
.CE
.RE
'\"
.SH KEYWORDS
file selection dialog

