#
# prefs.tcl: routines for SHADOW GUI personal preferences
#
# ------------------------------------------------
# Mumit Khan <khan@xraylith.wisc.edu>
# Center for X-ray Lithography
# University of Wisconsin-Madison
# 3731 Schneider Dr., Stoughton, WI, 53589
# ------------------------------------------------
#
# Copyright (c) 1994-1997 Mumit Khan
#
#

#
# public routines:
#
# prefs:load		    -  load preferences from file/registry
# prefs:save		    -  load preferences to file/registry
# prefs:reset_to_default  -  resets to the built-in defaults
# 

#
# LOAD_PREFS: load user-specific preferences
#
proc prefs:load {} {
    global tcl_platform
    if {[string compare $tcl_platform(platform) "unix"] == 0} {
        return [prefs:load_unix]
    } elseif {[string compare $tcl_platform(platform) "windows"] == 0} {
        return [prefs:load_win]
    }
}

#
# SAVE_PREFS: save current preference
#
proc prefs:save {} {
    global tcl_platform
    if {[string compare $tcl_platform(platform) "unix"] == 0} {
        return [prefs:save_unix]
    } elseif {[string compare $tcl_platform(platform) "windows"] == 0} {
        return [prefs:save_win]
    }
}

proc prefs:reset_to_default {} {
    global gvars gprefs gdefprefs
    foreach var $gvars(prefvars) {
        catch {set gprefs($var) $gdefprefs($var)}
    }
}


if 0 {

# Tix Demostration Program
#
# This sample program is structured in such a way so that it can be
# executed from the Tix demo program "widget": it must have a
# procedure called "RunSample". It should also have the "if" statment
# at the end of this file so that it can be run as a standalone
# program using tixwish.

# This file demonstrates the use of the tixNoteBook widget, which allows
# you to lay out your interface using a "notebook" metaphore
#

proc prefs:create {} {

    set top .preferences
    catch destroy $top

    toplevel $top ;

    # We use these options to set the sizes of the subwidgets inside the
    # notebook, so that they are well-aligned on the screen.
    #
    set name [tixOptionName $w]
    # option add *$name*TixControl*label.anchor e

    set w1 [frame 

    # Create the notebook widget and set its backpagecolor to gray.
    # Note that the -backpagecolor option belongs to the "nbframe"
    # subwidget.
    tixNoteBook $w.nb -ipadx 6 -ipady 6
    $w config -bg gray
    $w.nb subwidget nbframe config -backpagecolor gray

    # Create the two tabs on the notebook. The -underline option
    # puts a underline on the first character of the labels of the tabs.
    # Keyboard accelerators will be defined automatically according
    # to the underlined character.	
    #
    $w.nb add startup    -label "Startup"         -underline 0
    $w.nb add appearance -label "Appearance"      -underline 0
    $w.nb add dirs       -label "Directories"     -underline 0
    $w.nb add helpers    -label "Helper Programs" -underline 0
    $w.nb add debugging  -label "Debugging"       -underline 3
    pack $w.nb -expand yes -fill both -padx 5 -pady 5 -side top
    
    #----------------------------------------
    # Create the first page
    #----------------------------------------
    set f [$w.nb subwidget startup]

    # Create two frames: one for the common buttons, one for the
    # other widgets
    #
    frame $f.f
    frame $f.common
    pack $f.f      -side left  -padx 2 -pady 2 -fill both -expand yes
    pack $f.common -side right -padx 2 -pady 2 -fill y

    # Create the controls that only belong to this page
    #
    tixControl $f.f.a -value 12   -label "Access Time: "
    tixControl $f.f.w -value 400  -label "Write Throughput: "
    tixControl $f.f.r -value 400  -label "Read Throughput: "
    tixControl $f.f.c -value 1021 -label "Capacity: "
    pack $f.f.a $f.f.w $f.f.r $f.f.c  -side top -padx 20 -pady 2

    # Create the common buttons
    #
    prefs:_CreateCommonButtons $w $f.common
    
    #----------------------------------------
    # Create the second page	
    #----------------------------------------
    set f [$w.nb subwidget appearance]

    frame $f.f
    frame $f.common
    pack $f.f      -side left  -padx 2 -pady 2 -fill both -expand yes
    pack $f.common -side right -padx 2 -pady 2 -fill y

    tixControl $f.f.a -value 12   -label "Access Time: "
    tixControl $f.f.w -value 400  -label "Write Throughput: "
    tixControl $f.f.r -value 400  -label "Read Throughput: "
    tixControl $f.f.c -value 1021 -label "Capacity: "
    tixControl $f.f.u -value 10   -label "Users: "

    pack $f.f.a $f.f.w $f.f.r $f.f.c $f.f.u -side top -padx 20 -pady 2

    prefs:_CreateCommonButtons $w $f.common
}

proc prefs:_CreateCommonButtons {w f} {
    button $f.ok     -text OK     -width 6 -command "destroy $w"
    button $f.cancel -text Cancel -width 6 -command "destroy $w"

    pack $f.ok $f.cancel -side top -padx 2 -pady 2
}

if {![info exists tix_demo_running]} {
    wm withdraw .
    set w .demo
    toplevel $w
    RunSample $w
	bind $w <Destroy> {if {"%W" == ".demo"} exit}
}

}
