#
# prefs-win.tcl: routines for SHADOW GUI personal preferences for Windows
#
# ------------------------------------------------
# Mumit Khan <khan@xraylith.wisc.edu>
# Center for X-ray Lithography
# University of Wisconsin-Madison
# 3731 Schneider Dr., Stoughton, WI, 53589
# ------------------------------------------------
#
# Copyright (c) 1994-1997 Mumit Khan
#
#

#
# These are all private routines called by the prefs: module (prefs.tcl)
#
# prefs:load_win	    -  load preferences from file/registry
# prefs:save_win	    -  load preferences to file/registry
# 

#
# LOAD_PREFS: load user-specific preferences for Windows
#
proc prefs:load_win {} {
    global gvars gprefs
    # key is HKEY_CURRENT_USER\\SOFTWARE\\CXrL\\SHADOW\\Preferences
    set key $gvars(pref_file)
    if [catch {registry values $key *} varnames] {return} 
    vputs "Loading preferences from $key..."

    global gprefs
    foreach var $varnames {
        set value [string trim [registry get $key $var]]
	set var [string trim $var]
	set gprefs($var) $value
    }
    vputs "Loaded preferences from $key."
    return 0
}

#
# SAVE_PREFS: save current preference for windows
#
proc prefs:save_win {} {
    global gvars gprefs
    # key is HKEY_CURRENT_USER\\SOFTWARE\\CXrL\\SHADOW\\Preferences
    set key $gvars(pref_file)
    vputs "Saving preferences to $key..."
    foreach pname [array names gprefs] {
	registry set $key $pname [set gprefs($pname)]
    }
    vputs "Saved preferences to $key."
    return 0
}

