/*==============================================================================
 * subroutine fpbspl evaluates the (k+1) non-zero b-splines of
 * degree k at t(l) <= x < t(l+1) using the stable recurrence
 * relation of de boor and cox.
 *
 * Input : float t[] : t[n]
 *         int   *pn : n
 *         int   *pk : k
 *         float *px : x
 *         int   *pl : l
 * Output:
 *         float h[] : h[6]
 * 
 */

# include "fitpack.h"

void fpbspl ( float t[], int *pn, int *pk,
              float *px, int *pl,
              float h[] )
{
  // local scalars
  float f, one;
  int i, j, li, lj;
  // local arrays
  float hh[5];

  one = 0.1e+01;
  h[0] = one;
  for ( j=1; j<=*pk; j++) {
    for ( i=0; i<j; i++) {
      hh[i] = h[i];
    }
    h[0] = 0.;
    for ( i=0; i<j; i++) {
      li = *pl+i;
      lj = li-j;
      f = hh[i]/(t[li]-t[lj]);
      h[i] = h[i]+f*(t[li]-*px);
      h[i+1] = f*(*px-t[lj]);
    }
  }
  return;

} // fpbspl

/*
      subroutine fpbspl(t,n,k,x,l,h)
c  subroutine fpbspl evaluates the (k+1) non-zero b-splines of
c  degree k at t(l) <= x < t(l+1) using the stable recurrence
c  relation of de boor and cox.
c  ..
c  ..scalar arguments..
      real x
      integer n,k,l
c  ..array arguments..
      real t(n),h(6)
c  ..local scalars..
      real f,one
      integer i,j,li,lj
c  ..local arrays..
      real hh(5)
c  ..
      one = 0.1e+01
      h(1) = one
      do 20 j=1,k
        do 10 i=1,j
          hh(i) = h(i)
  10    continue
        h(1) = 0.
        do 20 i=1,j
          li = l+i
          lj = li-j
          f = hh(i)/(t(li)-t(lj))
          h(i) = h(i)+f*(t(li)-x)
          h(i+1) = f*(x-t(lj))
  20  continue
      return
      end
*/
