/*+++***********************************************************************
NAME

    fitpack.h

SYNOPSIS

    #include "fitpack.h"

DESCRIPTION
    Header of the fitpack c-routines

***********************************************************************---*/
#ifndef _fitpack_
# define _fitpack_

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
#  define PRIVATE static // used to declare variables of private type 
#endif

#ifndef PUBLIC
#  define PUBLIC         // used to declare variables of public type 
#endif

/****************************************************************************
*  Include                                                                  *
****************************************************************************/
# include <stdio.h>
# include <stdlib.h>
# include <float.h>

void bispev (float tx[], int *pnx, float ty[], int *pny, 
             float c[], int *pkx, int *pky,
             float x[], int *pmx, float y[], int *pmy,
             float z[], float wrk[], int *plwrk, int iwrk[], int *pkwrk,
             int *pier);

void fpbisp ( float tx[], int *pnx,
              float ty[], int *pny,
              float c[],  int *pkx, int *pky,
              float x[], int *pmx,
              float y[], int *pmy,
              float z[],
              float wx[],
              float wy[],
              int lx[],
              int ly[] );

void fpbspl ( float t[], int *pn, int *pk,
              float *px, int *pl,
              float h[] );



#endif
