/*==============================================================================
 * subroutine fpbisp
 *
 * Call :
 * void fpbisp ( float tx[], int *pnx,
 *               float ty[], int *pny,
 *               float c[], int *pkx, int *pky,
 *               float x[], int *pmx,
 *               float y[], int *pmy,
 *               float z[],
 *               float wx[], float wy[],
 *               int lx[], int ly[] );
 *
 * Input : float tx[] : tx[nx]
 *         int   *pnx : nx
 *         float ty[] : ty[ny]
 *         int   *pny : ny
 *         float c[]  : c[(nx-kx-1)*(ny-ky-1)]
 *         int   *pkx : kx
 *         int   *pky : ky
 *         float x[]  : x[mx]
 *         int   *pmx : mx
 *         float y[]  : y[my]
 *         int   *pmy : my
 *         float wx[] : wx(mx,kx+1)
 *         float wy[] : wy(my,ky+1)
 *         int   lx[] : lx[mx]
 *         int   ly[] : ly[my]
 * Output:
 *         float z[]  : z[mx*my]
 * 
 *  ..subroutine references..
 *    fpbspl
 */

# include "fitpack.h"

// FORTRAN's Column major order, the first array index varies most rapidly.
#define ARRPTR(A,D1,D2,I1,I2) (A)+((I1)+((I2)*(D1)))

void fpbisp ( float tx[], int *pnx,
              float ty[], int *pny,
              float c[],  int *pkx, int *pky,
              float x[], int *pmx,
              float y[], int *pmy,
              float z[],
              float wx[],
              float wy[],
              int lx[],
              int ly[] )
{
  // local scalars
  int kx1, ky1, l, l1, l2, m, nkx1, nky1;
  int i, j, i1, j1;
  float arg, sp, tb, te;
  // local arrays
  float h[6];

      kx1 = *pkx+1;
      nkx1 = *pnx-kx1;
      tb = tx[*pkx]; // tb = tx(kx1);
      te = tx[nkx1]; // te = tx(nkx1+1);
      l = kx1;
      l1 = l+1;
      for (i=0;i<*pmx;i++) { // do 40 i=1,mx
        arg = x[i]; // arg = x(i);
        if ( arg<tb) arg = tb; // if(arg.lt.tb) arg = tb
        if ( arg>te) arg = te; // if(arg.gt.te) arg = te

        while  ( (arg>=tx[l]) && (l!=nkx1) )  {  // while  ( ( arg>=tx(l1) ) && ( l!=nkx1 ) // 10  if(arg.lt.tx(l1) .or. l.eq.nkx1) go to 20
          l = l1;
          l1 = l+1;
        }                                              //  go to 10

        fpbspl(tx,pnx,pkx,&arg,&l,h); // 20    call fpbspl(tx,nx,kx,arg,l,h)

        lx[i] = l-kx1; // lx(i) = l-kx1;
        for (j=0;j<kx1;j++) { //do 30 j=1,kx1
          float *pwx; // wx(mx,kx+1) <=> wx(mx,kx1)
          pwx = ARRPTR(wx,*pmx,kx1,i,j);
          *pwx =  h[j]; // wx(i,j) = h(j);
        } // 30    continue
      } // 40  continue

      ky1 = *pky+1;
      nky1 = *pny-ky1;
      tb = ty[*pky]; // tb = ty(ky1);
      te = ty[nky1]; // te = ty(nky1+1);
      l = ky1;
      l1 = l+1;
      for (i=0;i<*pmy;i++) { // do 80 i=1,my
        arg = y[i]; // arg = y(i);
        if (arg<tb) arg = tb; // if(arg.lt.tb) arg = tb
        if (arg>=te) arg = te; // if(arg.gt.te) arg = te

        while ( (arg>=ty[l] ) && (l!=nky1) ) { // while ( (arg>=ty(l1) ) && ( l!=nky1) ) // 50 if(arg.lt.ty(l1) .or. l.eq.nky1) go to 60
          l = l1;
          l1 = l+1;
        }  // go to 50

        fpbspl(ty,pny,pky,&arg,&l,h); // 60    call fpbspl(ty,ny,ky,arg,l,h)

        ly[i] = l-ky1; // ly(i) = l-ky1;
        for (j=0;j<ky1;j++) { // do 70 j=1,ky1
          float *pwy; // wy(my,ky+1) <=> wy(my,ky1)
          pwy = ARRPTR(wy,*pmy,ky1,i,j);
          *pwy = h[j]; // wy(i,j) = h(j);
        } // 70    continue
      } // 80  continue

      m = 0;
      for (i=0;i<*pmx;i++) { // do 130 i=1,mx
        l = lx[i]*nky1; // l = lx(i)*nky1;

        for (i1=0;i1<kx1;i1++) { // do 90 i1=1,kx1
          float *pwx; // wx(mx,kx+1) <=> wx(mx,kx1)
          pwx = ARRPTR(wx,*pmx,kx1,i,i1);
          h[i1] = *pwx; // h(i1) = wx(i,i1);
        } // 90    continue

        for (j=0;j<*pmy;j++) { // do 120 j=1,my
          l1 = l+ly[j]; // l1 = l+ly(j);
          sp = 0.;

          for (i1=0;i1<kx1;i1++) { // do 110 i1=1,kx1
            l2 = l1;

            for (j1=0;j1<ky1;j1++) { // do 100 j1=1,ky1
              float *pwy; // wy(my,ky+1) <=> wy(my,ky1)
              pwy = ARRPTR(wy,*pmy,ky1,j,j1);
              sp = sp+c[l2]*h[i1]*(*pwy); // sp = sp+c(l2)*h(i1)*wy(j,j1);
              l2 = l2+1;
            } // 100        continue

            l1 = l1+nky1;
          } // 110      continue

          z[m] = sp; // m = m+1; z(m) = sp;
          m = m+1;
        } // 120    continue

      } // 130  continue

      return; // end

} // fpbisp

/*
      subroutine fpbisp(tx,nx,ty,ny,c,kx,ky,x,mx,y,my,z,wx,wy,lx,ly)
c  ..scalar arguments..
      integer nx,ny,kx,ky,mx,my
c  ..array arguments..
      integer lx(mx),ly(my)
      real tx(nx),ty(ny),c((nx-kx-1)*(ny-ky-1)),x(mx),y(my),z(mx*my),
     * wx(mx,kx+1),wy(my,ky+1)
c  ..local scalars..
      integer kx1,ky1,l,l1,l2,m,nkx1,nky1
      real arg,sp,tb,te
c  ..local arrays..
      real h(6)
c  ..subroutine references..
c    fpbspl
c  ..
      kx1 = kx+1
      nkx1 = nx-kx1
      tb = tx(kx1)
      te = tx(nkx1+1)
      l = kx1
      l1 = l+1
      do 40 i=1,mx
        arg = x(i)
        if(arg.lt.tb) arg = tb
        if(arg.gt.te) arg = te
  10    if(arg.lt.tx(l1) .or. l.eq.nkx1) go to 20
        l = l1
        l1 = l+1
        go to 10
  20    call fpbspl(tx,nx,kx,arg,l,h)
        lx(i) = l-kx1
        do 30 j=1,kx1
          wx(i,j) = h(j)
  30    continue
  40  continue
      ky1 = ky+1
      nky1 = ny-ky1
      tb = ty(ky1)
      te = ty(nky1+1)
      l = ky1
      l1 = l+1
      do 80 i=1,my
        arg = y(i)
        if(arg.lt.tb) arg = tb
        if(arg.gt.te) arg = te
  50    if(arg.lt.ty(l1) .or. l.eq.nky1) go to 60
        l = l1
        l1 = l+1
        go to 50
  60    call fpbspl(ty,ny,ky,arg,l,h)
        ly(i) = l-ky1
        do 70 j=1,ky1
          wy(i,j) = h(j)
  70    continue
  80  continue
      m = 0
      do 130 i=1,mx
        l = lx(i)*nky1
        do 90 i1=1,kx1
          h(i1) = wx(i,i1)
  90    continue
        do 120 j=1,my
          l1 = l+ly(j)
          sp = 0.
          do 110 i1=1,kx1
            l2 = l1
            do 100 j1=1,ky1
              l2 = l2+1
              sp = sp+c(l2)*h(i1)*wy(j,j1)
 100        continue
            l1 = l1+nky1
 110      continue
          m = m+1
          z(m) = sp
 120    continue
 130  continue
      return
      end
*/
