/*
 *   Project: The SPD Image correction and azimuthal regrouping
 *                      http://forge.epn-campus.eu/projects/show/azimuthal
 *
 *   Copyright (C) 2005-2010 European Synchrotron Radiation Facility
 *                           Grenoble, France
 *
 *   Principal authors: P. Boesecke (boesecke@esrf.fr)
 *                      R. Wilcke (wilcke@esrf.fr)
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published
 *   by the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   and the GNU Lesser General Public License  along with this program.
 *   If not, see <http://www.gnu.org/licenses/>.
 */

/* This routines opens edf files and updates the header of
   data block in data chain.
   The header block must be sufficiently big, if not -> ERROR!
   EXAMPLE:  Add/Modify header key SampleConcentration
     edfheaderaddkey 0 1 1 1 SampleConcentration 120.4 *ccd
*/

# include "edfio.h"

# define Usage "<level> <verbose> <block> <chain> <key> <value> [<filename>]\n\n" \
" The header block must be sufficiently big, if not -> ERROR!\n" \
" EXAMPLE: Add/Modify header key SampleConcentration \n" \
"          (level=0|1|2|..., verbose=0|1, block and chain are usually 1, key=\"string\", value=\"string\")\n" \
"          edfheaderaddkey 0 1 1 1 SampleConcentration 120.4 *ccd\n"
int main (int argc, char *argv[]) 
{ long DataNumber=1, DataChain=1;
  int ErrorValue, status;
  int level = 0, verbose = 1;
  int cnt = 0;

  int in1=-1;

  const char *header_key="header"; // name under which the header will be accessible 
  char *fname="file.edf";
  char *key="";
  char *value="";

  if (argc>1) sscanf(argv[1],"%d",&level);
  if (argc>2) sscanf(argv[2],"%d",&verbose);
  if (argc>3) sscanf(argv[3],"%ld",&DataNumber);
  if (argc>4) sscanf(argv[4],"%ld",&DataChain);
  if (argc>5) key=argv[5];
  if (argc>6) value=argv[6];

  if (verbose>1)
    printf("level = %d, verbose = %d\n",level,verbose);

  edfio_level_set((long) level);
  edfio_debug_set(IODBG_DEBUG1);

  if (argc<=7) { printf("%s %s\n",argv[0],Usage); goto main_error; }

  // BEGIN loop over all files
  for (cnt=7;cnt<argc;cnt++) {
    fname=argv[cnt];

    if (verbose>0) printf("%s\n",fname);

    /* Open the edf file */
    if (verbose>1) printf("11: edf_open_data_file( %s , ... )\n",fname);
    in1 = edf_open_data_file  ( fname, "any", &ErrorValue, &status );
    if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

    /* Create a header variable */
    if ( !edf_new_header( header_key ) ) {
      printf("ERROR: creating header %s\n",header_key); goto main_error;
    }
 
    /* Read the edf file header */

    if (verbose>1) printf("31 edf_read_header( %d , ... )\n",in1);
    edf_read_header ( in1, DataNumber, DataChain, header_key, &ErrorValue, &status );
    if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

    /* Update header */
    /* routines: edf_new_header, edf_read_header, edf_write_header, edf_free_header,
                 edf_first_header_element, edf_next_header_element, edf_search_header_element,
                 edf_add_header_element, edf_delete_header_element,
                 edf_print_header */
               
    if (verbose>1) {
      printf("32 edf_print_header\n");
      edf_print_header            ( stdout, header_key, 2, 0 );
    }

    /*
      edf_first_header_element    ( const char * header_key,
                                    const char ** pkey, const char ** pvalue,
                                    int * pErrorValue, int * pstatus ),
      edf_next_header_element     ( const char * header_key,
                                    const char ** pkey, const char ** pvalue,
                                    int * pErrorValue, int * pstatus ),
      edf_search_header_element   ( const char * header_key,
                                    const char * key, const char ** pvalue,
                                    int * pErrorValue, int * pstatus ),
      edf_add_header_element      ( const char * header_key,
                                    const char * key, const char * value,
                                    int * pErrorValue, int * pstatus ),
      edf_delete_header_element   ( const char * header_key,
                                    const char * key,
                                    int * pErrorValue, int * pstatus ),
    */

    if (verbose>1) printf("33 edf_add_header_element\n");
    edf_add_header_element      ( header_key, key, value, &ErrorValue, &status );
    if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

    /* Write the edf file header */
    if (verbose>1) printf("34 edf_write_header( %d , ... )\n",in1);
    edf_write_header  ( in1, DataNumber, DataChain, header_key,
                        &ErrorValue, &status );
    if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

    if ( !edf_free_header             ( header_key ) ) {
       printf("ERROR: releasing header %s\n",header_key); goto main_error;
    }

    /* Close data file */
    if (verbose>1) printf("81: edf_close_data_file( %d , ... )\n",in1);
    edf_close_data_file( in1, &ErrorValue, &status );
    if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  } // END loop over all filenames argv[cnt]: cnt=5; cnt<argc; cnt++ 

  return( status );

main_error: 
  if (verbose>1) printf("Error exit (status=%d)\n",status);
  edf_free_header( NULL );
  edf_close_data_file( in1, NULL, NULL );
  return(status);
  
}
