/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/* SaxsError.h V1.56 by P. BOESECKE 2017-10-16                             */
/***************************************************************************/

#ifndef _SAXS_ERROR
# define _SAXS_ERROR

# define ERROUT stderr

   extern char
    * SaxsErrorVersion( void );

   extern void
    SetSaxsError( const char * ModuleName,
                  const char * RoutineName, 
                  const char * Message ),
    SetSaxsErrorExternal ( int ExternalError,
                           const char *(*ReportError) (int ) ),
    SetSaxsErrorMessage ( const char *Message );

   extern int
    ReportSaxsStatus(int Status, int ExitFlag);

enum Status { Failed  = -1,  Success = 0, Abort = 1,    SkipInput,
              ScanError   ,  ScanEmpty  , NoDefault,    NoOption ,    
              NoFloatNumber,              NoIntegerNumber,            
              InvalidOrientation,         BadParenthesis,
              DivByZero,     NoFlag,      CommaExpected,
              FloatingPointError,         DomainError,  IntegerOverflow,
              UnknownFloatFunction,       UnknownIntegerFunction,
              WrongImageNumber,           NotEnoughBlocks,
              NotEnoughMemoryAvailable,   FileNotFound, ImageProtected,
              FileProtected, FileOpeningError,          FileAlreadyOpen,
              FileMustBeOpen, HeaderNotInitialized,
              FilePositioningError,       FileReadError,
              FileClosingError,           KeywordMissing,
              UnknownDataType, UnsupportedDataType, UnknownUnit, SizeMismatch, 
              FileWriteError, OutOfRange, TypeConversionFailed, 
              StoppedAfterHelp,           CannotFindHeader,
              FileNameError,              NotWaxsProjection,
              NotNormalReference,         NotSaxsReference,
              ReferenceNotSupported,      ExpressionWriteError,       
              NoVariable,
              VariableError,              ProgramError,
              NoInstruction,              NoAccumulator,
              HeaderNotRead,
              ExternalErrorReport = 100 };

#endif /* _SAXS_ERROR */

/**************************************************************************/
/*                                                                        */
/**************************************************************************/

