/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/*+++------------------------------------------------------------------------

NAME

  SaxsDefinition

PURPOSE

  Definition of transformation macros and procedures between reference systems.
  All macros may contain several instructions separated by a semicolon. If
  necessary, e.g. in an if-statement, they MUST be put into parentheses:
  if (condition) {ARRAYREF(Off,Ps);}

HISTORY

  30-Jan-1995 PB creation
  02-Feb-1995 PB saxs_definitions.h SAXS_DEFINITIONS
  17-Feb-1995 PB saxs file keywords added
  19-Feb-1995 PB raw data keywords added
  24-Feb-1995 PB definition of "Index" changed
  27-Apr-1995 PB dummy macros corrected for dummy == 0
  04-Jun-1995 PB WaveLength0 changed from 1e-10 to 1e-9
                 Definition of saxs reference system changed from
    SAXSREF(Off,Ps,O,P,C,S,W) Off=(O)-(C)+DAI; Ps=((P)/(S))*(WaveLength0/W)
    SAXSREF(Off,Ps,O,P,C,S,W) Off=(O)-(C)+DAI; Ps=((P)/(S))*(_2W0_/W)
                 with _2W0_ = 2 * WaveLength0.
                 In the SAXS reference system the World Value corresponds now
                 to s = 2 Sin(Theta)/Lambda in the approximation for small
                 angles (s -> s Theta/Lambda).
                 To distinguish whether a program uses the new version the
                 version number of imageoption has been set to 4.0 at the
                 same time.
  19-Jun-1995 PB error in definition of s, s-value too big: _2W0_ --> _W0_
                 _2W0_ removed.
                 To distinguish whether a program uses the new version the
                 version number of imageoption has been set to 4.1 at the
                 same time.
  19-Jun-1995 PB definition of IPOLEPS. IPOLEPS is the width of the interval
                 in which no interpolation takes place
  17-Aug-1995 PB definition of INDEX2R
                 from INDEX2R(I,O,P) ((((I)+(O))*(P))+DAI)
                 to INDEX2R(I,O,P) (((I)+(O)+DAI)*(P))
  17-Aug-1995 PB KHScalerDepth added
  18-Aug-1995 PB RELECTRON added
  10-Sep-1995 PB SD_Version added
  12-Nov-1995 PB 2.0 SAXS_PI added
  14-Nov-1995 PB 2.0 NUMBERSTART added, ARRAYSTART 1 -> 1.0
                     REF2USER, USER2REF, AREBIN
                     Documentation added
                     KSaxsDataVersion missing
  23-Nov-1995 PB 2.02 KSaxsDataVersion added
  28-Nov-1995 PB 2.03 DREF2DUSER, DUSER2DREF added
  23-Dec-1995 PB 2.03 FALSE and TRUE added
  26-Jan-1996 PB 2.032 KDetectorPosition added
  27-Feb-1996 PB 2.033 I2OFFSET, R2OFFSET, S2OFFSET, S2PSIZE, R2PSIZE added
                       PSIZE2R, PSIZE2S
  28-May-1996 PB 2.034 UPDATE
  06-Oct-1996 PB 2.035 DUMMY definition corrected from ABS( ( V) - ( D)) < DD
                       to ABS( ( V) - ( D)) <= DD, NODUMMY respectively. Now,
                       DDummy==0 recognizes dummies.
  10-Oct-1996 PB 2.04  saxs_definitions.h renamed to SaxsDefinition.h
  26-Jun-1999 PB 2.05  keyword KTime added to saxs file keywords
  17-Jul-1999 PB 2.06  SAXSDATAVERSION defined here
  23-Jul-1999 PB 2.07  SAXSDATAVERSION 2.0
  09-Nov-1999 PB 2.08  DUMMYDEFINED( D, DD) parameter DD added
  21-Dec-1999 PB 2.09  definition of DUMMYFILENAME
  31-Dec-1999 PB 2.10  definition of reference system BEAM 
  10-Jan-2000 PB 2.11  definition of reference system CENTER, NORMAL 
                       NORMAL replaces BEAM
  30-Jul-2000 PB 2.12  CSWAP, KOrientation
  31-Aug-2000 PB 2.13  definition of KValueI0, KValueI1, KValueAnode, KValueTime
  10-Nov-2000 PB 2.14  Orientation -> RasterOrientation
  27-Nov-2000 PB 2.15  SETCTRDEF changed from (dim+DAI)*0.5 to 
                        (dim-1)*0.5+ArrayStart
  19-Apr-2001 PB 2.16  definition of WAVENUMBER(W) and suppression of _W0_ 
  28-Nov-2001 PB 2.17  SaxsDataVersion 2.30
  22-Apr-2002 PB 2.18  C2INDEX, N2INDEX, S2INDEX corrected
  29-Nov-2003 PB 2.19  KBinSiz_1, KBinSiz_2, B -> Bin, AREBIN1
  04-Mar-2004 PB 2.20  AREBIN removed and AREBIN1 renamed to AREBIN
  17-Jul-2004 PB 2.21  Error in Definition of INDEX2C corrected 
  26-Sep-2004 PB 2.22  KDisplaced for output parameter prefixes, 
                       KProjection and projection values 
                       (VProjectionSaxs, VProjectionWaxs)
  04-Oct-2004 PB 2.23  KDetRot_1, KDetRot_2, KDetRot_3,
                       SAXSDATAVERSION = 2.40
  31-Mar-2005 PB 2.24  Psize -> PSize, Bsize -> BSize
  10-Apr-2005 PB 2.25  S2PSIZE corrected: divide by WAVENUMBER is correct
  19-Aug-2005 PB 2.26  VarDummy definition added, KError removed
  31-OCT-2005 PB 2.27  R2CENTER, CENTER2R, N2S and S2N added
                       SAXSREF etc defined from NORMALREF etc.
  04-Dec-2005 PB 2.28  IPOLEPS -> ipol.h
  05-Dec-2005 PB 2.29  Array access and dummy definitions now in ipol.h
  01-Dec-2007 PB 2.30  Axis types
  02-Oct-2009 PB 2.31  reference.h extracted and moved to
                       ../edfpack/reference.h
  13-Oct-2015 PB 2.32  definition of alternative parameter sets
  19-Jul-2017 PB 2.33  KHStartEpoch added

----------------------------------------------------------------------------*/

/****************************************************************************
* SaxsDefinition.h
****************************************************************************/

# include "reference.h"

#ifndef _SAXSDEFINITION_

/* version */
# define SD_Version "SaxsDefinition V2.33 Peter Boesecke 2017-07-19"
# define SAXSDATAVERSION    "2.40"

/* general */
# define DUMMYFILENAME          "/dev/null"

/* saxs file keywords */
# define KSaxsDataVersion       "SaxsDataVersion"
# define KImage                 "Image"
# define KGeneral               "General"
# define KDummy                 "Dummy"
# define KDDummy                "DDummy"
# define KOffset_1              "Offset_1"
# define KOffset_2              "Offset_2"
# define KBinSiz_1              "BSize_1"
# define KBinSiz_2              "BSize_2"
# define KPixSiz_1              "PSize_1"
# define KPixSiz_2              "PSize_2"
# define KWaveLength            "WaveLength"
# define KTitle                 "Title"
# define KTime                  "Time"
# define KProjection            "ProjectionType"
# define KAxisType_1            "AxisType_1"
# define KAxisType_2            "AxisType_2"
/* orientation of array raster axes in space
   ("lower indices change faster"),
   default 1: axis_1==x, axis_2==y, axis_3==z */
# define KOrientation           "RasterOrientation"
/* relation between key indices and array raster axes, 
   default 1: key of axis_1 = <key>_1, etc. */
# define KIndexOrder            "IndexOrder"

# define KCenter_1              "Center_1"
# define KCenter_2              "Center_2"
# define KSampleDistance        "SampleDistance"

# define KDetRot_1              "DetectorRotation_1"
# define KDetRot_2              "DetectorRotation_2"
# define KDetRot_3              "DetectorRotation_3"

/* alternative parameter sets */

/* only used to calculate KCenter_1, KCenter_2, KSampleDistance */
# define KBeamCenter_1          "BeamCenter_1"  // image coordinate of beam on detector
# define KBeamCenter_2          "BeamCenter_2"  // image coordinate of beam on detector
# define KBeamDistance          "BeamDistance"  // distance along beam between sample and detector

/* only used to calculate KDetRot_1, KDetRot_2, KDetRot_3 */
# define KDetTilt_1             "DetectorTilt_1" 
# define KDetTilt_2             "DetectorTilt_2"
# define KDetTilt_3             "DetectorTilt_3"

/* projection type values */
# define VProjectionSaxs        "Saxs"
# define VProjectionWaxs        "Waxs"

/* axis type values */
# define VAxisTypeDistance      "Distance"
# define VAxisTypeAngle         "Angle"
# define VAxisTypeNumerator     "Numerator"

/* additional raw data keywords */
# define KHScalerLen    "HS32Len"
# define KHScaler       "HS32"
# define KHScalerDepth  "HS32Depth"
# define KHC            "C"
# define KHN            "N"
# define KHZ            "Z"
# define KHF            "F"
# define KHFrame        "HMFrame"
# define KHFile         "HMFile"
# define KDetectorPosition "DetectorPosition"  
# define KDetectorType  "DetectorName"
# define KExperimentInfo "ExperimentInfo"
# define KMachineInfo   "MachineInfo"
# define KOpticsInfo    "OpticsInfo"
# define KStationInfo   "StationInfo"
# define KProposalInfo  "Proposal"
# define KHFraming      "HMFraming"
# define KHStartTime    "HMStartTime"
# define KHDeltaTime    "HMDeltaTime"
# define KHStartEpoch   "HMStartEpoch"
# define KHScalerI0     "HSI0"
# define KHScalerI1     "HSI1"
# define KHScalerAnode  "HSAnode"
# define KHScalerTime   "HSTime"
# define KHScalerI0S    "HSI0S"
# define KHScalerI1S    "HSI1S"
# define KHScalerAnodeS "HSAnodeS"
# define KHScalerTimeS  "HSTimeS"
# define KSubTitle      "SubTitle"
# define KValueI0       "Intensity0"
# define KValueI1       "Intensity1"
# define KValueAnode    "Anode"
# define KValueTime     "ExposureTime"

/* additional keywords */
# define KDisplaced     "Displaced"

/* ---------------------------------------------------------------------------
  Physical Constants
  - RELECTRON classical electron radius in meter
---------------------------------------------------------------------------*/
# define RELECTRON	2.81794e-15
/* ---------------------------------------------------------------------------
  Mathematical Constants
  - SAXS_PI pi
---------------------------------------------------------------------------*/
# define SAXS_PI	3.1415926535897932384626

# define _SAXSDEFINITION_
#endif /* _SAXSDEFINITION_ */

/****************************************************************************
*                                                                           *
****************************************************************************/

