/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/*+++***********************************************************************
NAME

    roca_list.h

SYNOPSIS

    #include "roca_list.h"

DESCRIPTION
    Header of the module "roca_list.c"

***********************************************************************---*/
#ifndef _roca_list_
# define _roca_list_

/****************************************************************************
*  Include                                                                  *
****************************************************************************/

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <stdio.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

# include "ioalloc.h"

/***************************************************************************
* Macros                                                                   *
***************************************************************************/

//# define FREE(s) if (s) { free(s); s=NULL; }

/***************************************************************************
* List Structure Definition                                                *
***************************************************************************/

typedef struct List_Element {
 char *Key;                          /* pointer to the element key string */
 char *Value;                /* Pointer to the allocated character string */
 struct List_List *List;
 struct List_Element *Previous,*Next;   /* the previous and next elements */
} LElement;

typedef struct List_List {
 char     *Key;                         /* pointer to the list key string */
 LElement *Elements;           /* pointer to the root of the element list */
 size_t    ElementsLen;                 /* number of elements in the list */
 struct List_List *Previous,*Next;         /* the previous and next lists */
} LList;

/****************************************************************************
* Functions                                                                 *
****************************************************************************/

int list_debug_set ( int debug );

int new_list( const char *Key, LList **plist );
int insert_list( const char *Key, LList **plist );
int search_list( const char *Key, LList **plist );
int remove_list( const char *Key, LList **pnext );
int delete_list( LList *list,  LList **pnext );
int free_lists( void );
int insert_element( LList *list, const char *Key, LElement **pelement );
int search_element( LList *list, const char *Key, LElement **pelement );
int write_element_value( LList *list, const char *Key, const char * Value);
int read_element_value( LList *list, const char *Key, const char **pValue);
int remove_element( LList *list, const char *Key, LElement **pnext );

int first_element( LList *list, LElement **pelement );
int next_element( LList *list, LElement **pelement );

int print_lists( FILE * out, int level, int verbose );
int print_elements( FILE * out, LList * list, int level, int verbose );

int cnt_elements( LList *list, const char *Keys );
int cnt_params( LList *list, const char *KeyNames[] );
size_t number_of_elements( LList *list );

int put_element_value( LElement *element, const char *Value) ;
int get_element_value( LElement *element, const char **pValue);
int delete_element( LElement *element,  LElement **pnext );
int free_elements( LList *list );

int check_element( LList *list, LElement *element );
int is_element( LList *list, const char *Key );
int is_member( LList *list, LElement *element );

#endif

