/* This routines tests strlib functions */

# include "strlib.h"

/*+++------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/
# define Usage "<string1> <string2> [n]"

# define NULLSTRING( s) (s)?(s):"(nil)"

main (int argc, char *argv[])
{
  int errval, level=1;
  char *string1="";
  char *string2="";
  size_t n=0;
  char *tail=NULL;
  int value;

  if (argc<=2) { printf("%s %s\n",argv[0],Usage); return(-1); }

  if (argc>1) string1 = argv[1];
  if (argc>2) string2 = argv[2];
  if (argc>3) n = strtol(argv[3],&tail,10);

  printf("string1 = >%s<\n", string1);
  printf("string2 = >%s<\n", string2);
  printf("      n = %ld\n", n);
  printf("   tail = >%s<\n", NULLSTRING(tail));

  if (tail) {
    value = strlib_ncmp(string1,string2,n);
    printf("strlib_ncmp(%s,%s,%d) = %d\n",string1,string2,n,value);

  } else {
    value = strlib_cmp(string1,string2);
    printf("strlib_cmp(%s,%s) = %d\n",string1,string2,value);

    value = strlib_numcmp(string1, string2 );
    printf("strlib_numcmp(%s,%s) = %d\n",string1,string2,value);

    value = strlib_numcasecmp(string1, string2 );
    printf("strlib_numcasecmp(%s,%s) = %d\n",string1,string2,value);
  }

} /* main */


