#       include <errno.h>
#       include <stdio.h>
#       include <fcntl.h>
#       include "strlib.h"

/*+++------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/
# define Usage "<string>"
   
main (int argc, char *argv[])
{
  int status=0;
  char *inp_string=NULL;
  const char *outp_string=NULL;

  size_t buflen=1024;
  char *buffer=NULL;

  if (argc<=1) { printf("%s %s\n",argv[0],Usage); return(-1); }

  if (argc>1) inp_string=argv[1];

  buffer = (char *) malloc( buflen );
  if (!buffer) { 
    printf("ERROR allocating %s bytes\n",buflen);
    goto main_error;
  }

  outp_string = strlib_numberstring( buffer, buflen, inp_string, &status );  

  printf("input  = >%s<\n",inp_string);
  printf("output = >%s<\n",outp_string);

  if (buffer) free(buffer);

  return(status);

main_error:

  if (buffer) free(buffer);

  return(-1);

} // main
