#       include <errno.h>
#       include <stdio.h>
#       include <fcntl.h>
#       include "isotime.h"
#       include "numio.h"

/*+++------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/
# define Usage "<isotime> <delta[s] (default 0)>"
   
main (int argc, char *argv[])
{
  char *inp_string=NULL;
  const char *outp_string=NULL;

  size_t buflen=1024;
  char *buffer=NULL;

  double delta=0.0;
  IsotimeEpoch epoch;

  if (argc<=1) { printf("%s %s\n",argv[0],Usage); return(-1); }

  if (argc>1) inp_string=argv[1];

  if (argc>2) delta = num_str2double ( argv[2], NULL, NULL );

  printf("inp_string = >%s<\n",inp_string);
  printf("delta = %lg\n",delta);

  buffer = (char *) malloc( buflen );
  if (!buffer) { 
    printf("ERROR allocating %s bytes\n",buflen);
    goto main_error;
  }

  epoch = isotime2epoch   (inp_string);
  if (epoch_status(epoch)) goto main_error;

  printf("epoch = >%s<\n",epoch2string(buffer,buflen,epoch));

  epoch = epoch_add( epoch, delta2epoch(delta));
  if (epoch_status(epoch)) goto main_error;

  // epoch = epoch_add(epoch, delta);
  // delta = epoch_sub(epoch1, epoch2);

  printf("epoch + delta = >%s<\n",epoch2string(buffer,buflen,epoch));
  
  outp_string = epoch2isotime(buffer,buflen,epoch);

  printf("input  = >%s< + %lg s\n",inp_string,delta);
  printf("output = >%s<\n",outp_string);

  if (buffer) free(buffer);

  return(0);

main_error:

  if (buffer) free(buffer);

  return(-1);

} // main
