
/* This routines tests the capability to open 6 files at the same time.
   It reads them and writes the sum pixel by pixel to an output file 
   The images must have the same sizes 
   PB 2007-04-19 tested on 
                 coral3 : gcc version 3.2.2 x86_64 (OK), 
                 indigo1 : gcc version 3.2.2 sun4u (OK, 
                           but format %zu is not recognized)
                 amber32 : gcc version 3.3 20030226 i686 (OK)
                 bruno: gcc version 3.3.1 (cygming special) i686 cygwin (OK, 
                        but format %zu is not recognized)
*/

# include "edfio.h"
# define Usage "<level> <verbose>"

int test_write( const char *fname, int fno, int level, int *pstatus )
{
  long  oDim[]={2,30,40};
  short *oData=NULL;
  long i,j;

  int out=-1;

  int status, ErrorValue;

  if (!(oData = (short *) malloc(oDim[2]*oDim[1]*sizeof(short)))) {
    status = CouldNotMallocMemory;
    goto test_write_error;
  }

  for (j=0;j<oDim[2];j++) {
    for (i=0;i<oDim[1];i++) {
      oData[j*oDim[1]+i] = j+fno;
    }
  }

  if (level>1) {
    for (j=0;j<oDim[2];j++) {
      printf("%02ld:",j);
      for (i=0;i<oDim[1];i++) {
        printf("%04d ",(int) oData[j*oDim[1]+i]);
      }
      printf("\n");
    }
  }

  if (level>0) printf("  A1: create file %s\n",fname);
  out = edf_open_data_file  ( fname, "new", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto test_write_error; }

  if (level>0) printf("  A2: edf_write_data\n");
  edf_write_data ( out, 1, 1, oDim, oData,
                   MShort, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  if (level>0) printf("  A3: edf_close_data_file( %d , ... )\n",out);
  edf_close_data_file( out, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto test_write_error; }

  if (oData) free(oData);
  if (pstatus) *pstatus=status;
  return(0);

test_write_error:

  if (oData) free(oData);
  if (pstatus) *pstatus=status;
  return(-1);

}

int main (int argc, char *argv[]) 
{ long DataNumber=1, DataChain=1;
  int ErrorValue, status;
  int level = 0, verbose = 0;

  int tmperror, tmpstatus;

  int out=-1, in1=-1, in2=-1, in3=-1, in4=-1, in5=-1, in6=-1;
  long  *Dim1=NULL, *Dim2=NULL, *Dim3=NULL, *Dim4=NULL, *Dim5=NULL, *Dim6=NULL, *DimOut=NULL;
  float *Data1 = NULL, *Data2 = NULL, *Data3 = NULL, *Data4 = NULL, *DataOut = NULL;
  float *Data5 = NULL, *Data6 = NULL;
  size_t Size1, Size2, Size3, Size4, Size5, Size6, SizeOut;

  char *fnameOut="sum.edf";
  char *fname1="file1.edf";
  char *fname2="file2.edf";
  char *fname3="file3.edf";
  char *fname4="file4.edf";
  char *fname5="file5.edf";
  char *fname6="file6.edf";

  long i;

  if (argc<=2) { printf("%s %s\n",argv[0],Usage); goto main_error; }

  if (argc>1) sscanf(argv[1],"%d",&level);
  if (argc>2) sscanf(argv[2],"%d",&verbose);

  printf("level = %d, verbose = %d\n",level,verbose);

  edfio_debug_set(level);

  /* write 6 test files */

  /* write file 1 */
  if (verbose>0) printf("A1: writing test file %s\n",fname1);
  test_write( fname1, 1, verbose-1, &status );
  if (status) goto main_error;

  /* write file 2 */
  if (verbose>0) printf("A2: writing test file %s\n",fname2);
  test_write( fname2, 2, verbose-1, &status );
  if (status) goto main_error;

  /* write file 3 */
  if (verbose>0) printf("A3: writing test file %s\n",fname3);
  test_write( fname3, 3, verbose-1, &status );
  if (status) goto main_error;

  /* write file 4 */
  if (verbose>0) printf("A4: writing test file %s\n",fname4);
  test_write( fname4, 4, verbose-1, &status );
  if (status) goto main_error;

  /* write file 5 */
  if (verbose>0) printf("A5: writing test file %s\n",fname5);
  test_write( fname5, 5, verbose-1, &status );
  if (status) goto main_error;

  /* write file 6 */
  if (verbose>0) printf("A6: writing test file %s\n",fname6);
  test_write( fname6, 6, verbose-1, &status );
  if (status) goto main_error;


  /* Open all edf files */

  if (verbose>0) printf("11: edf_open_data_file( %s , ... )\n",fname1);
  in1 = edf_open_data_file  ( fname1, "old", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("12: edf_open_data_file( %s , ... )\n",fname2);
  in2 = edf_open_data_file  ( fname2, "old", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("13: edf_open_data_file( %s , ... )\n",fname3);
  in3 = edf_open_data_file  ( fname3, "old", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("14: edf_open_data_file( %s , ... )\n",fname4);
  in4 = edf_open_data_file  ( fname4, "old", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("15: edf_open_data_file( %s , ... )\n",fname5);
  in5 = edf_open_data_file  ( fname5, "old", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("16: edf_open_data_file( %s , ... )\n",fname6);
  in6 = edf_open_data_file  ( fname6, "old", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("2: edf_open_data_file( %s , ... )\n",fnameOut);
  out = edf_open_data_file  ( fnameOut, "new", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  /* Read the edf files */

  if (verbose>0) printf("31 edf_read_data( %d , ... )\n",in1);
  edf_read_data (in1, DataNumber, DataChain, &Dim1, &Size1,
                 (void**) &Data1, MFloat, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("32 edf_read_data( %d , ... )\n",in2);
  edf_read_data (in2, DataNumber, DataChain, &Dim2, &Size2,
                 (void**) &Data2, MFloat, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("33 edf_read_data( %d , ... )\n",in3);
  edf_read_data (in3, DataNumber, DataChain, &Dim3, &Size3,
                 (void**) &Data3, MFloat, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("34 edf_read_data( %d , ... )\n",in4);
  edf_read_data (in4, DataNumber, DataChain, &Dim4, &Size4,
                 (void**) &Data4, MFloat, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("35 edf_read_data( %d , ... )\n",in5);
  edf_read_data (in5, DataNumber, DataChain, &Dim5, &Size5,
                 (void**) &Data5, MFloat, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("36 edf_read_data( %d , ... )\n",in6);
  edf_read_data (in6, DataNumber, DataChain, &Dim6, &Size6,
                 (void**) &Data6, MFloat, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  /* Allocate an output array */

  if ( (Size1!=Size2) || (Size2!=Size3) || (Size2!=Size4) || (Size4!=Size5) || (Size5!=Size6)) {
    fprintf(stderr, "Incompatible array sizes\n");
    status=status_error; goto main_error;
  }

  SizeOut = Size1;
  if (verbose>0) printf("4: Allocate %zu bytes for DimOut\n",sizeof(long)*(Dim1[0]+1));
  if (!(DimOut = (long*)malloc(sizeof(long)*(Dim1[0]+1)))) { status=status_error; goto main_error; }
  if (verbose>1) printf("DimOut = %p, Size=%zu (allocated)\n",DimOut,sizeof(long)*(Dim1[0]+1));
  if (verbose>1) printf("DimOut = %p, Size=%lu (allocated)\n",DimOut,sizeof(long)*(Dim1[0]+1));

  if (verbose>0) printf("41: Allocate %zu bytes for DataOut\n",SizeOut);
  if (!(DataOut = (float*)malloc(SizeOut))) { status=status_error; goto main_error; }
  if (verbose>1) printf("DataOut = %p, Size=%zu (allocated)\n",DataOut,SizeOut);
  if (verbose>1) printf("DataOut = %p, Size=%lu (allocated)\n",DataOut,SizeOut);

  if (verbose>0) printf("5: Copying sizes\n");
  for (i=0;i<=Dim1[0];i++) DimOut[i]=Dim1[i];

  if (verbose>0) printf("51: Adding data Dim=%ld, Dim_1=%ld, Dim_2=%ld\n", DimOut[0], DimOut[1], DimOut[2]);
  for (i=0;i<DimOut[1]*DimOut[2];i++) DataOut[i]=Data1[i]+Data2[i]+Data3[i]+Data4[i]+Data5[i]+Data6[i];

  /* Write the output file */
  if (verbose>0) printf("6: edf_write_data( %d , ... )\n",out);
  edf_write_data ( out, DataNumber, DataChain, DimOut, 
                   DataOut, MFloat, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  /* Close data file */

  if (verbose>0) printf("7: edf_close_data_file( %d , ... )\n",out);
  edf_close_data_file( out, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("81: edf_close_data_file( %d , ... )\n",in1);
  edf_close_data_file( in1, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("82: edf_close_data_file( %d , ... )\n",in2);
  edf_close_data_file( in2, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("83: edf_close_data_file( %d , ... )\n",in3);
  edf_close_data_file( in3, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("84: edf_close_data_file( %d , ... )\n",in4);
  edf_close_data_file( in4, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("85: edf_close_data_file( %d , ... )\n",in5);
  edf_close_data_file( in5, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (verbose>0) printf("86: edf_close_data_file( %d , ... )\n",in6);
  edf_close_data_file( in6, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (DataOut) free(DataOut);
  if (DimOut) free(DimOut);

  return( status );

main_error: 
  printf("Error exit\n");
  edf_close_data_file( out, &tmperror, &tmpstatus );
  edf_close_data_file( in1, &tmperror, &tmpstatus );
  edf_close_data_file( in2, &tmperror, &tmpstatus );
  edf_close_data_file( in3, &tmperror, &tmpstatus );
  edf_close_data_file( in4, &tmperror, &tmpstatus );
  edf_close_data_file( in5, &tmperror, &tmpstatus );
  edf_close_data_file( in6, &tmperror, &tmpstatus );
  if (DataOut) free(DataOut);
  if (DimOut) free(DimOut);
  return(status);
  
} /* edfiotest */
