/* This routines opens an edf file and writes test data to
   data block 1 (DataNumber) in data chain 1 (DataChain).
*/


# include "edfio.h"
# define Usage "<level> <verbose> [<filename>]"
int main (int argc, char *argv[]) 
{ long DataNumber=1, DataChain=1;
  int ErrorValue, status;
  int level = 0, verbose = 0;

  int tmperror, tmpstatus;

  int out=-1;
  long *DimOut=NULL;
  float *DataOut = NULL;
  size_t SizeOut;

  char *fnameOut="file.edf";

  long i;

  if (argc<=2) { printf("%s %s\n",argv[0],Usage); goto main_error; }

  if (argc>1) sscanf(argv[1],"%d",&level);
  if (argc>2) sscanf(argv[2],"%d",&verbose);
  if (argc>3) fnameOut=argv[3];

  printf("level = %d, verbose = %d\n",level,verbose);

  edfio_debug_set(level);

  /* Open a new edf file for output */

  if (verbose>0) printf("2: edf_open_data_file( %s , ... )\n",fnameOut);
  out = edf_open_data_file  ( fnameOut, "new", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  /* Allocate an output array */

  if (verbose>0) printf("4: Allocate %zu bytes for DimOut\n",sizeof(long)*(2+1));
  if (!(DimOut = (long*)malloc(sizeof(long)*(2+1)))) { status=status_error; goto main_error; }
  if (verbose>1) printf("DimOut = %p, Size=%zu (allocated)\n",DimOut,sizeof(long)*(2+1));
  if (verbose>1) printf("DimOut = %p, Size=%lu (allocated)\n",DimOut,sizeof(long)*(2+1));

  if (verbose>0) printf("5: Copying sizes\n");
  DimOut[0]=2;
  DimOut[1]=400;
  DimOut[2]=500;

  SizeOut = DimOut[1]*DimOut[2]*sizeof(float);
  if (verbose>0) printf("41: Allocate %zu bytes for DataOut\n",SizeOut);
  if (!(DataOut = (float*)malloc(SizeOut))) { status=status_error; goto main_error; }
  if (verbose>1) printf("DataOut = %p, Size=%zu (allocated)\n",DataOut,SizeOut);
  if (verbose>1) printf("DataOut = %p, Size=%lu (allocated)\n",DataOut,SizeOut);


  if (verbose>0) printf("51: Adding data Dim=%ld, Dim_1=%ld, Dim_2=%ld\n", DimOut[0], DimOut[1], DimOut[2]);
  for (i=0;i<DimOut[1]*DimOut[2];i++) DataOut[i]=i%DimOut[1]; // create a ramp

  /* Write the output file */
  if (verbose>0) printf("6: edf_write_data( %d , ... )\n",out);
  edf_write_data ( out, DataNumber, DataChain, DimOut, 
                   DataOut, MFloat, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  /* Close data file */

  if (verbose>0) printf("7: edf_close_data_file( %d , ... )\n",out);
  edf_close_data_file( out, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  if (DataOut) free(DataOut);
  if (DimOut) free(DimOut);

  return( status );

main_error: 
  printf("Error exit\n");
  edf_close_data_file( out, &tmperror, &tmpstatus );
  if (DataOut) free(DataOut);
  if (DimOut) free(DimOut);
  return(status);
  
} /* edfiotest */
