
/* This routines opens an edf file and reads 
   data block 1 (DataNumber) from data chain 1 (DataChain).
*/

# include "edfio.h"

# define Usage "<level> <verbose> [<filename>]"
int main (int argc, char *argv[]) 
{ long DataNumber=1, DataChain=1;
  int ErrorValue, status;
  int level = 0, verbose = 0;

  int tmperror, tmpstatus;

  int in1=-1;
  long  *Dim1=NULL;
  float *Data1 = NULL;
  size_t Size1;

  char *fname="file.edf";

  if (argc<=2) { printf("%s %s\n",argv[0],Usage); goto main_error; }

  if (argc>1) sscanf(argv[1],"%d",&level);
  if (argc>2) sscanf(argv[2],"%d",&verbose);
  if (argc>3) fname=argv[3];

  printf("level = %d, verbose = %d\n",level,verbose);

  edfio_debug_set(level);

  /* Open the edf file */
  if (verbose>0) printf("11: edf_open_data_file( %s , ... )\n",fname);
  in1 = edf_open_data_file  ( fname, "old", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  /* Read the edf file as float (MFloat) */
  if (verbose>0) printf("31 edf_read_data( %d , ... )\n",in1);
  edf_read_data (in1, DataNumber, DataChain, &Dim1, &Size1,
                 (void**) &Data1, MFloat, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  /* Close data file */
  if (verbose>0) printf("81: edf_close_data_file( %d , ... )\n",in1);
  edf_close_data_file( in1, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  return( status );

main_error: 
  printf("Error exit\n");
  edf_close_data_file( in1, &tmperror, &tmpstatus );
  return(status);
  
} /* edfread */
