/*
 *   Project: The SPD Image correction and azimuthal regrouping
 *                      http://forge.epn-campus.eu/projects/show/azimuthal
 *
 *   Copyright (C) 2005-2010 European Synchrotron Radiation Facility
 *                           Grenoble, France
 *
 *   Principal authors: P. Boesecke (boesecke@esrf.fr)
 *                      R. Wilcke (wilcke@esrf.fr)
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published
 *   by the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   and the GNU Lesser General Public License  along with this program.
 *   If not, see <http://www.gnu.org/licenses/>.
 */

/* This routines opens edf files and updates the header of
   data block in data chain.
   EXAMPLE:  Delete header key SampleConcentration
     edfheaderdelkey 0 1 1 1 SampleConcentration *ccd
*/

# include "edfio.h"

# define Usage "<level> <verbose> <block> <chain> <key> [<filename>]\n\n " \
" EXAMPLE: Delete header key SampleConcentration \n" \
"          (level=0|1|2|..., verbose=0|1|2, block and chain are usually 1, key=\"string\")\n" \
"          edfheaderdelkey 0 1 1 1 SampleConcentration *ccd\n"

int main (int argc, char *argv[]) 
{ long DataNumber=1, DataChain=1;
  int ErrorValue, status;
  int level = 0, verbose = 1;
  int cnt = 0;

  int in1=-1;

  char *fname="file.edf";
  char *key="";

  if (argc>1) sscanf(argv[1],"%d",&level);
  if (argc>2) sscanf(argv[2],"%d",&verbose);
  if (argc>3) sscanf(argv[3],"%ld",&DataNumber);
  if (argc>4) sscanf(argv[4],"%ld",&DataChain);
  if (argc>5) key=argv[5];

  if (verbose>1)
    printf("level = %d, verbose = %d\n",level,verbose);

  edfio_debug_set(level);

  if (argc<=6) { printf("%s %s\n",argv[0],Usage); goto main_error; }

  // BEGIN loop over all files
  for (cnt=6;cnt<argc;cnt++) {
    fname=argv[cnt];

    if (verbose>0) printf("%s\n",fname);

    /* Open the edf file */
    if (verbose>1) printf("11: edf_open_data_file( %s , ... )\n",fname);
    in1 = edf_open_data_file  ( fname, "any", &ErrorValue, &status );
    if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

    if (verbose>1) printf("31: edf_delete_key( ..., %s, ... )\n",key);
    edf_delete_key( in1, DataNumber, DataChain, key, &ErrorValue, &status );
    if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

    /* Close data file */
    if (verbose>1) printf("81: edf_close_data_file( %d , ... )\n",in1);
    edf_close_data_file( in1, &ErrorValue, &status );
    if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); goto main_error; }

  } // END loop over all filenames argv[cnt]: cnt=5; cnt<argc; cnt++ 

  return( status );

main_error: 
  if (verbose>1) printf("Error exit (status=%d)\n",status);
  edf_close_data_file( in1, NULL, NULL );
  return(status);
  
}
