
/* This routines opens an edf file and shows the chain numbers 
   It uses the function

   const long *edf_chain_numbers ( int stream,
                              int *pErrorValue, int *pstatus);

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "edfio.h"

# define Usage "<level> <verbose> [<filename>]"
int main (int argc, char *argv[]) 
{ int argno;
  int ErrorValue, status;
  int level = 0, verbose = 0;

  int in1=-1;

  char *fname="";

  if (argc<=2) { printf("%s %s\n",argv[0],Usage); goto main_error; }

  if (argc>1) sscanf(argv[1],"%d",&level);
  if (argc>2) sscanf(argv[2],"%d",&verbose);

  printf("level = %d, verbose = %d\n",level,verbose);

  edfio_debug_set(level);

  argno=3;
  while (argc>argno) {
    long numberofchains=0;
    const long *chainnumbers=NULL;

    fname=argv[argno++];
    if (strcmp(fname,"")) {
      /* Open the edf file */
      if (verbose>0) printf("11: edf_open_data_file( %s , ... )\n",fname);
      in1 = edf_open_data_file  ( fname, "read", &ErrorValue, &status );
      if (status) { 
        printf("%s\n",edf_report_data_error(ErrorValue)); 
        goto main_error; 
      }

      chainnumbers = edf_chain_numbers ( in1,
                                         &ErrorValue, &status );
      if (status) { 
        printf("%s\n",edf_report_data_error(ErrorValue)); 
        goto main_error; 
      }

      if (chainnumbers) {
        numberofchains=chainnumbers[0];

        // chainnumbers exists only until the file is closed!
        printf("file=\'%s\'/[%ld]:",fname,numberofchains);
        if (chainnumbers) {
          long i;
          for (i=1;i<=numberofchains;i++) {
            printf(" %ld",chainnumbers[i]);
          }
        } else {
          printf(" (no chains)");
        }
      }
      printf("\n");

      /* Close data file */
      if (verbose>0) printf("81: edf_close_data_file( %d , ... )\n",in1);
      edf_close_data_file( in1, &ErrorValue, &status );
      if (status) { 
        printf("%s\n",edf_report_data_error(ErrorValue)); 
        goto main_error; 
      }

    }

  } // while

  return( status );

main_error: 
  printf("Error exit\n");
  edf_close_data_file( in1, NULL, NULL );
  return(status);
  
} /* edfread */
