/*
 *   Project: The SPD Image correction and azimuthal regrouping
 *                      http://forge.epn-campus.eu/projects/show/azimuthal
 *
 *   Copyright (C) 2005-2010 European Synchrotron Radiation Facility
 *                           Grenoble, France
 *
 *   Principal authors: P. Boesecke (boesecke@esrf.fr)
 *                      R. Wilcke (wilcke@esrf.fr)
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published
 *   by the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   and the GNU Lesser General Public License  along with this program.
 *   If not, see <http://www.gnu.org/licenses/>.
 */

/*+++***********************************************************************
NAME

    dbgio.h

SYNOPSIS

    #include "dbgio.h"

DESCRIPTION
    Header of the module "dbgio.c"

HISTORY
    2017-02-12 V1.00 Peter Boesecke
    2017-02-28 V1.01 PB
    2017-05-22 V1.02 PB IODBG_MEMALLOC, IODBG_MEMSIZE, IODBG_MEMLIST,
                        IODBG_MEMFILEPOS

***************************************************************************/

#ifndef IODBG
#  define IODBG

/***************************************************************************
* Includes                                                                 *
***************************************************************************/
# include <stdio.h>
# include <stdlib.h>
# include <stdarg.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/
#ifndef PRIVATE
# define PRIVATE       static /* used to declare variables of private type */
# define PUBLIC                /* used to declare variables of public type */
#endif

#ifndef True
# define True           1
# define False          0
#endif

/***************************************************************************
* Debug                                                                    *
***************************************************************************/

# define IODBG_VERBOSE          0x1l
# define IODBG_SHOWATT          0x2l
# define IODBG_SHOWATTVAL       0x4l
# define IODBG_SHOWDATA         0x8l
# define IODBG_SHOWDATAVAL      0x10l
# define IODBG_SHOWHEADER       0x20l
# define IODBG_DEBUG1           0x40l
# define IODBG_DEBUG2           0x80l
# define IODBG_SHOWHIERARCHY    0x100l
# define IODBG_COMPRESSION      0x200l
# define IODBG_RASTER           0x400l
# define IODBG_HISTORY          0x800l
# define IODBG_HEADER           0x1000l
# define IODBG_NUMUNITS         0x2000l
# define IODBG_NUMCONSTANTS     0x4000l
# define IODBG_NUMPROGRAMS      0x8000l
# define IODBG_SHOWNODESEARCH   0x10000l
# define IODBG_EDF              0x20000l
# define IODBG_H5               0x40000l
# define IODBG_TMP              0x80000l
# define IODBG_MEMALLOC         0x100000l
# define IODBG_MEMSIZE          0x200000l
# define IODBG_MEMLIST          0x400000l
# define IODBG_MEMFILEPOS       0x800000l

PUBLIC extern const char
*iodbg_usage2str            ( void ),
*iodbg_version              ( void );

PUBLIC extern int
iodbg                       ( long flags ),
iodbg_fprint_debug          ( FILE *out );

PUBLIC extern long
iodbg_debug_set             ( long debug ),
iodbg_debug_or              ( long debug ),
iodbg_debug_and             ( long debug ),
iodbg_debug                 ( void ),
iodbg_level_set             ( long level ),
iodbg_level                 ( void );

#endif
#ifndef IODBG
#  define IODBG
#endif
/************************************************************************---*/

