/*
 *   Project: The SPD Image correction and azimuthal regrouping
 *                      http://forge.epn-campus.eu/projects/show/azimuthal
 *
 *   Copyright (C) 2005-2010 European Synchrotron Radiation Facility
 *                           Grenoble, France
 *
 *   Principal authors: P. Boesecke (boesecke@esrf.fr)
 *                      R. Wilcke (wilcke@esrf.fr)
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published
 *   by the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   and the GNU Lesser General Public License  along with this program.
 *   If not, see <http://www.gnu.org/licenses/>.
 */

/*+++***********************************************************************
NAME

   ioalloc.h

DESCRIPTION

   Include file for ioalloc.c

HISTORY
    2017-05-18  PB V0.5

***************************************************************************/

#ifndef _IOALLOC_
#  define _IOALLOC_

/***************************************************************************
* Includes                                                                 *
***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef WIN32
# include <unistd.h>
#endif

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
# define PRIVATE      static /* used to declare variables of private type */
# define PUBLIC               /* used to declare variables of public type */
#endif

# define FREE( a) { if ( a) { iofree( a); a = NULL; } }
# define MALLOC( a) iomalloc( a)
# define CALLOC( a, b) iocalloc( a, b)
# define REALLOC( a, b) iorealloc( a, b)

/***************************************************************************
* Functions                                                                *
***************************************************************************/

#if IOALLOC == 1

  #define iomemsize(V) _iomemsize(V)
  #define iomemlist(V) _iomemlist(V)
  #define iomalloc(S) _iomalloc(S,__FILE__,__LINE__)
  #define iocalloc(N,S) _iocalloc(N,S,__FILE__,__LINE__)
  #define iorealloc(P,S) _iorealloc(P,S,__FILE__,__LINE__)
  #define iofree(P) _iofree(P,__FILE__,__LINE__)

PUBLIC extern void
  *_iomalloc(size_t size,char *file,int line),
  *_iocalloc(size_t nmemb, size_t size, char *file,int line),
  *_iorealloc(void *ptr, size_t size, char *file,int line);

PUBLIC extern void
  _iofree(void *ptr, char *file,int line),
  _iomemsize(const char *prompt),
  _iomemlist(const char *prompt);

#else

  #define iomemsize(V) _iomemsize(V)
  #define iomemlist(V) _iomemlist(V)
  #define iomalloc malloc
  #define iofree free
  #define iocalloc calloc
  #define iorealloc realloc

PUBLIC extern void
  _iomemsize(const char *prompt),
  _iomemlist(const char *prompt);

#endif // IOALLOC

PUBLIC extern const char
    *ioalloc_version ( void );

#endif
#ifndef _IOALLOC_
#  define _IOALLOC_
#endif
/***************************************************************************/
