# include "h5sx.h"

/*---------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/

#if MAKE_FUNCTION
# define MAIN main_h5sxopen
#else
# define MAIN main
#endif

# define NULL_SPACE( s) ( ( s)? ( s) : ("" ) )
# define USAGE "[debug=<debug>] [level=<level>] [--help] <filename>"

int MAIN (int argc, char *argv[])
{
  int errval=0;
  int status=0;
  int argcnt=1;
  int debug = 2;
  int level = 10;

  int mode=H5ioOpenRead;
  const char *name="input.h5";
  const char *oname="output.h5";

  int stream=-1;

  if (argc<=1) {
    printf("%s\n",USAGE);
    return(1);
  }

  // skip all options
  while (argc > argcnt) {
    if ( strncmp( argv[argcnt],"debug=", 6 ) == 0 ) {
      debug = (int) num_str2double( &argv[argcnt][6], NULL, NULL);
      iodbg_debug_set( debug );
      argcnt++;
    } else if ( strncmp( argv[argcnt],"level=", 6 ) == 0 ) {
      sscanf(&argv[argcnt][6],"%d",&level);
      iodbg_level_set( level );
      argcnt++;
    } else if ( strncmp( argv[argcnt],"--version", 9 ) == 0 ) {
      printf("\n %s version: %s\n\n", argv[0], h5io_version());
      status=1;
      argcnt++;
      break;
    } else if ( strncmp( argv[argcnt],"oname=", 5 ) == 0 ) {
      oname=argv[argcnt]+5;
      argcnt++;
    } else if ( strncmp( argv[argcnt],"mode=", 5 ) == 0 ) {
      mode=h5io_str2openmode(argv[argcnt]+5);
      argcnt++;
    } else if ( strncmp( argv[argcnt],"--help", 6 ) == 0 ) {
      printf("\n %s version: %s\n", argv[0], h5io_version());
      printf(  " %s\n", h5io_usage2str());
      status=1;

      argcnt++;
      break;
    } else break;
  }

  if (!status) {
    while (argc>argcnt) {

     stream=h5sx_open_stream ( argv[argcnt++], mode, NULL );
     if (stream<0) goto main_error;

     h5sx_close_stream ( stream );

    }
  }

  return( status );

main_error:
  printf("Error exit\n");

  /*
   * Close hdf file.
   */
  h5sx_close_stream( stream );

  return(status);

} // MAIN
