/*
 *   Project: The SPD Image correction and azimuthal regrouping
 *                      http://forge.epn-campus.eu/projects/show/azimuthal
 *
 *   Copyright (C) 2005-2010 European Synchrotron Radiation Facility
 *                           Grenoble, France
 *
 *   Principal authors: P. Boesecke (boesecke@esrf.fr)
 *                      R. Wilcke (wilcke@esrf.fr)
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published
 *   by the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   and the GNU Lesser General Public License  along with this program.
 *   If not, see <http://www.gnu.org/licenses/>.
 */

/*+++***********************************************************************
NAME

    avg.h

SYNOPSIS

    #include "avg.h"

DESCRIPTION

    Header of the module "avg.c"

***********************************************************************---*/

#ifndef _AVG_

/****************************************************************************
*  Include                                                                  *
****************************************************************************/

# include <errno.h>
# include <stdio.h>
# include <unistd.h>
# include <fcntl.h>

# include "statfunc.h"
# include "strlib.h"
# include "ipol.h"
# include "reference.h"
# include "ioalloc.h"

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
# define PRIVATE       static /* used to declare variables of private type */
# define PUBLIC                /* used to declare variables of public type */
#endif

/***************************************************************************
* Averaging Mode Translation Tables                                        *
***************************************************************************/
enum AvgMode { InValidAvgMode, Mean=1, Median, Quantil, EndAvgMode };

/******************************************************************************
* Public Type Defs                                                            *
******************************************************************************/

typedef struct AvgPoint_ {
  long i_1; // index 1
  long i_2; // index 2
  struct AvgPoint_ *nextpoint;
} AvgPoint;

typedef struct {
  long  npoints;    // number of points in list
  AvgPoint *firstpoint; // first point of list
  AvgPoint *lastpoint;  // last point of list
} AvgListOfPoints;

typedef struct {
  float *data;        // stacked input images
  size_t data_size;   // size of data
  float *dummy;       // stacked dummy values, one per frame
  size_t dummy_size;  // size of ddummy
  float *ddummy;      // stacked dummy values, one per frame
  size_t ddummy_size; // size of ddummy
  long   counter;     // counter of stacked frames
} AvgData;

typedef struct {
  float val;  // average value
  float var;  // variance
  long  n;    // number of averaged values
  long  i;    // number of ignored values
} AvgValue;

/******************************************************************************
* Functions                                                                   *
******************************************************************************/

PUBLIC extern const char *avg_version ( void );

PUBLIC extern int string2avgmode( const char *string );
PUBLIC extern const char *avgmode2string( int amode );

PUBLIC extern AvgPoint *append_avgpoint( AvgListOfPoints *listofpoints, long i_1, long i_2 );
PUBLIC extern AvgPoint *first_avgpoint( AvgListOfPoints *listofpoints );
PUBLIC extern AvgPoint *get_avgpoint_and_increment( AvgPoint *point, long *pi_1, long *pi_2 );
PUBLIC extern AvgListOfPoints *new_avglistofpoints( void ); 
PUBLIC extern AvgListOfPoints *free_avglistofpoints( AvgListOfPoints *listofpoints );
PUBLIC extern long length_avglistofpoints( AvgListOfPoints *listofpoints );
PUBLIC extern void print_avglistofpoints( FILE *out, AvgListOfPoints *listofpoints );
PUBLIC extern void print_avglistofdatapoints( FILE *out, AvgListOfPoints *listofpoints,
                             float *data, long dim_1, long dim_2,
                             const char *name );

PUBLIC extern long fill_empty_avgpoints( float *data, long dim_1, long dim_2,
                      AvgListOfPoints *emptyavgpoints,
                      float dummy, float ddummy, float fil_1, float fil_2,
                      int debug, int *pstatus );

PUBLIC extern AvgData *new_avg_data(AvgData *avg_data, long dim_1, long dim_2, long dim_3);
PUBLIC extern AvgData *free_avg_data ( AvgData *avg_data );

PUBLIC extern AvgValue average( const long dim[], const float *frames, 
                  const float *dummy, const float *ddummy,
                  long i_1, long i_2, int amode, int fmode,
                  int vmode, int dovar, float lfac, float ufac,
                  float mins, float loq, float upq, float pq,
                  int *pstatus );

# define _AVG_
#endif /* _AVG_ */
