/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/* @(#) $Source: GetFrame.h V1.0 by P. Daly c. ESRF February 1995 $ */
/**************************************************************************/
/* GetGel.h                                                               */
/**************************************************************************/

#ifndef _GETGEL_ROUTINES 
#define _GETGEL_ROUTINES

  extern int 
     ReadGelData (FILE *stream, int FrameNumber, void **Start),
     ReadGelType (FILE *stream, int *X, int *Y, int *DataLength,
                  int *DataFloatI, int * OffsetX, int * OffsetY),
     ReadGelScalars (FILE *stream, long Scalars[32],int FrameNumber),
     ReadGelInfo(FILE * stream, 
         char * DetectorType[], 
         char * MachineInfo[],
         char * OpticsInfo[],
         char * StationInfo[],
         char * ProposalInfo[]),
     ReadGelExperiment(FILE * stream,
         char * Title[],
         char * ExperimentInfo[],
         char * HmFraming[],
         char   HmStartTime[],
         float * Center_1, float * Center_2, int * ICenter,
         float * PixSize_1, float * PixSize_2, int * IPixSize,
         float * WaveLength, int * IWaveLength,
         float * SampleDistance, int * ISampleDistance);

#endif /* _GETGEL_ROUTINES */

/**************************************************************************/
/*                                                                        */
/**************************************************************************/

