/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/* History
   2004-05-30 from fcalc
   2004-10-30 MAKE_FUNCTION, all exits removed
   2005-02-12 ERROUT
   2007-03-08 ReportInputStatus replaced by ReportSaxsStatus, numio.h
*/
#       include <errno.h>
#       include <stdio.h>
#       include <fcntl.h>
#       include "SaxsError.h"
#       include "SaxsInput.h"
#       include "numio.h"
/*---------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/

#if MAKE_FUNCTION
# define MAIN main_fcalc
#else
# define MAIN main
#endif

int MAIN (int argc, char *argv[])
{ char buffer[512];
  unsigned long buflen=512;
  int errval;
  int status=Success;
  int argcnt=1;
  long longnumber = 1l;
  char * unit = "";
  int digits = 15;

  // skip all options
  while (argc > argcnt) {
    if ( strncmp( argv[argcnt],"unit=", 5 ) == 0 ) {
      unit=&argv[argcnt][5];
      argcnt++; }
    else if ( strncmp( argv[argcnt],"digits=", 7 ) == 0 ) {
      sscanf(&argv[argcnt][7],"%d",&digits);
      argcnt++; }
    else if ( strncmp( argv[argcnt],"--help", 6 ) == 0 ) {
      printf("\n Programm %s (PB 2004-10-30)\n\n", argv[0]);
      printf(" %s [units=<unit>] [digits=<digits>] [--help] <expression>\n",
             argv[0]);
      status=StoppedAfterHelp;
      argcnt++;
      break; }
    else break;
  }

  if (status == Success) {
    if (argc>argcnt) {
      while (argc>argcnt) {
        longnumber = longexpr(argv[argcnt],&status);
        if (status!=Success) ReportSaxsStatus(status,1);
        printf( "%s\n",
          num_long2str( buffer,buflen,longnumber,&errval ) );
        if (errval) {
          fprintf(ERROUT,"ERROR: %s\n",num_errval2str( buffer,buflen,errval ));
        }
        argcnt++;
      }
    } else {
      while ( status != NoDefault ) {
        status = GetLong (stdin, &longnumber, 0, "icalc", longnumber);
        if (status!=Success) ReportSaxsStatus(status,1);
        printf( "%s\n",
          num_long2str( buffer,buflen,longnumber,&errval ));
        if (errval) {
          fprintf(ERROUT,"ERROR: %s\n",num_errval2str( buffer,buflen,errval ));
        }
      }
    }
  }
  if (status != Success) ReportSaxsStatus(status,0);
  return ( status );
}

/* empty definition, not used */
char *edf_report_data_error     ( int ErrorValue )
{ return("ExternalError not available\n") ;}
