/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/*+++***********************************************************************
NAME

    mpa.h

SYNOPSIS

    #include "mpa.h"

DESCRIPTION

    Header of the module "mpa.c"

***********************************************************************---*/
#ifndef _MPA_
# define _MPA_

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
# define PRIVATE       static /* used to declare variables of private type */
# define PUBLIC                /* used to declare variables of public type */
#endif

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <stdio.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

# include "edfio.h" 

/******************************************************************************
* Public Type Defs                                                            *
******************************************************************************/

typedef struct mpa_Data {
  char * header_key;

  long * data0;
  long data0len; // buffer length

  long * data1;
  long data1len; // buffer length

  long * cdat0;
  long cdat0len; // buffer length

} MpaData;

/*===========================================================================*/

/***************************************************************************
* Functions                                                                *
***************************************************************************/

PUBLIC extern MpaData
     * mpa_New( const char * mpa_key );

PUBLIC extern int
       mpa_Read( MpaData * data, const char * filename,
                 int readdata );

PUBLIC extern int
       mpa_Free( MpaData * data );

PUBLIC extern void
       mpa_debug ( int debug );
#endif
