/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/*+++***********************************************************************
NAME
   SaxsReplacekey --- Replaces keys in strings with values
 
SYNOPSIS
 
   # include SaxsReplacekey.h
 
DESCRIPTION
    Header of the module "SaxsReplacekey.c"
 
HISTORY
2002-02-06 V1.1 Peter Boesecke
2003-05-30 V1.3 Peter Boesecke
2003-08-11 V1.5 Peter Boesecke
2005-11-30 V1.8 Peter Boesecke
2006-08-02 V1.9 Peter Boesecke
2006-08-08 V1.10 Peter Boesecke recursive use of spkey for all parameters
2013-05-28 V1.18 Peter Boesecke replacekey_show added
2015-10-04 V1.19 Peter Boesecke hasreplacekey added
***************************************************************************/

#ifndef _SAXSRPK_ 
#  define _SAXSRPK_

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/
#  ifndef PRIVATE
#    define PRIVATE   static
#    define PUBLIC
#  endif

# include "SaxsOption.h"

PUBLIC extern const char
   // return version
 * replacekey_version ( void ),
 * replacekey_show ( void );

PUBLIC extern int
   // return 1 if string contains a key
   hasreplacekey( const char *string );

PUBLIC extern double 
   // return double value 
   doublekeyvalue( const char *string,
                   CmdBlk *pcb, ImgBlk ib[], long Num[],
                   long blkno, int * pstatus );

PUBLIC extern float 
   // return float value
   floatkeyvalue( const char *string,
                  CmdBlk *pcb, ImgBlk ib[], long Num[],
                  long blkno, int * pstatus );

PUBLIC extern long 
   // return long value
   longkeyvalue( const char *string,
                 CmdBlk *pcb, ImgBlk ib[], long Num[], 
                 long blkno, int * pstatus );

PUBLIC extern char 
 * linekeyvalue ( char * buffer, size_t buflen, const char *string, long npar,
                  CmdBlk *pcb, ImgBlk ib[], long Num[], 
                  long blkno, int * pstatus );

#endif
/************************************************************************---*/

