/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/*+++***********************************************************************
NAME

    roca_base.h

SYNOPSIS

    #include "roca_base.h"

DESCRIPTION
    Header of the module "roca_base.c"

***********************************************************************---*/
#ifndef _roca_base_
# define _roca_base_

/****************************************************************************
*  Include                                                                  *
****************************************************************************/

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <stdio.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

# include "tilt3d.h"

/***************************************************************************
* Definitions                                                              *
***************************************************************************/

# define ROCABUFLEN 1024

# define ROCA_VERBOSE   0x1
# define ROCA_LEVEL     0x6 // 0x2 0x4 -> level 0 -> 3
# define ROCA_SHOWDATA  0x8
# define ROCA_SHOWTEMP  0x10
# define ROCA_DEBUG     0x20
# define ROCA_LISTDEBUG 0x40
# define ROCA_SAVESTEPS 0x80

# define ROCA_STEPFILE  "roca_iteration.spec"

/****************************************************************************
* Enums                                                                     *
****************************************************************************/
enum RocaParam {
  Pix1, Pix2, Cen1, Cen2, Dis, Rot1, Rot2, Rot3,
  NParams }; // last element must be NParams

enum RocaStat {
  RStdDev, RMinDev, RMaxDev, RTotal, RNData,  RNopt,
  NStats }; // last element must be NStats

/****************************************************************************
* Functions                                                                 *
****************************************************************************/

const char *roca_libversion ( void );

int   ROCALevel ( void );

int   ROCADebug ( void );

int   RocaDebugSet( int debug );

const char **RocaParamNamesArray( void );

int *RocaParamDefaultArray( void );

const char *RocaUsage2str( void );

int   RocaBeamCenter(double I[2], double Par[NParams]);

int   RocaBeamDistance(double *pdistance, double Par[NParams]);

int   RocaTilt(double tilt[3], double Par[NParams]);

int   RocaOptimize( double ParOpt[NParams], double ParDev[NParams], 
                    double ParStat[NStats],
                    double Par[NParams], int ParMode[NParams], 
                    size_t ndata, double Angle[], double I1[], double I2[],
                    double Weight[],
                    double maxdev, int maxiter  );

char * sprint_parameters( char * buffer, size_t bufsiz, double Par[] );

char * sprint_beam_parameters( char * buffer, size_t bufsiz, double Par[] );

char * sprint_statistics( char * buffer, size_t bufsiz, double Stat[] );

/***************************************************************************/

#endif
