/****************************************************************************
*  Include                                                                  *
****************************************************************************/
# include <errno.h>
# include <stdio.h>
# include <stdlib.h>
# include <stdarg.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>
  
# include "strlib.h"
# include "numio.h" 
# include "edfio.h" 

const char separators[] = { ' ', '\t', '\r', '\n', '\f', '\v', '\0' };

/*---------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/

#if MAKE_FUNCTION
# define MAIN main_headerstattest
#else
# define MAIN main
#endif

# define BUFLEN 2048
int MAIN (int argc, char *argv[])
{ 
  char buf[BUFLEN];                       // buffer for input command
  int status, errval;
  int verbose=1, level=2;

  char *nul = (char *) NULL;
  char **pargv;
  char *ps;

  const char *header_key = "header";
  const char *key, *value;

  pargv=&argv[1];
  while ( *pargv!=nul ) {

    if ( strncmp( *pargv,"verbose=", 8 ) == 0 ) {
      // set verbose
      ps=*pargv+8;
      verbose = (int) num_str2double ( ps, NULL, &errval);
      /* .... */
    } else  if ( strncmp( *pargv,"level=", 6 ) == 0 ) {
      // set level
      ps=*pargv+6;
      level = (int) num_str2double ( ps, NULL, &errval);
      /* .... */
    }

    if (*pargv) pargv++;

  } // while

/*
unsigned long
edf_stat_header_element     ( const char *header_key,
                              const char *key, const char *statkey,
                              int *pErrorValue, int *pstatus );
*/

  // create header
  edf_new_header( header_key );

  printf("key value > ");
  fgets(buf,BUFLEN, stdin);
  while(!feof(stdin)) {
    if (!(strlib_is_empty(buf))) {
      char *lasts;

      printf("-------------------------------------------------------\n");

      // first param key string
      key = strlib_tok_r(buf, separators, &lasts);

      // *strlib_tok_r(char *s, const char *sep, char **lasts);
      // second param value string
      value = strlib_trimcrlf(strlib_tok_r(NULL, "", &lasts));

      // add_header_element key value
      edf_add_header_element ( header_key, key, value, &errval, &status );
      if (status) { 
        printf("%s\n",edf_report_data_error(errval)); 
        goto main_error; 
      }

    } // if not empty

    printf("key value > ");
    fgets(buf,BUFLEN, stdin);
  } /* while */

  printf("\n");

  // print header stat of all header keys
  edf_print_header( stdout, header_key, level, verbose );

  // release header
  edf_free_header( header_key );


  return(0);

main_error:

  // release header
  edf_free_header( header_key );
  return(-1);

} /* MAIN */
