#       include <errno.h>
#       include <stdio.h>
#       include <fcntl.h>
#       include "numio.h"

/*+++------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/
# define Usage "<ndigits> <value>"
   
main (int argc, char *argv[])
{
  int ndigits ;
  char *inp_string, *hex_string;
  size_t maxlen, buflen;
  char *buffer;

  int errval=0;
  double value;
  long hex=16;

  
  if (argc<=2) { printf("%s %s\n",argv[0],Usage); return(-1); }

  ndigits=9;
  if (argc>1) sscanf(argv[1],"%d",&ndigits);

  inp_string="inp_string";
  if (argc>2) inp_string = argv[2];

  printf("ndigits = %d\n",ndigits);
  printf("inp_string = >%s<\n",inp_string);

  maxlen = ndigits+256;

  buflen = sizeof(char)*(maxlen+1);
  buffer = (char *) malloc( buflen );
  if (!buffer) { 
    printf("Allocation error of %s bytes\n",buflen);
    return(-1);
  }

  value = num_str2double ( inp_string, NULL, &errval );
  if (errval) {
    printf("ERROR: num_str2double %d\n",errval);
    goto main_error;
  }


  hex_string = num_double2hex( buffer, buflen, value, ndigits, &errval );
  if (errval) {
    printf("ERROR: num_double2hex\n",errval);
    goto main_error;
  }

  printf("input  = >>%s<<\n",inp_string);
  printf("output = >>%s<<\n",hex_string);

  return(0);

main_error:

  return(-1);

} // main
