/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.Activator;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TypedText
extends Composite {
    protected static final int SPACING = 5;
    protected static final int MARGIN = 1;
    private final String ID_REQUIRED = "required.field";
    private final String ID_FORMAT = "format.field";
    protected boolean _bValide = true;
    protected boolean _isRequiredField;
    protected Text textField;
    protected Label _label;
    protected ControlDecoration textFieldDecorated;
    protected FieldDecorationRegistry _registry;
    protected Image _imgRequired = Activator.imageDescriptorFromPlugin((String)"fable.framework.toolbox", (String)"images/required_field.gif").createImage();
    protected Image _imgError = Activator.imageDescriptorFromPlugin((String)"fable.framework.toolbox", (String)"images/errorField.gif").createImage();
    protected String _errorMessage = "";
    private String name = "";

    protected TypedText(Composite parent, int style) {
        super(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        this.setLayout((Layout)gl);
        this.setLayoutData(new GridData(256, 2, true, true));
        this.createFields(style);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
            }
        });
        this.textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TypedText.this._bValide = TypedText.this.checkValue(((Text)e.widget).getText());
                TypedText.this.showDecoration();
            }
        });
        this.textField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                TypedText.this._bValide = TypedText.this.checkValue(((Text)e.widget).getText());
                TypedText.this.showDecoration();
            }
        });
    }

    protected TypedText(Composite parent, int style, String LabelText) {
        this(parent, style);
        this._label.setText(LabelText);
        this.name = LabelText;
    }

    public boolean set_Text(String txt) {
        if (txt != null) {
            ((Text)this.textFieldDecorated.getControl()).setText(txt);
            this._bValide = this.checkValue(txt);
            this.showDecoration();
        }
        return this._bValide;
    }

    public void setBackground(Color color) {
        ((Text)this.textFieldDecorated.getControl()).setBackground(color);
    }

    public void setToolTipText(String string) {
        this.textField.setToolTipText(string);
    }

    public Text getTextField() {
        return this.textField;
    }

    public boolean is_bValide() {
        return this._bValide;
    }

    public void set_bValide(boolean valide) {
        this._bValide = valide;
    }

    public String getText() {
        return this.textField.getText();
    }

    public boolean is_isRequiredField() {
        return this._isRequiredField;
    }

    public void set_isRequiredField(boolean requiredField) {
        this._isRequiredField = requiredField;
        this._bValide = this.checkValue(this.getText());
    }

    public void showDecoration() {
        this.textFieldDecorated.hide();
        if (!this.showRequired()) {
            if (this.showError()) {
                this.textFieldDecorated.show();
            }
        } else {
            this.textFieldDecorated.show();
        }
    }

    private void createFields(int style) {
        this._label = new Label((Composite)this, 0);
        this._label.setVisible(true);
        this.textField = new Text((Composite)this, 0x800 | style);
        this.textFieldDecorated = new ControlDecoration((Control)this.textField, 16512);
        this._registry = FieldDecorationRegistry.getDefault();
        this._registry.registerFieldDecoration("format.field", "This field should contain a typed value", this._imgError);
        this._registry.registerFieldDecoration("required.field", "This field is required", this._imgRequired);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 1;
        gd.horizontalIndent = 8;
        this.textFieldDecorated.getControl().setLayoutData((Object)gd);
    }

    public boolean checkValue(String str) {
        return this.is_isRequiredField();
    }

    public String getErrorMessage() {
        if (this.showRequired()) {
            return "Field is required";
        }
        return this.getErrorFormatDescription();
    }

    private boolean showError() {
        boolean value = false;
        if (!this.is_bValide()) {
            this.textFieldDecorated.setDescriptionText(this.getErrorFormatDescription());
            this.textFieldDecorated.setImage(this._registry.getFieldDecoration("format.field").getImage());
            value = true;
        }
        return value;
    }

    private boolean showRequired() {
        boolean value = false;
        if (this.is_isRequiredField() && (this.textField.getText() == null || this.textField.getText().trim().length() == 0)) {
            String description = this._registry.getFieldDecoration("required.field").getDescription();
            this.textFieldDecorated.setDescriptionText(description);
            this.textFieldDecorated.setImage(this._registry.getFieldDecoration("required.field").getImage());
            value = true;
        }
        return value;
    }

    protected String getErrorFormatDescription() {
        return this._registry.getFieldDecoration("format.field").getDescription();
    }

    public void setEnabled(boolean enable) {
        this.textField.setEnabled(enable);
        if (!enable) {
            this._bValide = true;
            this.showDecoration();
        } else {
            this._bValide = this.checkValue(this.textField.getText());
            this.showDecoration();
        }
    }

    public String toString() {
        String s = "";
        s = this._label != null && !this._label.getText().equals("") ? this._label.getText() : this.name;
        return s;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setLabel(String label) {
        this._label.setText(label);
    }

    public String getLabel() {
        return this._label.getText();
    }
}

