

# ctypes interface to KLT: An Implementation of the
# Kanade-Lucas-Tomasi Feature Tracker
# http://www.ces.clemson.edu/~stb/klt/
#
"""
**********************************************************************
NOTICE:

This code is now in the public domain.  The Stanford Office of
Technology Licensing has removed all licensing restrictions.

**********************************************************************

KLT
An implementation of the Kanade-Lucas-Tomasi feature tracker

Version 1.3.4

Authors: Stan Birchfield
         stb@clemson.edu

         Thorsten Thormaehlen
         thormae@tnt.uni-hannover.de
         (implemented affine code)

         Thanks to many others for various bug fixes.

Date: August   30, A.D. 2007
      May      10, A.D. 2007
      March    28, A.D. 2006
      November 21, A.D. 2005
      August   17, A.D. 2005
      June     16, A.D. 2004
      October   7, A.D. 1998

The code can be obtained from http://www.ces.clemson.edu/~stb/klt
(alternatively http://www.vision.stanford.edu/~birch/klt),
where the official manuals reside.  For your convenience, unofficial
manuals have been placed in the current subdirectory 'doc'.
"""



# Code generated by Thomas Heller's h2xml.py and xml2py.py scripts
# for ctypes.
# These were run on klt.h and called upon gccxml to interpret the
# C headers. Gccxml itself depends in turn on Visual Studio 2005
# which was a free download from microsoft.

# Minor edits by Jon Wright to try to find the right shared library for
# linux versus windows.

from ctypes import *

_libraries = {}

import sys, os.path



if sys.platform == "linux2":
    # What is the clean way to know if 64 or 32 bit?
    try:
        _libraries['klt_bin'] = CDLL(
            os.path.join( os.path.split(__file__)[0], 'libKLT64.so')
            )
    except:
        try:
            _libraries['klt_bin'] = CDLL(
                os.path.join( os.path.split(__file__)[0], 'libKLT32.so')
                )
        except:
            pass
        
if sys.platform == "win32":
    _libraries['klt_bin'] = CDLL(
        os.path.join( os.path.split(__file__)[0], 'klt.dll')
        )
# If you still don't have it you probably have a mac??

STRING = c_char_p


KLT_locType = c_float
KLT_PixelType = c_ubyte
class KLT_TrackingContextRec(Structure):
    pass
KLT_TrackingContext = POINTER(KLT_TrackingContextRec)
KLT_TrackingContextRec._fields_ = [
    ('mindist', c_int),
    ('window_width', c_int),
    ('window_height', c_int),
    ('sequentialMode', c_int),
    ('smoothBeforeSelecting', c_int),
    ('writeInternalImages', c_int),
    ('lighting_insensitive', c_int),
    ('min_eigenvalue', c_int),
    ('min_determinant', c_float),
    ('min_displacement', c_float),
    ('max_iterations', c_int),
    ('max_residue', c_float),
    ('grad_sigma', c_float),
    ('smooth_sigma_fact', c_float),
    ('pyramid_sigma_fact', c_float),
    ('step_factor', c_float),
    ('nSkippedPixels', c_int),
    ('borderx', c_int),
    ('bordery', c_int),
    ('nPyramidLevels', c_int),
    ('subsampling', c_int),
    ('affine_window_width', c_int),
    ('affine_window_height', c_int),
    ('affineConsistencyCheck', c_int),
    ('affine_max_iterations', c_int),
    ('affine_max_residue', c_float),
    ('affine_min_displacement', c_float),
    ('affine_max_displacement_differ', c_float),
    ('pyramid_last', c_void_p),
    ('pyramid_last_gradx', c_void_p),
    ('pyramid_last_grady', c_void_p),
]
class KLT_FeatureRec(Structure):
    pass
KLT_Feature = POINTER(KLT_FeatureRec)
class _KLT_FloatImageRec(Structure):
    pass
_KLT_FloatImage = POINTER(_KLT_FloatImageRec)
KLT_FeatureRec._fields_ = [
    ('x', KLT_locType),
    ('y', KLT_locType),
    ('val', c_int),
    ('aff_img', _KLT_FloatImage),
    ('aff_img_gradx', _KLT_FloatImage),
    ('aff_img_grady', _KLT_FloatImage),
    ('aff_x', KLT_locType),
    ('aff_y', KLT_locType),
    ('aff_Axx', KLT_locType),
    ('aff_Ayx', KLT_locType),
    ('aff_Axy', KLT_locType),
    ('aff_Ayy', KLT_locType),
]
class KLT_FeatureListRec(Structure):
    pass
KLT_FeatureList = POINTER(KLT_FeatureListRec)
KLT_FeatureListRec._fields_ = [
    ('nFeatures', c_int),
    ('feature', POINTER(KLT_Feature)),
]
class KLT_FeatureHistoryRec(Structure):
    pass
KLT_FeatureHistoryRec._fields_ = [
    ('nFrames', c_int),
    ('feature', POINTER(KLT_Feature)),
]
KLT_FeatureHistory = POINTER(KLT_FeatureHistoryRec)
class KLT_FeatureTableRec(Structure):
    pass
KLT_FeatureTable = POINTER(KLT_FeatureTableRec)
KLT_FeatureTableRec._fields_ = [
    ('nFrames', c_int),
    ('nFeatures', c_int),
    ('feature', POINTER(POINTER(KLT_Feature))),
]
KLTCreateTrackingContext = _libraries['klt_bin'].KLTCreateTrackingContext
KLTCreateTrackingContext.restype = KLT_TrackingContext
KLTCreateTrackingContext.argtypes = []
KLTCreateTrackingContext.__doc__ = \
"""KLT_TrackingContext KLTCreateTrackingContext()
../klt.h:131"""
KLTCreateFeatureList = _libraries['klt_bin'].KLTCreateFeatureList
KLTCreateFeatureList.restype = KLT_FeatureList
KLTCreateFeatureList.argtypes = [c_int]
KLTCreateFeatureList.__doc__ = \
"""KLT_FeatureList KLTCreateFeatureList(int nFeatures)
../klt.h:133"""
KLTCreateFeatureHistory = _libraries['klt_bin'].KLTCreateFeatureHistory
KLTCreateFeatureHistory.restype = KLT_FeatureHistory
KLTCreateFeatureHistory.argtypes = [c_int]
KLTCreateFeatureHistory.__doc__ = \
"""KLT_FeatureHistory KLTCreateFeatureHistory(int nFrames)
../klt.h:135"""
KLTCreateFeatureTable = _libraries['klt_bin'].KLTCreateFeatureTable
KLTCreateFeatureTable.restype = KLT_FeatureTable
KLTCreateFeatureTable.argtypes = [c_int, c_int]
KLTCreateFeatureTable.__doc__ = \
"""KLT_FeatureTable KLTCreateFeatureTable(int nFrames, int nFeatures)
../klt.h:138"""
KLTFreeTrackingContext = _libraries['klt_bin'].KLTFreeTrackingContext
KLTFreeTrackingContext.restype = None
KLTFreeTrackingContext.argtypes = [KLT_TrackingContext]
KLTFreeTrackingContext.__doc__ = \
"""void KLTFreeTrackingContext(KLT_TrackingContext tc)
../klt.h:142"""
KLTFreeFeatureList = _libraries['klt_bin'].KLTFreeFeatureList
KLTFreeFeatureList.restype = None
KLTFreeFeatureList.argtypes = [KLT_FeatureList]
KLTFreeFeatureList.__doc__ = \
"""void KLTFreeFeatureList(KLT_FeatureList fl)
../klt.h:144"""
KLTFreeFeatureHistory = _libraries['klt_bin'].KLTFreeFeatureHistory
KLTFreeFeatureHistory.restype = None
KLTFreeFeatureHistory.argtypes = [KLT_FeatureHistory]
KLTFreeFeatureHistory.__doc__ = \
"""void KLTFreeFeatureHistory(KLT_FeatureHistory fh)
../klt.h:146"""
KLTFreeFeatureTable = _libraries['klt_bin'].KLTFreeFeatureTable
KLTFreeFeatureTable.restype = None
KLTFreeFeatureTable.argtypes = [KLT_FeatureTable]
KLTFreeFeatureTable.__doc__ = \
"""void KLTFreeFeatureTable(KLT_FeatureTable ft)
../klt.h:148"""
KLTSelectGoodFeatures = _libraries['klt_bin'].KLTSelectGoodFeatures
KLTSelectGoodFeatures.restype = None
KLTSelectGoodFeatures.argtypes = [KLT_TrackingContext, POINTER(KLT_PixelType), c_int, c_int, KLT_FeatureList]
KLTSelectGoodFeatures.__doc__ = \
"""void KLTSelectGoodFeatures(KLT_TrackingContext tc, KLT_PixelType * img, int ncols, int nrows, KLT_FeatureList fl)
../klt.h:156"""
KLTTrackFeatures = _libraries['klt_bin'].KLTTrackFeatures
KLTTrackFeatures.restype = None
KLTTrackFeatures.argtypes = [KLT_TrackingContext, POINTER(KLT_PixelType), POINTER(KLT_PixelType), c_int, c_int, KLT_FeatureList]
KLTTrackFeatures.__doc__ = \
"""void KLTTrackFeatures(KLT_TrackingContext tc, KLT_PixelType * img1, KLT_PixelType * img2, int ncols, int nrows, KLT_FeatureList fl)
../klt.h:163"""
KLTReplaceLostFeatures = _libraries['klt_bin'].KLTReplaceLostFeatures
KLTReplaceLostFeatures.restype = None
KLTReplaceLostFeatures.argtypes = [KLT_TrackingContext, POINTER(KLT_PixelType), c_int, c_int, KLT_FeatureList]
KLTReplaceLostFeatures.__doc__ = \
"""void KLTReplaceLostFeatures(KLT_TrackingContext tc, KLT_PixelType * img, int ncols, int nrows, KLT_FeatureList fl)
../klt.h:169"""
KLTCountRemainingFeatures = _libraries['klt_bin'].KLTCountRemainingFeatures
KLTCountRemainingFeatures.restype = c_int
KLTCountRemainingFeatures.argtypes = [KLT_FeatureList]
KLTCountRemainingFeatures.__doc__ = \
"""int KLTCountRemainingFeatures(KLT_FeatureList fl)
../klt.h:173"""
KLTPrintTrackingContext = _libraries['klt_bin'].KLTPrintTrackingContext
KLTPrintTrackingContext.restype = None
KLTPrintTrackingContext.argtypes = [KLT_TrackingContext]
KLTPrintTrackingContext.__doc__ = \
"""void KLTPrintTrackingContext(KLT_TrackingContext tc)
../klt.h:175"""
KLTChangeTCPyramid = _libraries['klt_bin'].KLTChangeTCPyramid
KLTChangeTCPyramid.restype = None
KLTChangeTCPyramid.argtypes = [KLT_TrackingContext, c_int]
KLTChangeTCPyramid.__doc__ = \
"""void KLTChangeTCPyramid(KLT_TrackingContext tc, int search_range)
../klt.h:178"""
KLTUpdateTCBorder = _libraries['klt_bin'].KLTUpdateTCBorder
KLTUpdateTCBorder.restype = None
KLTUpdateTCBorder.argtypes = [KLT_TrackingContext]
KLTUpdateTCBorder.__doc__ = \
"""void KLTUpdateTCBorder(KLT_TrackingContext tc)
../klt.h:180"""
KLTStopSequentialMode = _libraries['klt_bin'].KLTStopSequentialMode
KLTStopSequentialMode.restype = None
KLTStopSequentialMode.argtypes = [KLT_TrackingContext]
KLTStopSequentialMode.__doc__ = \
"""void KLTStopSequentialMode(KLT_TrackingContext tc)
../klt.h:182"""
KLTSetVerbosity = _libraries['klt_bin'].KLTSetVerbosity
KLTSetVerbosity.restype = None
KLTSetVerbosity.argtypes = [c_int]
KLTSetVerbosity.__doc__ = \
"""void KLTSetVerbosity(int verbosity)
../klt.h:184"""
_KLTComputeSmoothSigma = _libraries['klt_bin']._KLTComputeSmoothSigma
_KLTComputeSmoothSigma.restype = c_float
_KLTComputeSmoothSigma.argtypes = [KLT_TrackingContext]
_KLTComputeSmoothSigma.__doc__ = \
"""float _KLTComputeSmoothSigma(KLT_TrackingContext tc)
../klt.h:186"""
KLTStoreFeatureList = _libraries['klt_bin'].KLTStoreFeatureList
KLTStoreFeatureList.restype = None
KLTStoreFeatureList.argtypes = [KLT_FeatureList, KLT_FeatureTable, c_int]
KLTStoreFeatureList.__doc__ = \
"""void KLTStoreFeatureList(KLT_FeatureList fl, KLT_FeatureTable ft, int frame)
../klt.h:192"""
KLTExtractFeatureList = _libraries['klt_bin'].KLTExtractFeatureList
KLTExtractFeatureList.restype = None
KLTExtractFeatureList.argtypes = [KLT_FeatureList, KLT_FeatureTable, c_int]
KLTExtractFeatureList.__doc__ = \
"""void KLTExtractFeatureList(KLT_FeatureList fl, KLT_FeatureTable ft, int frame)
../klt.h:196"""
KLTStoreFeatureHistory = _libraries['klt_bin'].KLTStoreFeatureHistory
KLTStoreFeatureHistory.restype = None
KLTStoreFeatureHistory.argtypes = [KLT_FeatureHistory, KLT_FeatureTable, c_int]
KLTStoreFeatureHistory.__doc__ = \
"""void KLTStoreFeatureHistory(KLT_FeatureHistory fh, KLT_FeatureTable ft, int feat)
../klt.h:200"""
KLTExtractFeatureHistory = _libraries['klt_bin'].KLTExtractFeatureHistory
KLTExtractFeatureHistory.restype = None
KLTExtractFeatureHistory.argtypes = [KLT_FeatureHistory, KLT_FeatureTable, c_int]
KLTExtractFeatureHistory.__doc__ = \
"""void KLTExtractFeatureHistory(KLT_FeatureHistory fh, KLT_FeatureTable ft, int feat)
../klt.h:204"""
KLTWriteFeatureListToPPM = _libraries['klt_bin'].KLTWriteFeatureListToPPM
KLTWriteFeatureListToPPM.restype = None
KLTWriteFeatureListToPPM.argtypes = [KLT_FeatureList, POINTER(KLT_PixelType), c_int, c_int, STRING]
KLTWriteFeatureListToPPM.__doc__ = \
"""void KLTWriteFeatureListToPPM(KLT_FeatureList fl, KLT_PixelType * greyimg, int ncols, int nrows, char * filename)
../klt.h:212"""
KLTWriteFeatureList = _libraries['klt_bin'].KLTWriteFeatureList
KLTWriteFeatureList.restype = None
KLTWriteFeatureList.argtypes = [KLT_FeatureList, STRING, STRING]
KLTWriteFeatureList.__doc__ = \
"""void KLTWriteFeatureList(KLT_FeatureList fl, char * filename, char * fmt)
../klt.h:216"""
KLTWriteFeatureHistory = _libraries['klt_bin'].KLTWriteFeatureHistory
KLTWriteFeatureHistory.restype = None
KLTWriteFeatureHistory.argtypes = [KLT_FeatureHistory, STRING, STRING]
KLTWriteFeatureHistory.__doc__ = \
"""void KLTWriteFeatureHistory(KLT_FeatureHistory fh, char * filename, char * fmt)
../klt.h:220"""
KLTWriteFeatureTable = _libraries['klt_bin'].KLTWriteFeatureTable
KLTWriteFeatureTable.restype = None
KLTWriteFeatureTable.argtypes = [KLT_FeatureTable, STRING, STRING]
KLTWriteFeatureTable.__doc__ = \
"""void KLTWriteFeatureTable(KLT_FeatureTable ft, char * filename, char * fmt)
../klt.h:224"""
KLTReadFeatureList = _libraries['klt_bin'].KLTReadFeatureList
KLTReadFeatureList.restype = KLT_FeatureList
KLTReadFeatureList.argtypes = [KLT_FeatureList, STRING]
KLTReadFeatureList.__doc__ = \
"""KLT_FeatureList KLTReadFeatureList(KLT_FeatureList fl, char * filename)
../klt.h:227"""
KLTReadFeatureHistory = _libraries['klt_bin'].KLTReadFeatureHistory
KLTReadFeatureHistory.restype = KLT_FeatureHistory
KLTReadFeatureHistory.argtypes = [KLT_FeatureHistory, STRING]
KLTReadFeatureHistory.__doc__ = \
"""KLT_FeatureHistory KLTReadFeatureHistory(KLT_FeatureHistory fh, char * filename)
../klt.h:230"""
KLTReadFeatureTable = _libraries['klt_bin'].KLTReadFeatureTable
KLTReadFeatureTable.restype = KLT_FeatureTable
KLTReadFeatureTable.argtypes = [KLT_FeatureTable, STRING]
KLTReadFeatureTable.__doc__ = \
"""KLT_FeatureTable KLTReadFeatureTable(KLT_FeatureTable ft, char * filename)
../klt.h:233"""
_KLT_FloatImageRec._fields_ = [
    ('ncols', c_int),
    ('nrows', c_int),
    ('data', POINTER(c_float)),
]
_KLTCreateFloatImage = _libraries['klt_bin']._KLTCreateFloatImage
_KLTCreateFloatImage.restype = _KLT_FloatImage
_KLTCreateFloatImage.argtypes = [c_int, c_int]
_KLTCreateFloatImage.__doc__ = \
"""_KLT_FloatImage _KLTCreateFloatImage(int ncols, int nrows)
../klt_util.h:16"""
_KLTFreeFloatImage = _libraries['klt_bin']._KLTFreeFloatImage
_KLTFreeFloatImage.restype = None
_KLTFreeFloatImage.argtypes = [_KLT_FloatImage]
_KLTFreeFloatImage.__doc__ = \
"""void _KLTFreeFloatImage(_KLT_FloatImage p1)
../klt_util.h:19"""
_KLTPrintSubFloatImage = _libraries['klt_bin']._KLTPrintSubFloatImage
_KLTPrintSubFloatImage.restype = None
_KLTPrintSubFloatImage.argtypes = [_KLT_FloatImage, c_int, c_int, c_int, c_int]
_KLTPrintSubFloatImage.__doc__ = \
"""void _KLTPrintSubFloatImage(_KLT_FloatImage floatimg, int x0, int y0, int width, int height)
../klt_util.h:24"""
_KLTWriteFloatImageToPGM = _libraries['klt_bin']._KLTWriteFloatImageToPGM
_KLTWriteFloatImageToPGM.restype = None
_KLTWriteFloatImageToPGM.argtypes = [_KLT_FloatImage, STRING]
_KLTWriteFloatImageToPGM.__doc__ = \
"""void _KLTWriteFloatImageToPGM(_KLT_FloatImage img, char * filename)
../klt_util.h:28"""
_KLTWriteAbsFloatImageToPGM = _libraries['klt_bin']._KLTWriteAbsFloatImageToPGM
_KLTWriteAbsFloatImageToPGM.restype = None
_KLTWriteAbsFloatImageToPGM.argtypes = [_KLT_FloatImage, STRING, c_float]
_KLTWriteAbsFloatImageToPGM.__doc__ = \
"""void _KLTWriteAbsFloatImageToPGM(_KLT_FloatImage img, char * filename, float scale)
../klt_util.h:33"""
__all__ = ['KLTCountRemainingFeatures', 'KLTFreeTrackingContext',
           '_KLTWriteAbsFloatImageToPGM', 'KLTExtractFeatureList',
           'KLT_FeatureRec', 'KLT_FeatureListRec',
           'KLTWriteFeatureList', 'KLT_TrackingContext',
           '_KLTComputeSmoothSigma', 'KLTWriteFeatureHistory',
           'KLTSetVerbosity', 'KLTTrackFeatures',
           'KLT_FeatureHistory', 'KLT_PixelType',
           'KLT_FeatureTableRec', 'KLTWriteFeatureTable',
           'KLT_FeatureHistoryRec', 'KLTReadFeatureTable',
           '_KLTWriteFloatImageToPGM', 'KLTCreateFeatureTable',
           '_KLT_FloatImage', 'KLTFreeFeatureHistory',
           'KLTStoreFeatureList', 'KLTPrintTrackingContext',
           'KLTReplaceLostFeatures', 'KLTChangeTCPyramid',
           'KLTReadFeatureHistory', 'KLTCreateFeatureHistory',
           'KLT_FeatureList', 'KLTUpdateTCBorder',
           '_KLTCreateFloatImage', 'KLTFreeFeatureList',
           'KLTSelectGoodFeatures', 'KLT_Feature',
           'KLTCreateFeatureList', 'KLTFreeFeatureTable',
           'KLTReadFeatureList', 'KLT_locType',
           'KLTCreateTrackingContext', 'KLTExtractFeatureHistory',
           'KLTStopSequentialMode', '_KLT_FloatImageRec',
           'KLTWriteFeatureListToPPM', '_KLTPrintSubFloatImage',
           '_KLTFreeFloatImage', 'KLT_FeatureTable',
           'KLTStoreFeatureHistory', 'KLT_TrackingContextRec']
