/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;

class TabbedLine {
    JLDataView[] dv;
    DataList[] dl;
    int anno;
    int sIndex;
    int precision = 0;
    String noValueString = "*";

    TabbedLine(int nb) {
        this.dv = new JLDataView[nb];
        this.dl = new DataList[nb];
    }

    void setPrecision(int milliseconds) {
        this.precision = milliseconds;
    }

    void setNoValueString(String noValueString) {
        this.noValueString = noValueString;
    }

    void add(int id, JLDataView v) {
        this.dv[id] = v;
        this.dl[id] = v.getData();
    }

    double getMinTime() {
        double r = Double.MAX_VALUE;
        int i = 0;
        while (i < this.dl.length) {
            if (this.dl[i] != null && this.dl[i].x < r) {
                r = this.dl[i].x;
            }
            ++i;
        }
        return r;
    }

    String getFirstLine(int annotation) {
        StringBuffer ret = new StringBuffer();
        this.anno = annotation;
        if (annotation == 1) {
            ret.append("Time (s)\t");
        } else {
            ret.append("Index\t");
        }
        int i = 0;
        while (i < this.dv.length) {
            ret.append(String.valueOf(this.dv[i].getName()) + "\t");
            ++i;
        }
        ret.append("\n");
        return ret.toString();
    }

    String getNextLine() {
        double t0 = this.getMinTime();
        if (t0 == Double.MAX_VALUE) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        if (this.anno == 1) {
            long t = (long)t0;
            long ts = t / 1000L;
            long ms = t % 1000L;
            if (ms == 0L) {
                ret.append(String.valueOf(ts) + "\t");
            } else if (ms < 10L) {
                ret.append(String.valueOf(ts) + ".00" + ms + "\t");
            } else if (ms < 100L) {
                ret.append(String.valueOf(ts) + ".0" + ms + "\t");
            } else {
                ret.append(String.valueOf(ts) + "." + ms + "\t");
            }
        } else {
            ret.append(String.valueOf(Double.toString(t0)) + "\t");
        }
        int i = 0;
        while (i < this.dl.length) {
            if (this.dl[i] != null) {
                if (this.dl[i].x >= t0 - (double)this.precision && this.dl[i].x <= t0 + (double)this.precision) {
                    ret.append(String.valueOf(Double.toString(this.dl[i].y)) + "\t");
                    this.dl[i] = this.dl[i].next;
                } else {
                    ret.append(String.valueOf(this.noValueString) + "\t");
                }
            } else {
                ret.append(String.valueOf(this.noValueString) + "\t");
            }
            ++i;
        }
        ret.append("\n");
        return ret.toString();
    }

    String[] getFirstFields(int annotation, boolean showIndex) {
        this.anno = annotation;
        this.sIndex = showIndex ? 1 : 0;
        String[] ret = new String[this.dv.length + this.sIndex];
        if (this.sIndex > 0) {
            ret[0] = annotation == 1 ? "Time (s)" : "Index";
        }
        int i = 0;
        while (i < this.dv.length) {
            ret[i + this.sIndex] = this.dv[i].getName();
            ++i;
        }
        return ret;
    }

    String[] getNextFields() {
        double t0 = this.getMinTime();
        if (t0 == Double.MAX_VALUE) {
            return null;
        }
        String[] ret = new String[this.dv.length + this.sIndex];
        if (this.sIndex > 0) {
            ret[0] = this.anno == 1 ? JLAxis.formatTimeValue(t0) : Double.toString(t0);
        }
        int i = 0;
        while (i < this.dl.length) {
            if (this.dl[i] != null) {
                if (this.dl[i].x >= t0 - (double)this.precision && this.dl[i].x <= t0 + (double)this.precision) {
                    ret[i + this.sIndex] = this.dv[i].formatValue(this.dl[i].y);
                    this.dl[i] = this.dl[i].next;
                } else {
                    ret[i + this.sIndex] = "";
                }
            } else {
                ret[i + this.sIndex] = "";
            }
            ++i;
        }
        return ret;
    }
}

