/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.util.Vector;

public class OFormat {
    public static String color(Color c) {
        return String.valueOf(c.getRed()) + "," + c.getGreen() + "," + c.getBlue();
    }

    public static String font(Font f) {
        return String.valueOf(f.getFamily()) + "," + f.getStyle() + "," + f.getSize();
    }

    public static String getName(String s) {
        if (s.equalsIgnoreCase("null")) {
            return null;
        }
        return s;
    }

    public static boolean getBoolean(String s) {
        return s.equalsIgnoreCase("true");
    }

    public static int getInt(String s) {
        int ret = 0;
        try {
            ret = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            System.out.println("Failed to parse '" + s + "' as integer");
        }
        return ret;
    }

    public static double getDouble(String s) {
        double ret = 0.0;
        try {
            ret = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            System.out.println("Failed to parse '" + s + "' as double");
        }
        return ret;
    }

    public static Color getColor(Vector v) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (v.size() != 3) {
            System.out.println("Invalid color parameters.");
            return new Color(0, 0, 0);
        }
        try {
            r = OFormat.saturate(Integer.parseInt(v.get(0).toString()));
            g = OFormat.saturate(Integer.parseInt(v.get(1).toString()));
            b = OFormat.saturate(Integer.parseInt(v.get(2).toString()));
        }
        catch (Exception e) {
            System.out.println("Invalid color parameters.");
        }
        return new Color(r, g, b);
    }

    private static int saturate(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 255) {
            return 255;
        }
        return value;
    }

    public static Font getFont(Vector v) {
        String f = "Dialog";
        int style = 0;
        int size = 11;
        if (v.size() != 3) {
            System.out.println("Invalid font parameters.");
            return new Font(f, style, size);
        }
        try {
            f = v.get(0).toString();
            style = Integer.parseInt(v.get(1).toString());
            size = Integer.parseInt(v.get(2).toString());
        }
        catch (Exception e) {
            System.out.println("Invalid font parameters.");
        }
        return new Font(f, style, size);
    }

    public static Point getPoint(Vector v) {
        int x = 0;
        int y = 0;
        if (v.size() != 2) {
            System.out.println("Invalid point parameter.");
            return new Point(x, y);
        }
        try {
            x = Integer.parseInt(v.get(0).toString());
            y = Integer.parseInt(v.get(1).toString());
        }
        catch (Exception e) {
            System.out.println("Invalid point parameter.");
        }
        return new Point(x, y);
    }
}

