/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.internal;

import fable.framework.toolbox.SWTUtils;
import fable.imageviewer.rcp.Activator;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CustomCoordinatesDialog
extends Dialog {
    private static final int DEFAULT_TEXT_WIDTH = 30;
    private double x0 = 0.0;
    private double y0 = 0.0;
    private double pixelWidth = 1.0;
    private double pixelHeight = 1.0;
    private String xName = "x";
    private String yName = "y";
    boolean success = false;
    Text x0Text;
    Text y0Text;
    Text pixelWidthTexy;
    Text pixelHeightText;
    Text xNameText;
    Text yNameText;

    public CustomCoordinatesDialog(Shell parent, double x0, double y0, double pixelWidth, double pixelHeight, String xName, String yName) {
        this(parent, x0, y0, pixelWidth, pixelHeight, xName, yName, 67680);
        this.x0 = x0;
        this.y0 = y0;
        this.pixelWidth = pixelWidth;
        this.pixelHeight = pixelHeight;
        this.xName = xName;
        this.yName = yName;
    }

    public CustomCoordinatesDialog(Shell parent) {
        super(parent, 67680);
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        try {
            this.x0 = Double.parseDouble(prefs.getString("coordinatesX0Preference"));
            this.y0 = Double.parseDouble(prefs.getString("coordinatesY0Preference"));
            this.pixelWidth = Double.parseDouble(prefs.getString("coordinatesPixelWidthPreference"));
            this.pixelHeight = Double.parseDouble(prefs.getString("coordinatesPixelHeightPreference"));
            this.xName = prefs.getString("coordinatesXNamePreference");
            this.yName = prefs.getString("coordinatesYNamePreference");
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public CustomCoordinatesDialog(Shell parent, double x0, double y0, double pixelWidth, double pixelHeight, String xName, String yName, int style) {
        super(parent, style);
    }

    public boolean open() {
        Shell shell = new Shell(this.getParent(), this.getStyle() | 0x10);
        shell.setText("Set Custom Coordinates");
        Image image = null;
        try {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
        }
        catch (Exception exception) {}
        if (image != null) {
            shell.setImage(image);
        }
        this.createContents(shell);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.success;
    }

    private void createContents(final Shell shell) {
        FormLayout form = new FormLayout();
        form.marginHeight = 8;
        form.marginWidth = 8;
        shell.setLayout((Layout)form);
        Group box = new Group((Composite)shell, 2048);
        box.setText("Custom Coordinates");
        GridLayout grid = new GridLayout();
        grid.numColumns = 1;
        box.setLayout((Layout)grid);
        Text text = new Text((Composite)box, 2);
        text.setEditable(false);
        String info = "The displayed coordinates (x1, y1) are defined via the equations:\n\tx1 = pixelWidth * (x - x0)\n\ty2 = pixelWidth * (y - y0)\nwhere (x, y) are the image coordinates with origin at top left.\nThe coordinates can be named other than x and y.";
        text.setText(info);
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        Composite composite = new Composite((Composite)box, 0);
        gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText("x0");
        this.setGridData((Control)label);
        final Text x0Text = new Text(composite, 133124);
        x0Text.setText(String.valueOf(this.x0));
        this.setGridData((Control)x0Text);
        label = new Label(composite, 0);
        label.setText("y0");
        this.setGridData((Control)label);
        final Text y0Text = new Text(composite, 133124);
        y0Text.setText(String.valueOf(this.y0));
        this.setGridData((Control)y0Text);
        label = new Label(composite, 0);
        label.setText("pixelWidth");
        this.setGridData((Control)label);
        final Text pixelWidthText = new Text(composite, 133124);
        pixelWidthText.setText(String.valueOf(this.pixelWidth));
        this.setGridData((Control)pixelWidthText);
        label = new Label(composite, 0);
        label.setText("pixelHeight");
        this.setGridData((Control)label);
        final Text pixelHeightText = new Text(composite, 133124);
        pixelHeightText.setText(String.valueOf(this.pixelHeight));
        this.setGridData((Control)pixelHeightText);
        label = new Label(composite, 0);
        label.setText("xName");
        this.setGridData((Control)label);
        final Text xNameText = new Text(composite, 133124);
        xNameText.setText(this.xName);
        this.setGridData((Control)xNameText);
        label = new Label(composite, 0);
        label.setText("yName");
        this.setGridData((Control)label);
        final Text yNameText = new Text(composite, 133124);
        yNameText.setText(this.yName);
        this.setGridData((Control)yNameText);
        Button cancelButton = new Button((Composite)shell, 8);
        FormData cancelData = new FormData();
        cancelData.top = new FormAttachment((Control)box, 8);
        cancelData.right = new FormAttachment(100, -4);
        cancelButton.setLayoutData((Object)cancelData);
        cancelButton.setText("&Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CustomCoordinatesDialog.this.success = false;
                shell.close();
            }
        });
        Button okButton = new Button((Composite)shell, 8);
        FormData okData = new FormData();
        okData.top = new FormAttachment((Control)box, 8);
        okData.right = new FormAttachment((Control)cancelButton, -8);
        okButton.setLayoutData((Object)okData);
        okButton.setText("&OK");
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String processing = "xName";
                try {
                    CustomCoordinatesDialog.this.xName = xNameText.getText();
                    processing = "yName";
                    CustomCoordinatesDialog.this.yName = yNameText.getText();
                    processing = "x0";
                    CustomCoordinatesDialog.this.x0 = Double.parseDouble(x0Text.getText());
                    processing = "y0";
                    CustomCoordinatesDialog.this.y0 = Double.parseDouble(y0Text.getText());
                    processing = "pixelWidth";
                    CustomCoordinatesDialog.this.pixelWidth = Double.parseDouble(pixelWidthText.getText());
                    processing = "pixelHeight";
                    CustomCoordinatesDialog.this.pixelHeight = Double.parseDouble(pixelHeightText.getText());
                    CustomCoordinatesDialog.this.success = true;
                    shell.close();
                }
                catch (NumberFormatException numberFormatException) {
                    SWTUtils.errMsg((Shell)shell, (String)("Error processing " + processing));
                }
            }
        });
        shell.setDefaultButton(okButton);
    }

    private GridData setGridData(Control control) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        if (control instanceof Text) {
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 30;
        }
        control.setLayoutData((Object)gd);
        return gd;
    }

    public double getX0() {
        return this.x0;
    }

    public double getY0() {
        return this.y0;
    }

    public double getPixelWidth() {
        return this.pixelWidth;
    }

    public double getPixelHeight() {
        return this.pixelHeight;
    }

    public String getXName() {
        return this.xName;
    }

    public String getYName() {
        return this.yName;
    }
}

