/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Enumeration;
import org.jmol.shape.Text;
import org.jmol.shape.TextShape;
import org.jmol.util.Logger;

public class Echo
extends TextShape {
    private static final String FONTFACE = "Serif";
    private static final int FONTSIZE = 20;
    private static final short COLOR = 10;

    public void initShape() {
        super.initShape();
        this.setProperty("target", "top", null);
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        String string2;
        if (Logger.debugging) {
            Logger.debug("Echo.setProperty(" + string + "," + object + ")");
        }
        if ("script" == string) {
            if (this.currentText != null) {
                this.currentText.setScript((String)object);
            }
            return;
        }
        if ("target" == string && (string2 = ((String)object).intern().toLowerCase()) != "none" && string2 != "all") {
            Text text = (Text)this.texts.get(string2);
            if (text == null) {
                int n = 0;
                int n2 = 1;
                if ("top" == string2) {
                    n = 1;
                    n2 = 2;
                } else if ("middle" == string2) {
                    n = 3;
                    n2 = 2;
                } else if ("bottom" == string2) {
                    n = 2;
                }
                text = new Text(this.viewer, this.g3d, this.g3d.getFont3D(FONTFACE, 20), string2, 10, n, n2);
                text.setAdjustForWindow(true);
                this.texts.put(string2, text);
                if (this.currentFont != null) {
                    text.setFont(this.currentFont);
                }
                if (this.currentColor != null) {
                    text.setColix(this.currentColor);
                }
                if (this.currentBgColor != null) {
                    text.setBgColix(this.currentBgColor);
                }
                if (this.currentTranslucentLevel != 0.0f) {
                    text.setTranslucent(this.currentTranslucentLevel, false);
                }
                if (this.currentBgTranslucentLevel != 0.0f) {
                    text.setTranslucent(this.currentBgTranslucentLevel, true);
                }
            }
            this.currentText = text;
        }
        super.setProperty(string, object, null);
    }

    public void setVisibilityFlags(BitSet bitSet) {
        Enumeration enumeration = this.texts.elements();
        while (enumeration.hasMoreElements()) {
            Text text = (Text)enumeration.nextElement();
            text.setVisibility(text.modelIndex < 0 || bitSet.get(text.modelIndex));
        }
    }

    public String getShapeState() {
        StringBuffer stringBuffer = new StringBuffer("\n  set echo off;\n");
        String string = "";
        Enumeration enumeration = this.texts.elements();
        while (enumeration.hasMoreElements()) {
            Text text = (Text)enumeration.nextElement();
            stringBuffer.append(text.getState(true));
            String string2 = text.getState(false);
            if (string2.equals(string)) continue;
            string = string2;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public boolean checkObjectClicked(int n, int n2, int n3) {
        Enumeration enumeration = this.texts.elements();
        while (enumeration.hasMoreElements()) {
            Text text = (Text)enumeration.nextElement();
            if (!text.checkObjectClicked(n, n2)) continue;
            String string = text.getScript();
            if (string != null) {
                this.viewer.evalStringQuiet(string);
            }
            return true;
        }
        return false;
    }

    public boolean checkObjectHovered(int n, int n2) {
        Enumeration enumeration = this.texts.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Text text = (Text)enumeration.nextElement();
            String string = text.getScript();
            if (string == null) continue;
            bl = true;
            if (!text.checkObjectClicked(n, n2)) continue;
            this.viewer.setCursor(1);
            return true;
        }
        if (bl) {
            this.viewer.setCursor(0);
        }
        return false;
    }
}

