/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.rcp.texteditor.actions;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public final class TextEditorActionBarAdvisor
extends ActionBarAdvisor {
    public TextEditorActionBarAdvisor(IActionBarConfigurer actionBarConfigurer) {
        super(actionBarConfigurer);
    }

    protected void fillCoolBar(ICoolBarManager cbManager) {
        cbManager.add((IContributionItem)new GroupMarker("group.file"));
        ToolBarManager fileToolBar = new ToolBarManager(cbManager.getStyle());
        fileToolBar.add((IContributionItem)new Separator("new.group"));
        fileToolBar.add((IContributionItem)new GroupMarker("open.ext"));
        fileToolBar.add((IContributionItem)new GroupMarker("save.group"));
        fileToolBar.add(this.getAction(ActionFactory.SAVE.getId()));
        fileToolBar.add((IContributionItem)new Separator("additions"));
        cbManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)fileToolBar, "org.eclipse.ui.workbench.file"));
        cbManager.add((IContributionItem)new GroupMarker("additions"));
        cbManager.add((IContributionItem)new GroupMarker("group.editor"));
    }

    protected void fillMenuBar(IMenuManager menubar) {
        menubar.add((IContributionItem)this.createFileMenu());
        menubar.add((IContributionItem)this.createEditMenu());
        menubar.add((IContributionItem)new GroupMarker("additions"));
        menubar.add((IContributionItem)this.createHelpMenu());
    }

    private MenuManager createFileMenu() {
        MenuManager menu = new MenuManager("&File", "file");
        menu.add((IContributionItem)new GroupMarker("fileStart"));
        menu.add((IContributionItem)new GroupMarker("new.ext"));
        menu.add(this.getAction(ActionFactory.CLOSE.getId()));
        menu.add(this.getAction(ActionFactory.CLOSE_ALL.getId()));
        menu.add((IContributionItem)new GroupMarker("close.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(ActionFactory.SAVE.getId()));
        menu.add(this.getAction(ActionFactory.SAVE_AS.getId()));
        menu.add(this.getAction(ActionFactory.SAVE_ALL.getId()));
        menu.add(this.getAction(ActionFactory.REVERT.getId()));
        menu.add(ContributionItemFactory.REOPEN_EDITORS.create(this.getActionBarConfigurer().getWindowConfigurer().getWindow()));
        menu.add((IContributionItem)new GroupMarker("mru"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(ActionFactory.QUIT.getId()));
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        return menu;
    }

    private MenuManager createEditMenu() {
        MenuManager menu = new MenuManager("&Edit", "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add(this.getAction(ActionFactory.UNDO.getId()));
        menu.add(this.getAction(ActionFactory.REDO.getId()));
        menu.add((IContributionItem)new GroupMarker("undo.ext"));
        menu.add(this.getAction(ActionFactory.CUT.getId()));
        menu.add(this.getAction(ActionFactory.COPY.getId()));
        menu.add(this.getAction(ActionFactory.PASTE.getId()));
        menu.add((IContributionItem)new GroupMarker("cut.ext"));
        menu.add(this.getAction(ActionFactory.SELECT_ALL.getId()));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(ActionFactory.FIND.getId()));
        menu.add((IContributionItem)new GroupMarker("find.ext"));
        menu.add((IContributionItem)new GroupMarker("add.ext"));
        menu.add((IContributionItem)new GroupMarker("editEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        return menu;
    }

    private MenuManager createHelpMenu() {
        MenuManager menu = new MenuManager("&Help", "help");
        menu.add((IContributionItem)new GroupMarker("helpStart"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new GroupMarker("helpEnd"));
        menu.add((IContributionItem)new Separator("about"));
        menu.add(this.getAction(ActionFactory.ABOUT.getId()));
        return menu;
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.registerAsGlobal((IAction)ActionFactory.SAVE.create(window));
        this.registerAsGlobal((IAction)ActionFactory.SAVE_AS.create(window));
        this.registerAsGlobal((IAction)ActionFactory.ABOUT.create(window));
        this.registerAsGlobal((IAction)ActionFactory.SAVE_ALL.create(window));
        this.registerAsGlobal((IAction)ActionFactory.UNDO.create(window));
        this.registerAsGlobal((IAction)ActionFactory.REDO.create(window));
        this.registerAsGlobal((IAction)ActionFactory.CUT.create(window));
        this.registerAsGlobal((IAction)ActionFactory.COPY.create(window));
        this.registerAsGlobal((IAction)ActionFactory.PASTE.create(window));
        this.registerAsGlobal((IAction)ActionFactory.SELECT_ALL.create(window));
        this.registerAsGlobal((IAction)ActionFactory.FIND.create(window));
        this.registerAsGlobal((IAction)ActionFactory.CLOSE.create(window));
        this.registerAsGlobal((IAction)ActionFactory.CLOSE_ALL.create(window));
        this.registerAsGlobal((IAction)ActionFactory.CLOSE_ALL_SAVED.create(window));
        this.registerAsGlobal((IAction)ActionFactory.REVERT.create(window));
        this.registerAsGlobal((IAction)ActionFactory.QUIT.create(window));
    }

    private void registerAsGlobal(IAction action) {
        this.getActionBarConfigurer().registerGlobalAction(action);
        this.register(action);
    }
}

