/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.IArchiveReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;

public abstract class SiteContentProvider
implements ISiteContentProvider {
    private URL base;
    private ISite site;

    public SiteContentProvider(URL url) {
        this.base = url;
    }

    public URL getURL() {
        return this.base;
    }

    private URL getArchiveReference1(String archiveID) throws CoreException {
        try {
            return new URL(this.getURL(), archiveID);
        }
        catch (MalformedURLException e) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteContentProvider_ErrorCreatingURLForArchiveID, (Object[])new String[]{archiveID, this.getURL().toExternalForm()}), e);
        }
    }

    public ISite getSite() {
        return this.site;
    }

    public void setSite(ISite site) {
        this.site = site;
    }

    public URL getArchiveReference(String archiveId) throws CoreException {
        URL contentURL = null;
        contentURL = this.getArchiveURLfor(archiveId);
        if (contentURL == null) {
            return this.getArchiveReference1(archiveId);
        }
        return contentURL;
    }

    private URL getArchiveURLfor(String archiveId) {
        URL result = null;
        boolean found = false;
        IArchiveReference[] siteArchives = this.getSite().getArchives();
        if (siteArchives.length > 0) {
            int i = 0;
            while (i < siteArchives.length && !found) {
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
                    UpdateCore.debug("GetArchiveURL for:" + archiveId + " compare to " + siteArchives[i].getPath());
                }
                if (archiveId.trim().equalsIgnoreCase(siteArchives[i].getPath())) {
                    result = siteArchives[i].getURL();
                    found = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }
}

