/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.util.DefaultLogger;
import org.jmol.util.LoggerInterface;

public final class Logger {
    private static LoggerInterface _logger = new DefaultLogger();
    public static final int LEVEL_DEBUG = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARN = 2;
    public static final int LEVEL_ERROR = 3;
    public static final int LEVEL_FATAL = 4;
    public static final int NB_LEVELS = 5;
    private static final boolean[] _activeLevels = new boolean[5];
    private static boolean _logLevel = false;
    public static boolean debugging;

    private static boolean getProperty(String string, boolean bl) {
        try {
            String string2 = System.getProperty("jmol.logger." + string);
            if (string2 != null) {
                return Boolean.TRUE.equals(Boolean.valueOf(string2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static void setLogger(LoggerInterface loggerInterface) {
        _logger = loggerInterface;
        debugging = Logger.isActiveLevel(0);
    }

    public static boolean isActiveLevel(int n) {
        if (_logger == null) {
            return false;
        }
        if (n >= 0 && n < _activeLevels.length) {
            return _activeLevels[n];
        }
        return false;
    }

    public static void setActiveLevel(int n, boolean bl) {
        if (n >= 0 && n < _activeLevels.length) {
            Logger._activeLevels[n] = bl;
            if (n == 0) {
                debugging = _logger != null && bl;
            }
        }
    }

    public static void setLogLevel(int n) {
        int n2 = 5;
        while (--n2 >= 0) {
            Logger.setActiveLevel(n2, 5 - n2 <= n);
        }
    }

    public static String getLevel(int n) {
        switch (n) {
            case 0: {
                return "DEBUG";
            }
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARN";
            }
            case 3: {
                return "ERROR";
            }
            case 4: {
                return "FATAL";
            }
        }
        return "????";
    }

    public static boolean logLevel() {
        return _logLevel;
    }

    public static void logLevel(boolean bl) {
        _logLevel = bl;
    }

    public static void debug(String string) {
        if (!debugging) {
            return;
        }
        try {
            _logger.debug(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void info(String string) {
        try {
            if (Logger.isActiveLevel(1)) {
                _logger.info(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void warn(String string) {
        try {
            if (Logger.isActiveLevel(2)) {
                _logger.warn(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void warn(String string, Throwable throwable) {
        try {
            if (Logger.isActiveLevel(2)) {
                _logger.warn(string, throwable);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public static void error(String string) {
        try {
            if (Logger.isActiveLevel(3)) {
                _logger.error(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void error(String string, Throwable throwable) {
        try {
            if (Logger.isActiveLevel(3)) {
                _logger.error(string, throwable);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public static void fatal(String string) {
        try {
            if (Logger.isActiveLevel(4)) {
                _logger.fatal(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fatal(String string, Throwable throwable) {
        try {
            if (Logger.isActiveLevel(4)) {
                _logger.fatal(string, throwable);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    static {
        Logger._activeLevels[0] = Logger.getProperty("debug", false);
        Logger._activeLevels[1] = Logger.getProperty("info", true);
        Logger._activeLevels[2] = Logger.getProperty("warn", true);
        Logger._activeLevels[3] = Logger.getProperty("error", true);
        Logger._activeLevels[4] = Logger.getProperty("fatal", true);
        _logLevel = Logger.getProperty("logLevel", false);
        debugging = _logger != null && _activeLevels[0];
    }
}

