/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.imageprint.FableImagePrinter;
import fable.framework.imageprint.ImagePrintPreviewDialog;
import fable.framework.imageprint.ImagePrintSetupDialog;
import fable.framework.imageprint.ImagePrintUtils;
import fable.framework.imageprint.PrintSettings;
import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.SWTUtils;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class LineView
extends ViewPart {
    public static final String ID = "fable.imageviewer.views.LineView";
    private JLDataView dataView;
    private JLChart chart;
    public static LineView view;
    private String title = "Zoom Line Plot";
    private Composite swtAwtComponent;
    public SampleController controller = SampleController.getController();
    private Frame chartFrame;
    private IJLChartActionListener chartActionListener;
    private JApplet chartContainer;
    private Action printSetupAction;
    private Action printPreviewAction;
    private Action printAction;
    private Action copyAction;
    Logger logger;
    Composite parent;

    public void createPartControl(Composite parent) {
        view = this;
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout());
        this.createChartFrame(parent);
        this.createChart();
        this.logger = FableLogger.getLogger(LineView.class);
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalMenu(bars.getMenuManager());
    }

    private void fillLocalMenu(IMenuManager manager) {
        this.printSetupAction = new Action("Print Setup"){

            public void run() {
                Image image = LineView.this.getChartImage();
                if (image == null) {
                    return;
                }
                ImagePrintSetupDialog dialog = new ImagePrintSetupDialog(LineView.this.parent.getDisplay().getActiveShell(), image, FableImagePrinter.settings);
                PrintSettings settings = dialog.open();
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
                if (settings != null) {
                    FableImagePrinter.settings = settings;
                }
            }
        };
        this.printPreviewAction = new Action("Print Preview"){

            public void run() {
                Image image = LineView.this.getChartImage();
                if (image == null) {
                    return;
                }
                ImagePrintPreviewDialog dialog = new ImagePrintPreviewDialog(LineView.this.parent.getDisplay().getActiveShell(), image, FableImagePrinter.settings);
                PrintSettings settings = dialog.open();
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
                if (settings != null) {
                    FableImagePrinter.settings = settings;
                }
            }
        };
        this.printAction = new Action("Print"){

            public void run() {
                Image image = LineView.this.getChartImage();
                if (image == null) {
                    return;
                }
                ImagePrintUtils.dialogPrintImage((Shell)LineView.this.parent.getDisplay().getActiveShell(), (Image)image, (Point)LineView.this.parent.getDisplay().getActiveShell().getDisplay().getDPI(), (PrintSettings)FableImagePrinter.settings);
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        };
        this.copyAction = new Action("Copy"){

            public void run() {
                Image image = LineView.this.getChartImage();
                if (image == null) {
                    return;
                }
                ImageTransfer transfer = ImageTransfer.getInstance();
                Clipboard clipboard = new Clipboard(LineView.this.parent.getDisplay());
                clipboard.setContents(new Object[]{image.getImageData()}, new Transfer[]{transfer});
                clipboard.dispose();
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        };
        MenuManager subMenuManager = new MenuManager("Print");
        manager.add((IContributionItem)subMenuManager);
        subMenuManager.add((IAction)this.printSetupAction);
        subMenuManager.add((IAction)this.printPreviewAction);
        subMenuManager.add((IAction)this.printAction);
        subMenuManager = new MenuManager("Edit");
        manager.add((IContributionItem)subMenuManager);
        subMenuManager.add((IAction)this.copyAction);
    }

    public Image getChartImage() {
        if (this.chart == null) {
            return null;
        }
        int w = this.chart.getSize().width;
        int h = this.chart.getSize().height;
        BufferedImage img = new BufferedImage(w, h, 1);
        if (img == null) {
            return null;
        }
        Color oldBackground = this.chart.getBackground();
        this.chart.setBackground(Color.WHITE);
        this.chart.paint(img.getGraphics());
        this.chart.setBackground(oldBackground);
        ImageData data = SWTUtils.convertToSWT((BufferedImage)img);
        if (data == null) {
            return null;
        }
        return new Image((Device)this.parent.getDisplay(), data);
    }

    public void setFocus() {
    }

    private void createChartFrame(Composite parent) {
        this.swtAwtComponent = new Composite(parent, 0x1040000);
        this.swtAwtComponent.setLayout((Layout)new GridLayout());
        this.swtAwtComponent.setLayoutData((Object)new GridData(1808));
        this.chartFrame = SWT_AWT.new_Frame((Composite)this.swtAwtComponent);
        this.chartContainer = new JApplet();
        this.chartFrame.add(this.chartContainer);
    }

    public void createChart() {
        this.chart = new JLChart();
        this.chart.setHeader(this.title);
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.getY1Axis().setName("Intensity");
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getXAxis().setAutoScale(true);
        this.chart.getXAxis().setName("pixel");
        this.chart.getXAxis().setGridVisible(true);
        this.chart.getXAxis().setSubGridVisible(true);
        this.chart.getXAxis().setAnnotation(2);
        this.chart.getY1Axis().setGridVisible(true);
        this.chart.getY1Axis().setSubGridVisible(true);
        this.chart.removeMenuItem(4);
        this.chart.addUserAction("Print Setup");
        this.chart.addUserAction("Print Preview");
        this.chart.addUserAction("Print");
        this.chart.addUserAction("Copy");
        this.chartActionListener = new IJLChartActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(final JLChartActionEvent evt) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (evt.getName().equals("Print Setup")) {
                            LineView.this.printSetupAction.run();
                        } else if (evt.getName().equals("Print Preview")) {
                            LineView.this.printPreviewAction.run();
                        } else if (evt.getName().equals("Print")) {
                            LineView.this.printAction.run();
                        } else if (evt.getName().equals("Copy")) {
                            LineView.this.copyAction.run();
                        }
                    }
                });
            }

            public boolean getActionState(JLChartActionEvent evt) {
                return false;
            }
        };
        this.chart.addJLChartActionListener(this.chartActionListener);
        this.chartContainer.add((Component)this.chart);
        this.dataView = new JLDataView();
        this.dataView.setName("Intensity");
        this.chart.getY1Axis().addDataView(this.dataView);
    }

    public void setData(String title, String xTitle, boolean xInverted, float[] pixel, String yTitle, float[] intensity) {
        double[] x = new double[pixel.length];
        double[] y = new double[pixel.length];
        int i = 0;
        while (i < pixel.length) {
            x[i] = pixel[i];
            y[i] = xInverted ? (double)intensity[pixel.length - 1 - i] : (double)intensity[i];
            ++i;
        }
        this.dataView.setData(x, y);
        this.dataView.setXDataSorted(false);
        this.chart.setHeader(title);
        this.chart.getXAxis().setName(xTitle);
        this.chart.getXAxis().setInverted(xInverted);
        this.chart.getY1Axis().setName(yTitle);
        Dimension chartSize = this.chartContainer.getSize();
        this.chart.setSize(chartSize);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LineView.this.chartContainer.repaint();
            }
        });
    }

    public void dispose() {
        if (this.chart != null && this.chartActionListener != null) {
            this.chart.removeJLChartActionListener(this.chartActionListener);
        }
        super.dispose();
    }
}

