/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ImageViewType;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.model.ImageModel;
import fable.imageviewer.views.ImageView;
import fable.imageviewer.views.ImageViewControls;
import fable.imageviewer.views.LineView;
import fable.imageviewer.views.ProfileView;
import fable.imageviewer.views.ReliefView;
import fable.imageviewer.views.RockingCurveView;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ImageViewImage
implements IImagesVarKeys {
    private static final boolean debug = false;
    private static final boolean debug1 = false;
    private static final float ZOOMFACTOR_LARGE = 0.5f;
    ImageView iv = null;
    private ImageViewControls controls;
    private Canvas imageCanvas;
    private GC imageCanvasGC;
    private Image image = null;
    private ImageData imageData;
    private Rectangle imageRect = new Rectangle(0, 0, 0, 0);
    private Rectangle origRect = new Rectangle(0, 0, 0, 0);
    private Rectangle orientedOrigRect = new Rectangle(0, 0, 0, 0);
    private Rectangle orientedRect = new Rectangle(0, 0, 0, 0);
    double xScale;
    double yScale;
    private Boolean selectingOn = false;
    private int canvasWidth;
    private int canvasHeight;
    private Boolean selectOn = false;
    private boolean imageChanged = true;
    private Boolean newSelection = true;
    private int xSelectionStart;
    private int ySelectionStart;
    private Rectangle selectedArea = new Rectangle(0, 0, 0, 0);
    private Display display;
    private Logger logger = FableLogger.getLogger(this.getClass());
    private ImageView zoomAreaView;
    private LineView lineView;
    private ProfileView profileView;
    private ReliefView zoomReliefView;
    private RockingCurveView zoomRockingCurveView;

    public ImageViewImage(ImageView iv, ImageViewControls controls) {
        this.iv = iv;
        this.controls = controls;
        iv.setImage(this);
        controls.setImage(this);
    }

    public void initializeCanvas() {
        if (this.iv == null || this.controls == null) {
            return;
        }
        this.imageCanvas = this.controls.getImageCanvas();
        this.display = this.iv.getDisplay();
        this.imageCanvas.setBackground(this.display.getSystemColor(16));
        GridData gridData = new GridData(4, 4, true, true);
        this.imageCanvas.setLayoutData((Object)gridData);
        this.imageCanvasGC = new GC((Drawable)this.imageCanvas);
        Rectangle bounds = this.imageCanvas.getBounds();
        this.canvasWidth = bounds.width;
        this.canvasHeight = bounds.height;
        this.imageCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageViewImage.this.imageCanvasGC.dispose();
            }
        });
        this.imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                Rectangle bounds = ImageViewImage.this.imageCanvas.getBounds();
                event.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                if (ImageViewImage.this.image != null) {
                    if (ImageViewImage.this.canvasWidth != bounds.width || ImageViewImage.this.canvasHeight != bounds.height) {
                        double imageXScale = ImageViewImage.this.xScale;
                        double imageYScale = ImageViewImage.this.yScale;
                        ImageViewImage.this.loadImage(ImageViewImage.this.imageData);
                        ImageViewImage.this.drawImage();
                        imageXScale /= ImageViewImage.this.xScale;
                        imageYScale /= ImageViewImage.this.yScale;
                        ImageViewImage.this.showSelection();
                    } else {
                        GC gc = event.gc;
                        gc.drawImage(ImageViewImage.this.image, 0, 0);
                        ImageViewImage.this.showSelection();
                    }
                    ImageViewImage.this.showPeaks();
                    ImageViewImage.this.canvasWidth = bounds.width;
                    ImageViewImage.this.canvasHeight = bounds.height;
                }
            }
        });
        this.imageCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                if (ImageViewImage.this.image != null) {
                    ImageViewImage.this.showPixelAtCursor(event.x, event.y);
                    if (ImageViewImage.this.selectingOn.booleanValue()) {
                        int width = event.x - ImageViewImage.this.xSelectionStart;
                        int height = event.y - ImageViewImage.this.ySelectionStart;
                        ImageViewImage.this.imageCanvasGC.setForeground(ImageViewImage.this.display.getSystemColor(1));
                        ImageViewImage.this.imageCanvasGC.drawImage(ImageViewImage.this.image, 0, 0);
                        ZoomSelection zoomSelection = ImageViewImage.this.iv.getZoomSelection();
                        if (zoomSelection == ZoomSelection.AREA || zoomSelection == ZoomSelection.PROFILE || zoomSelection == ZoomSelection.RELIEF || zoomSelection == ZoomSelection.ROCKINGCURVE) {
                            Rectangle selectedRectangle = new Rectangle(ImageViewImage.this.xSelectionStart, ImageViewImage.this.ySelectionStart, width, height);
                            ImageViewImage.this.imageCanvasGC.setLineWidth(1);
                            ImageViewImage.this.imageCanvasGC.drawRectangle(selectedRectangle);
                        } else if (zoomSelection == ZoomSelection.LINE) {
                            ImageViewImage.this.imageCanvasGC.setXORMode(true);
                            ImageViewImage.this.imageCanvasGC.drawLine(ImageViewImage.this.xSelectionStart, ImageViewImage.this.ySelectionStart, event.x, event.y);
                            ImageViewImage.this.imageCanvasGC.setXORMode(false);
                        }
                    }
                }
            }
        });
        this.imageCanvas.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                ImageViewImage.this.controls.setStatusText("");
                if (ImageViewImage.this.selectingOn.booleanValue()) {
                    ImageViewImage.this.imageCanvasGC.drawImage(ImageViewImage.this.image, 0, 0);
                    ImageViewImage.this.selectingOn = false;
                }
            }
        });
        this.imageCanvas.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ev) {
                switch (ev.keyCode) {
                    case 27: {
                        if (!ImageViewImage.this.selectingOn.booleanValue()) break;
                        ImageViewImage.this.imageCanvasGC.drawImage(ImageViewImage.this.image, 0, 0);
                        ImageViewImage.this.selectingOn = false;
                    }
                }
            }

            public void keyReleased(KeyEvent ev) {
            }
        });
        this.imageCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (ImageViewImage.this.selectingOn.booleanValue()) {
                    ImageViewImage.this.imageCanvasGC.drawImage(ImageViewImage.this.image, 0, 0);
                    ImageViewImage.this.selectingOn = false;
                }
            }

            public void mouseDown(MouseEvent ev) {
                if (ImageViewImage.this.image == null) {
                    return;
                }
                if (ev.button == 1) {
                    if ((ev.stateMask & 0x40000) != 0) {
                        ImageViewImage.this.selectingOn = false;
                        ImageViewImage.this.selectOn = false;
                        ImageViewImage.this.showZoom(ev, true);
                    } else if ((ev.stateMask & 0x20000) != 0) {
                        ImageViewImage.this.selectingOn = false;
                        ImageViewImage.this.selectOn = false;
                        ImageViewImage.this.showZoom(ev, false);
                    } else {
                        ImageViewImage.this.selectingOn = true;
                        ImageViewImage.this.xSelectionStart = ev.x;
                        ImageViewImage.this.ySelectionStart = ev.y;
                    }
                }
            }

            public void mouseUp(MouseEvent ev) {
                if (ImageViewImage.this.image == null) {
                    return;
                }
                if (!ImageViewImage.this.selectingOn.booleanValue()) {
                    return;
                }
                if (ImageViewImage.this.xSelectionStart != ev.x || ImageViewImage.this.ySelectionStart != ev.y) {
                    ((ImageViewImage)ImageViewImage.this).selectedArea.x = ImageViewImage.this.xSelectionStart;
                    ((ImageViewImage)ImageViewImage.this).selectedArea.y = ImageViewImage.this.ySelectionStart;
                    ((ImageViewImage)ImageViewImage.this).selectedArea.width = ev.x - ((ImageViewImage)ImageViewImage.this).selectedArea.x;
                    ((ImageViewImage)ImageViewImage.this).selectedArea.height = ev.y - ((ImageViewImage)ImageViewImage.this).selectedArea.y;
                    ImageViewImage.this.imageCanvasGC.setForeground(ImageViewImage.this.display.getSystemColor(1));
                    ImageViewImage.this.imageCanvasGC.drawImage(ImageViewImage.this.image, 0, 0);
                    ImageViewImage.this.imageChanged = true;
                    ImageViewImage.this.newSelection = true;
                    ImageViewImage.this.showSelection();
                }
                ImageViewImage.this.selectingOn = false;
            }
        });
        this.createDropTarget();
    }

    public void dispose() {
        if (this.imageCanvas != null) {
            this.imageCanvas.dispose();
        }
        if (this.image != null) {
            this.image.dispose();
        }
    }

    public void calculateMainRectangles() {
        this.origRect = this.iv.getImageModel().getRect();
        this.orientedOrigRect.x = 0;
        this.orientedOrigRect.y = 0;
        switch (this.iv.getOrientation()) {
            default: {
                this.orientedRect.x = this.imageRect.x;
                this.orientedRect.y = this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 1: {
                this.orientedRect.x = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.y = this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 2: {
                this.orientedRect.x = this.imageRect.x;
                this.orientedRect.y = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 3: {
                this.orientedRect.x = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.y = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 6: {
                this.orientedRect.x = this.imageRect.y;
                this.orientedRect.y = this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 4: {
                this.orientedRect.x = this.imageRect.y;
                this.orientedRect.y = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 5: {
                this.orientedRect.x = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.y = this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 7: {
                this.orientedRect.x = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.y = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
            }
        }
    }

    public void showSelection() {
        if (this.selectingOn.booleanValue() || this.selectOn.booleanValue()) {
            ZoomSelection zoomSelection = this.iv.getZoomSelection();
            if (zoomSelection == ZoomSelection.AREA || zoomSelection == ZoomSelection.RELIEF || zoomSelection == ZoomSelection.ROCKINGCURVE) {
                this.imageCanvasGC.drawRectangle(this.selectedArea);
                if (this.imageChanged) {
                    this.showSelectedArea(this.selectedArea, true);
                }
                this.selectOn = true;
            } else if (zoomSelection == ZoomSelection.LINE) {
                this.imageCanvasGC.setXORMode(true);
                this.imageCanvasGC.setLineWidth(this.iv.getLinePeakWidth());
                this.imageCanvasGC.drawLine(this.selectedArea.x, this.selectedArea.y, this.selectedArea.x + this.selectedArea.width, this.selectedArea.y + this.selectedArea.height);
                this.imageCanvasGC.setLineWidth(1);
                this.imageCanvasGC.setXORMode(false);
                if (this.imageChanged) {
                    this.showSelectedLine();
                }
                this.selectOn = true;
            } else if (zoomSelection == ZoomSelection.PROFILE) {
                this.imageCanvasGC.drawRectangle(this.selectedArea);
                if (this.imageChanged) {
                    this.showProfile();
                }
                this.selectOn = true;
            }
            this.newSelection = false;
        }
    }

    public void showZoom(MouseEvent ev, boolean in) {
        float scale = in ? 2.0f : 0.5f;
        Rectangle bounds = this.imageCanvas.getBounds();
        int width = (int)((float)bounds.width * scale + 0.5f);
        int height = (int)((float)bounds.height * scale + 0.5f);
        int x = ev.x - width / 2;
        int y = ev.y - height / 2;
        Rectangle rect = new Rectangle(x, y, width, height);
        this.showSelectedArea(rect, true);
    }

    public void resetZoom() {
        if (this.image == null) {
            return;
        }
        this.selectingOn = false;
        this.selectOn = false;
        this.showSelectedArea(this.origRect, false);
    }

    public void showPeaks() {
        Vector<Float> peaks = this.iv.getPeaks();
        if (peaks != null) {
            this.imageCanvasGC.setForeground(this.display.getSystemColor(3));
            int i = 0;
            while (i < peaks.size() / 2) {
                Point point = this.tcToScreen(peaks.elementAt(i * 2).floatValue(), peaks.elementAt(i * 2 + 1).floatValue());
                int x = point.x;
                int y = point.y;
                Rectangle rect = new Rectangle(x -= this.iv.getLinePeakWidth() / 2, y -= this.iv.getLinePeakWidth() / 2, this.iv.getLinePeakWidth(), this.iv.getLinePeakWidth());
                this.imageCanvasGC.setLineWidth(1);
                this.imageCanvasGC.drawRectangle(rect);
                ++i;
            }
        }
    }

    void showPixelAtCursor(int mx, int my) {
        int x4 = (int)((double)mx * this.xScale);
        int y4 = (int)((double)my * this.yScale);
        if (x4 < 0 || x4 >= this.orientedRect.width || y4 < 0 || y4 >= this.orientedRect.height) {
            if (this.controls != null) {
                this.controls.setStatusText("");
            }
            return;
        }
        Point p = this.orientedToImage(new Point(x4, y4));
        int x1 = p.x;
        int y1 = p.y;
        if (x1 < 0 || x1 >= this.iv.getImageModel().getWidth() || y1 < 0 || y1 >= this.iv.getImageModel().getHeight()) {
            this.controls.setStatusText("");
            return;
        }
        float pixel = 0.0f;
        pixel = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(y1, x1) : this.iv.getImageDiffModel().getData(y1, x1);
        if (this.controls != null) {
            this.controls.setStatusText(this.iv.getCoordinates().getCoordinateString(x4 + this.orientedRect.x, y4 + this.orientedRect.y, pixel));
        }
    }

    void showSelectedArea(Rectangle rect, boolean screen) {
        Rectangle origRect = screen ? this.screenRectangleToImageRectangle(rect, true) : rect;
        try {
            float[] zoomAreaAsFloat;
            float[] statistics = null;
            if (!this.iv.isImageDiffOn()) {
                zoomAreaAsFloat = this.iv.getImageModel().getData(origRect);
                statistics = this.iv.getImageModel().getStatistics(origRect);
            } else {
                zoomAreaAsFloat = this.iv.getImageDiffModel().getData(origRect);
                statistics = this.iv.getImageDiffModel().getStatistics(origRect);
            }
            float areaMinimum = statistics[0];
            float areaMaximum = statistics[1];
            float areaMean = statistics[2];
            ZoomSelection zoomSelection = this.iv.getZoomSelection();
            if (zoomSelection == ZoomSelection.AREA) {
                IViewReference viewReference;
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "100", 1);
                }
                if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ImageView", "100")) != null) {
                    this.zoomAreaView = (ImageView)viewReference.getView(true);
                    if (this.zoomAreaView != null) {
                        this.zoomAreaView.setCoordOrigin(this.iv.getCoordOrigin());
                        this.zoomAreaView.setOrientation(this.iv.getOrientation());
                        this.zoomAreaView.getImage().setSelectOn(false);
                        this.zoomAreaView.getImage().changeImageRect(origRect, zoomAreaAsFloat, this.iv.getImageModel().getFileName(), this.iv.getImageModel());
                        this.zoomAreaView.setPartName("Zoom area " + this.iv.getFileName());
                        this.zoomAreaView.stopListening();
                        this.zoomAreaView.setViewType(ImageViewType.IMAGE_ZOOM_VIEW);
                        if (this.iv.getCoordOrigin() == 4) {
                            this.zoomAreaView.getCoordinates().reset(this.iv.getCoordOrigin(), this.iv.getCoordinates().getX0(), this.iv.getCoordinates().getY0(), this.iv.getCoordinates().getPixelWidth(), this.iv.getCoordinates().getPixelHeight(), this.iv.getCoordinates().getXName(), this.iv.getCoordinates().getYName());
                        } else {
                            this.zoomAreaView.resetCoordinates();
                        }
                        this.zoomAreaView.setMinMax(this.iv.getMinMax());
                        this.zoomAreaView.setPalette(this.iv.getPaletteIndex());
                    }
                }
            } else if (zoomSelection == ZoomSelection.RELIEF) {
                IViewReference viewReference;
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ReliefView", "0", 1);
                }
                if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ReliefView", "0")) != null) {
                    this.zoomReliefView = (ReliefView)viewReference.getView(true);
                    if (this.zoomReliefView != null) {
                        this.zoomReliefView.setImageAsFloat(zoomAreaAsFloat, origRect.width, origRect.height, areaMinimum, areaMaximum, areaMean, this.iv.getImageModel().getFileName());
                    }
                }
            } else if (zoomSelection == ZoomSelection.ROCKINGCURVE) {
                IViewReference viewReference;
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.RockingCurveView", "0", 1);
                }
                if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.RockingCurveView", "0")) != null) {
                    this.zoomRockingCurveView = (RockingCurveView)viewReference.getView(true);
                    if (this.zoomRockingCurveView != null) {
                        int x2 = origRect.width == 0 ? origRect.x : origRect.x + origRect.width - 1;
                        int y2 = origRect.height == 0 ? origRect.y : origRect.y + origRect.height - 1;
                        this.zoomRockingCurveView.setCenterArea("Rocking Curve " + this.iv.getFileName(), SampleController.getController().getCurrentFileIndex(), origRect.x, origRect.y, x2, y2);
                    }
                }
            }
        }
        catch (PartInitException ex) {
            FableUtils.excMsg((Object)this, (String)"Unable to show selected area", (Throwable)ex);
        }
    }

    void showSelectedLine() {
        Rectangle lineRect = this.screenRectangleToOrientedImageRectangle(this.selectedArea, false);
        int x1 = lineRect.x;
        int y1 = lineRect.y;
        int x2 = lineRect.x + lineRect.width - 1;
        int y2 = lineRect.y + lineRect.height - 1;
        Point p = new Point(0, 0);
        double[] vals = new double[]{0.0, 0.0};
        boolean inverted = false;
        try {
            IViewReference viewReference;
            int y;
            int x;
            float[] intensity;
            float[] pixels;
            int len;
            int temp;
            String yTitle;
            String xTitle;
            float slope = Float.NaN;
            if (Math.abs(x2 - x1) >= Math.abs(y2 - y1)) {
                xTitle = "Pixels in " + this.iv.getCoordinates().getXName();
                yTitle = "Intensity";
                inverted = this.iv.getCoordinates().isXInverted();
                if (x2 < x1) {
                    temp = x1;
                    x1 = x2;
                    x2 = temp;
                    temp = y1;
                    y1 = y2;
                    y2 = temp;
                }
                len = x2 - x1 + 1;
                pixels = new float[len];
                intensity = new float[len];
                if (x2 - x1 != 0) {
                    slope = (float)(y2 - y1) / (float)(x2 - x1);
                }
                this.logger.debug((Object)("slope " + slope));
                int i = 0;
                while (i < len) {
                    x = x1 + i;
                    y = (int)((double)((float)y1 + slope * (float)i) + 0.5);
                    if (y < 0) {
                        y = 0;
                    }
                    if (y > this.orientedOrigRect.height - 1) {
                        y = this.orientedOrigRect.height - 1;
                    }
                    intensity[i] = 0.0f;
                    int j = y - this.iv.getLinePeakWidth() / 2;
                    while (j < y + this.iv.getLinePeakWidth() / 2 + 1) {
                        p.x = x;
                        p.y = y;
                        vals = this.iv.getCoordinates().getCoordinatesFromOriented(p);
                        pixels[i] = (float)vals[0];
                        p = this.orientedToImage(p);
                        if (!this.iv.isImageDiffOn()) {
                            int n = i;
                            intensity[n] = intensity[n] + this.iv.getImageModel().getData(p.y, p.x);
                        } else {
                            int n = i;
                            intensity[n] = intensity[n] + this.iv.getImageDiffModel().getData(p.y, p.x);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                xTitle = "Pixels in " + this.iv.getCoordinates().getYName();
                yTitle = "Intensity";
                inverted = this.iv.getCoordinates().isYInverted();
                if (y2 < y1) {
                    temp = x1;
                    x1 = x2;
                    x2 = temp;
                    temp = y1;
                    y1 = y2;
                    y2 = temp;
                }
                len = y2 - y1 + 1;
                pixels = new float[len];
                intensity = new float[len];
                if (x2 - x1 != 0) {
                    slope = (float)(y2 - y1) / (float)(x2 - x1);
                }
                this.logger.debug((Object)("slope " + slope));
                int i = 0;
                while (i < len) {
                    y = y1 + i;
                    x = x2 - x1 != 0 ? (int)((double)((float)x1 + (float)i / slope) + 0.5) : x1;
                    if (x < 0) {
                        x = 0;
                    }
                    if (x > this.orientedOrigRect.width - 1) {
                        x = this.orientedOrigRect.width - 1;
                    }
                    intensity[i] = 0.0f;
                    int j = x - this.iv.getLinePeakWidth() / 2;
                    while (j < x + this.iv.getLinePeakWidth() / 2 + 1) {
                        p.x = x;
                        p.y = y;
                        vals = this.iv.getCoordinates().getCoordinatesFromOriented(p);
                        pixels[i] = (float)vals[1];
                        p = this.orientedToImage(p);
                        if (!this.iv.isImageDiffOn()) {
                            int n = i;
                            intensity[n] = intensity[n] + this.iv.getImageModel().getData(p.y, p.x);
                        } else {
                            int n = i;
                            intensity[n] = intensity[n] + this.iv.getImageDiffModel().getData(p.y, p.x);
                        }
                        ++j;
                    }
                    this.logger.setLevel(Level.ERROR);
                    ++i;
                }
            }
            if (this.newSelection.booleanValue()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.LineView", "0", 1);
            }
            if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.LineView", "0")) != null) {
                this.lineView = (LineView)viewReference.getView(true);
                if (this.lineView != null) {
                    String from = "unknown";
                    String to = "unknown";
                    p.x = x1;
                    p.y = y1;
                    from = this.iv.getCoordinates().getCoordinateString(p.x, p.y);
                    p.x = x2;
                    p.y = y2;
                    to = this.iv.getCoordinates().getCoordinateString(p.x, p.y);
                    xTitle = String.valueOf(xTitle) + " from (" + from + ") to (" + to + ") for " + this.iv.getCoordinatesName();
                    this.lineView.setData(this.iv.getFileName(), xTitle, inverted, pixels, yTitle, intensity);
                }
            }
        }
        catch (PartInitException ex) {
            FableUtils.excMsg((Object)this, (String)"Unable to show selected line", (Throwable)ex);
        }
    }

    void showProfile() {
        int temp;
        Rectangle lineRect = this.screenRectangleToImageRectangle(this.selectedArea, true);
        int x1 = lineRect.x;
        int y1 = lineRect.y;
        int x2 = lineRect.x + lineRect.width - 1;
        int y2 = lineRect.y + lineRect.height - 1;
        if (x1 > x2) {
            temp = y1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 > y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        try {
            IViewReference viewReference;
            int j;
            int[] pixels_x = new int[x2 - x1];
            float[] intensity_x = new float[x2 - x1];
            int i = 0;
            while (i < x2 - x1) {
                int x;
                pixels_x[i] = x = x1 + i;
                intensity_x[i] = 0.0f;
                j = y1;
                while (j < y2) {
                    if (!this.iv.isImageDiffOn()) {
                        int n = i;
                        intensity_x[n] = intensity_x[n] + this.iv.getImageModel().getData(j, x);
                    } else {
                        int n = i;
                        intensity_x[n] = intensity_x[n] + this.iv.getImageDiffModel().getData(j, x);
                    }
                    ++j;
                }
                ++i;
            }
            int[] pixels_y = new int[y2 - y1];
            float[] intensity_y = new float[y2 - y1];
            i = 0;
            while (i < y2 - y1) {
                int y;
                pixels_y[i] = y = y1 + i;
                intensity_y[i] = 0.0f;
                j = y1;
                while (j < y2) {
                    if (!this.iv.isImageDiffOn()) {
                        int n = i;
                        intensity_y[n] = intensity_y[n] + this.iv.getImageModel().getData(y, j);
                    } else {
                        int n = i;
                        intensity_y[n] = intensity_y[n] + this.iv.getImageDiffModel().getData(y, j);
                    }
                    ++j;
                }
                ++i;
            }
            if (this.newSelection.booleanValue()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ProfileView", "0", 1);
            }
            if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ProfileView", "0")) != null) {
                this.profileView = (ProfileView)viewReference.getView(true);
                if (this.profileView != null) {
                    this.profileView.setData(this.iv.getFileName(), pixels_x, intensity_x, pixels_y, intensity_y);
                }
            }
        }
        catch (PartInitException ex) {
            FableUtils.excMsg((Object)this, (String)"Unable to show profile", (Throwable)ex);
        }
    }

    public void changeImageRect(Rectangle rect, float[] areaAsFloat, String fileName, ImageModel _imageModel) {
        if (this.imageRect.width != rect.width || this.imageRect.height != rect.height) {
            this.clearCanvas();
        } else {
            this.selectingOn = false;
            this.selectOn = false;
        }
        if (_imageModel == null) {
            this.iv.setImageModel(new ImageModel(fileName, rect.width, rect.height, areaAsFloat));
        } else if (_imageModel != this.iv.getImageModel()) {
            this.iv.setImageModel(_imageModel);
        }
        this.imageRect = rect;
        this.calculateMainRectangles();
        this.iv.resetCoordinates();
        float[] statistics = this.iv.getImageModel().getStatistics(this.imageRect);
        this.iv.setMinimum(statistics[0]);
        this.iv.setMaximum(statistics[1]);
        this.iv.setMean(statistics[2]);
        this.iv.setMaximum(this.iv.getMean() + 2.0f * (this.iv.getMean() - this.iv.getMinimum()));
        if (this.iv.getMaximum() - this.iv.getMinimum() < 0.01f) {
            this.iv.setMaximum(this.iv.getMinimum() + 0.01f);
        }
        this.displayImage();
    }

    public void displayImage() {
        if (this.iv.getImageModel() == null || this.iv.getImageModel().getData() == null) {
            return;
        }
        if (this.iv.isAutoscale()) {
            this.iv.setCurrentMinimum(this.iv.getMinimum());
            this.iv.setCurrentMaximum(this.iv.getMaximum());
            if (this.controls != null) {
                this.controls.setMinMaxText(new float[]{this.iv.getMinimum(), this.iv.getMaximum()});
            }
        } else {
            float[] vals = this.controls.getMinMaxText();
            this.iv.setCurrentMinimum(vals[0]);
            this.iv.setCurrentMaximum(vals[1]);
        }
        if (this.iv.getCurrentMinimum() - this.iv.getCurrentMaximum() == 0.0f) {
            this.iv.setCurrentMinimum(this.iv.getCurrentMaximum() + 0.01f);
        } else {
            this.createImageData(this.iv.getCurrentMinimum(), this.iv.getCurrentMaximum(), this.iv.getPalette());
            this.imageData = !this.iv.isImageDiffOn() ? this.createImageData(this.iv.getCurrentMinimum(), this.iv.getCurrentMaximum(), this.iv.getPalette()) : this.createImageData(this.iv.getCurrentMinimum(), this.iv.getCurrentMaximum(), this.iv.getPalette());
            this.loadImage(this.imageData);
            this.drawImage();
        }
        if (this.selectOn.booleanValue()) {
            this.showSelection();
        }
        if (this.iv.isPeaksOn()) {
            this.showPeaks();
        }
        this.imageChanged = false;
    }

    public ImageData createImageData(float _minimum, float _maximum, PaletteData palette) {
        float[] screenImageData = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(this.imageRect) : this.iv.getImageDiffModel().getData(this.imageRect);
        int len = screenImageData.length;
        if (len == 0) {
            return null;
        }
        this.calculateMainRectangles();
        this.iv.resetCoordinates();
        float scale_8bit = 255.0f / (_maximum - _minimum);
        byte[] scaledImageAsByte = new byte[len];
        float maxPixel = _maximum - _minimum;
        int i = 0;
        while (i < len) {
            float scaled_pixel = screenImageData[i] < _minimum ? 0.0f : (screenImageData[i] > _maximum ? maxPixel : screenImageData[i] - _minimum);
            byte pixel = (byte)(0xFF & (int)(scaled_pixel *= scale_8bit));
            switch (this.iv.getOrientation()) {
                default: {
                    scaledImageAsByte[i] = pixel;
                    break;
                }
                case 1: {
                    int x1 = this.imageRect.width - i % this.imageRect.width - 1;
                    int y1 = i / this.imageRect.width;
                    scaledImageAsByte[y1 * this.orientedRect.width + x1] = pixel;
                    break;
                }
                case 2: {
                    int x1 = i % this.imageRect.width;
                    int y1 = this.imageRect.height - i / this.imageRect.width - 1;
                    scaledImageAsByte[y1 * this.orientedRect.width + x1] = pixel;
                    break;
                }
                case 3: {
                    scaledImageAsByte[len - i - 1] = pixel;
                    break;
                }
                case 6: {
                    int x1 = i / this.imageRect.width;
                    int y1 = i % this.imageRect.width;
                    scaledImageAsByte[y1 * this.orientedRect.width + x1] = pixel;
                    break;
                }
                case 4: {
                    int x1 = i / this.imageRect.width;
                    int y1 = this.imageRect.width - i % this.imageRect.width - 1;
                    scaledImageAsByte[y1 * this.orientedRect.width + x1] = pixel;
                    break;
                }
                case 5: {
                    int x1 = this.imageRect.height - i / this.imageRect.width - 1;
                    int y1 = i % this.imageRect.width;
                    scaledImageAsByte[y1 * this.orientedRect.width + x1] = pixel;
                    break;
                }
                case 7: {
                    int x1 = this.imageRect.height - i / this.imageRect.width - 1;
                    int y1 = this.imageRect.width - i % this.imageRect.width - 1;
                    scaledImageAsByte[y1 * this.orientedRect.width + x1] = pixel;
                }
            }
            ++i;
        }
        ImageData imageData = new ImageData(this.orientedRect.width, this.orientedRect.height, 8, palette, 1, scaledImageAsByte);
        return imageData;
    }

    public Image loadImage(ImageData data) {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
        Rectangle bounds = this.imageCanvas.getBounds();
        this.xScale = (double)this.orientedRect.width / (double)bounds.width;
        this.yScale = (double)this.orientedRect.height / (double)bounds.height;
        if (this.iv.isKeepAspect()) {
            if (this.xScale > this.yScale) {
                this.yScale = this.xScale;
            } else {
                this.xScale = this.yScale;
            }
        }
        if ((double)this.orientedRect.width / this.xScale < 1.0) {
            this.xScale = (double)this.orientedRect.width / (double)bounds.width;
        }
        if ((double)this.orientedRect.height / this.yScale < 1.0) {
            this.yScale = (double)this.orientedRect.height / (double)bounds.height;
        }
        int xscaledTo = (int)((double)this.orientedRect.width / this.xScale);
        int yscaledTo = (int)((double)this.orientedRect.height / this.yScale);
        if (data == null) {
            this.logger.debug((Object)"data is null !");
            this.image = null;
        } else {
            this.image = new Image((Device)Display.getCurrent(), data.scaledTo(xscaledTo, yscaledTo));
        }
        return this.image;
    }

    void drawImage() {
        if (this.imageCanvasGC != null && this.image != null) {
            this.imageCanvasGC.drawImage(this.image, 0, 0);
        }
    }

    private void createDropTarget() {
        DropTarget dropTarget = new DropTarget((Control)this.imageCanvas, 17);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        dropTarget.setTransfer(types);
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                String text;
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && (text = (String)event.data).startsWith("samplefile")) {
                    ImageViewImage.this.iv.dropFile();
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
    }

    public Point orientedToImage(Point point) {
        int x3 = point.x + this.orientedRect.x;
        int y3 = point.y + this.orientedRect.y;
        int x2 = x3;
        int y2 = y3;
        switch (this.iv.getOrientation()) {
            default: {
                break;
            }
            case 1: {
                x2 = this.orientedOrigRect.width - x3 - 1;
                break;
            }
            case 2: {
                y2 = this.orientedOrigRect.height - y3 - 1;
                break;
            }
            case 3: {
                x2 = this.orientedOrigRect.width - x3 - 1;
                y2 = this.orientedOrigRect.height - y3 - 1;
                break;
            }
            case 6: {
                x2 = y3;
                y2 = x3;
                break;
            }
            case 4: {
                x2 = this.orientedOrigRect.height - y3 - 1;
                y2 = x3;
                break;
            }
            case 5: {
                x2 = y3;
                y2 = this.orientedOrigRect.width - x3 - 1;
                break;
            }
            case 7: {
                x2 = this.orientedOrigRect.height - y3 - 1;
                y2 = this.orientedOrigRect.width - x3 - 1;
            }
        }
        Point converted = new Point(x2, y2);
        return converted;
    }

    public Point imageToOriented(Point point) {
        float[] array = this.imageToOriented(new float[]{point.x, point.y});
        return new Point((int)((double)array[0] + 0.5), (int)((double)array[1] + 0.5));
    }

    public float[] imageToOriented(float[] point) {
        float x2 = point[0];
        float y2 = point[1];
        float x3 = x2;
        float y3 = y2;
        switch (this.iv.getOrientation()) {
            default: {
                break;
            }
            case 1: {
                x3 = (float)this.orientedOrigRect.width - x2 - 1.0f;
                break;
            }
            case 2: {
                y3 = (float)this.orientedOrigRect.height - y2 - 1.0f;
                break;
            }
            case 3: {
                x3 = (float)this.orientedOrigRect.width - x2 - 1.0f;
                y3 = (float)this.orientedOrigRect.height - y2 - 1.0f;
                break;
            }
            case 6: {
                x3 = y2;
                y3 = x2;
                break;
            }
            case 4: {
                x3 = (float)this.orientedOrigRect.height - y2 - 1.0f;
                y3 = x2;
                break;
            }
            case 5: {
                x3 = y2;
                y3 = (float)this.orientedOrigRect.width - x2 - 1.0f;
                break;
            }
            case 7: {
                x3 = (float)this.orientedOrigRect.height - y2 - 1.0f;
                y3 = (float)this.orientedOrigRect.width - x2 - 1.0f;
            }
        }
        float[] converted = new float[]{x3 - (float)this.orientedRect.x, y3 - (float)this.orientedRect.y};
        return converted;
    }

    public Rectangle screenRectangleToImageRectangle(Rectangle screenRect, boolean ordered) {
        int x0 = screenRect.x - this.imageData.x;
        int y0 = screenRect.y - this.imageData.y;
        int x1 = (int)((double)x0 * this.xScale);
        int y1 = (int)((double)y0 * this.yScale);
        int x2 = screenRect.width != 0 ? (int)((double)(x0 + screenRect.width - 1) * this.xScale) : x1;
        int y2 = screenRect.height != 0 ? (int)((double)(y0 + screenRect.height - 1) * this.yScale) : y1;
        Point p1 = this.orientedToImage(new Point(x1, y1));
        Point p2 = this.orientedToImage(new Point(x2, y2));
        x1 = p1.x;
        y1 = p1.y;
        x2 = p2.x;
        y2 = p2.y;
        if (ordered) {
            int temp;
            if (x1 > x2) {
                temp = x1;
                x1 = x2;
                x2 = temp;
            }
            if (y1 > y2) {
                temp = y1;
                y1 = y2;
                y2 = temp;
            }
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x1 >= this.origRect.width) {
            x1 = this.origRect.width - 1;
        }
        if (x2 < 0) {
            x2 = 0;
        }
        if (x2 >= this.origRect.width) {
            x2 = this.origRect.width - 1;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y1 >= this.origRect.height) {
            y1 = this.origRect.height - 1;
        }
        if (y2 < 0) {
            y2 = 0;
        }
        if (y2 >= this.origRect.height) {
            y2 = this.origRect.height - 1;
        }
        int width = x2 - x1 + 1;
        int height = y2 - y1 + 1;
        Rectangle newRect = new Rectangle(x1, y1, width, height);
        return newRect;
    }

    public Rectangle screenRectangleToOrientedImageRectangle(Rectangle screenRect, boolean ordered) {
        int x0 = screenRect.x - this.imageData.x;
        int y0 = screenRect.y - this.imageData.y;
        int x1 = (int)((double)x0 * this.xScale);
        int y1 = (int)((double)y0 * this.yScale);
        int x2 = screenRect.width != 0 ? (int)((double)(x0 + screenRect.width - 1) * this.xScale) : x1;
        int y2 = screenRect.height != 0 ? (int)((double)(y0 + screenRect.height - 1) * this.yScale) : y1;
        if (ordered) {
            int temp;
            if (x1 > x2) {
                temp = x1;
                x1 = x2;
                x2 = temp;
            }
            if (y1 > y2) {
                temp = y1;
                y1 = y2;
                y2 = temp;
            }
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x1 >= this.orientedRect.width) {
            x1 = this.orientedRect.width - 1;
        }
        if (x2 < 0) {
            x2 = 0;
        }
        if (x2 >= this.orientedRect.width) {
            x2 = this.orientedRect.width - 1;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y1 >= this.orientedRect.height) {
            y1 = this.orientedRect.height - 1;
        }
        if (y2 < 0) {
            y2 = 0;
        }
        if (y2 >= this.orientedRect.height) {
            y2 = this.orientedRect.height - 1;
        }
        int width = x2 - x1 + 1;
        int height = y2 - y1 + 1;
        Rectangle newRect = new Rectangle(x1, y1, width, height);
        return newRect;
    }

    public Point tcToScreen(float y, float z) {
        Point point = new Point(0, 0);
        point.x = (int)((double)(y - (float)this.imageRect.x) / this.xScale);
        point.y = (int)((double)(z - (float)this.imageRect.y) / this.yScale);
        return point;
    }

    public void clearCanvas() {
        if (this.imageCanvas != null && this.imageCanvasGC != null) {
            Rectangle bounds = this.imageCanvas.getBounds();
            this.imageCanvasGC.fillRectangle(0, 0, bounds.width, bounds.height);
        }
        this.selectingOn = false;
    }

    public Rectangle getSelectedArea() {
        return this.selectedArea;
    }

    public void selectZoom(ZoomSelection zoomselect) {
        this.logger.debug((Object)("set zoom to " + zoomselect.getName()));
        this.iv.setZoomSelection(zoomselect);
        this.selectingOn = false;
        this.selectOn = false;
    }

    public void colorPeaks(float[] peakToColor) {
        this.showPeaks();
        if (peakToColor != null) {
            float[] orig = new float[]{0.0f, 0.0f};
            this.imageCanvasGC.setForeground(this.display.getSystemColor(5));
            int i = 0;
            while (i < peakToColor.length / 2) {
                int index = i * 2;
                orig[0] = peakToColor[index];
                orig[1] = peakToColor[index + 1];
                float[] point = this.imageToOriented(orig);
                int x = (int)((double)point[0] / this.xScale + 0.5);
                int y = (int)((double)point[1] / this.yScale + 0.5);
                Rectangle rect = new Rectangle(x -= this.iv.getLinePeakWidth() / 2, y -= this.iv.getLinePeakWidth() / 2, this.iv.getLinePeakWidth(), this.iv.getLinePeakWidth());
                this.imageCanvasGC.drawRectangle(rect);
                ++i;
            }
        }
    }

    public boolean isImageChanged() {
        return this.imageChanged;
    }

    public void setImageChanged(boolean imageChanged) {
        this.imageChanged = imageChanged;
    }

    public Rectangle getImageRect() {
        return this.imageRect;
    }

    public void setImageRect(Rectangle imageRect) {
        this.imageRect = imageRect;
    }

    public Rectangle getOrigRect() {
        return this.origRect;
    }

    public Rectangle getOrientedOrigRect() {
        return this.orientedOrigRect;
    }

    public Rectangle getOrientedRect() {
        return this.orientedRect;
    }

    public Boolean getSelectOn() {
        return this.selectOn;
    }

    public void setSelectOn(Boolean selectOn) {
        this.selectOn = selectOn;
    }

    public Image getImage() {
        return this.image;
    }
}

