/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.navigator.controller.SampleController;
import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.views.ImageView;
import java.util.Vector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class ImagePlay
extends ViewPart {
    public static final String ID = "fable.imageviewer.views.ImagePlay";
    private Button imageNextButton;
    private Button imagePreviousButton;
    private Button imageFirstButton;
    private Button imageLastButton;
    private Button imagePauseButton;
    private boolean advancePlay = false;
    private int currentFileIndex = 0;
    private int playStep = 1;
    private int playWait = 3000;
    private Thread playThread = null;
    static ImageView iv = null;

    public void createPartControl(Composite parent) {
        GridLayout parentField = new GridLayout();
        parentField.numColumns = 5;
        parentField.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)parentField);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imageFirstButton = new Button(parent, 8);
        this.imageFirstButton.setText("<<");
        this.imageFirstButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imageFirstButton.setToolTipText("Go to first image");
        this.imageFirstButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImagePlay.this.isAdvancePlay()) {
                    ImagePlay.this.startPlay(-1, 300);
                } else {
                    iv.getController().setCurrentFileIndex(0);
                    iv.getController().getFirstImage();
                }
            }
        });
        this.imagePreviousButton = new Button(parent, 8);
        this.imagePreviousButton.setText("<");
        this.imagePreviousButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imagePreviousButton.setToolTipText("Go to previous image");
        this.imagePreviousButton.setEnabled(true);
        this.imagePreviousButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImagePlay.this.isAdvancePlay()) {
                    ImagePlay.this.startPlay(-1, 3000);
                } else {
                    int fileIndex = iv.getController().getCurrentFileIndex() - 1;
                    if (fileIndex >= 0) {
                        iv.getController().setCurrentFileIndex(fileIndex);
                    } else {
                        if (iv.getController().getCurrentsample() != null) {
                            iv.getController().setCurrentFileIndex(iv.getController().getCurrentsample().getFilteredfiles().size() - 1);
                        }
                        iv.getController().getNext(-1);
                    }
                }
            }
        });
        this.imagePauseButton = new Button(parent, 8);
        this.imagePauseButton.setText("Play");
        this.imagePauseButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imagePauseButton.setToolTipText("Play");
        this.imagePauseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImagePlay.this.setAdvancePlay(!ImagePlay.this.isAdvancePlay());
                if (ImagePlay.this.isAdvancePlay()) {
                    ImagePlay.this.startPlay(1, 3000);
                    ImagePlay.this.imagePauseButton.setText("||");
                    ImagePlay.this.imagePauseButton.setToolTipText("Pause");
                } else {
                    ImagePlay.this.imagePauseButton.setText("Play");
                    ImagePlay.this.imagePauseButton.setToolTipText("Play");
                }
            }
        });
        this.imageNextButton = new Button(parent, 8);
        this.imageNextButton.setText(">");
        this.imageNextButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imageNextButton.setToolTipText("Go to next image");
        this.imageNextButton.setEnabled(true);
        this.imageNextButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImagePlay.this.isAdvancePlay()) {
                    ImagePlay.this.startPlay(1, 3000);
                } else {
                    int fileIndex = iv.getController().getCurrentFileIndex() + 1;
                    if (iv.getController().getCurrentsample() != null) {
                        if (fileIndex >= iv.getController().getCurrentsample().getFilteredfiles().size()) {
                            fileIndex = 0;
                        }
                        iv.getController().setCurrentFileIndex(fileIndex);
                    }
                    iv.getController().getNext(1);
                }
            }
        });
        this.imageLastButton = new Button(parent, 8);
        this.imageLastButton.setText(">>");
        this.imageLastButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imageLastButton.setToolTipText("Go to last image");
        this.imageLastButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImagePlay.this.isAdvancePlay()) {
                    ImagePlay.this.startPlay(1, 300);
                } else {
                    if (iv.getController().getCurrentsample() != null) {
                        int lastFileIndex = iv.getController().getCurrentsample().getFilteredfiles().size();
                        iv.getController().setCurrentFileIndex(lastFileIndex - 1);
                    }
                    iv.getController().getLastImage();
                }
            }
        });
    }

    public void setFocus() {
    }

    public boolean isAdvancePlay() {
        return this.advancePlay;
    }

    public void setAdvancePlay(boolean advancePlay) {
        this.advancePlay = advancePlay;
    }

    public void startPlay(int step, int wait) {
        this.playStep = step;
        this.playWait = wait;
        if (this.playThread == null) {
            this.playThread = this.PlayThread();
            this.playThread.start();
        }
    }

    public Thread PlayThread() {
        return new Thread(){

            @Override
            public void run() {
                SampleController controller = iv.getController();
                Vector selectedFiles = SampleNavigatorView.view.getSelectedFilesIndex();
                int selectedFilesIndex = 0;
                if (selectedFiles.size() <= 1) {
                    ImagePlay.this.currentFileIndex = controller.getCurrentFileIndex();
                } else {
                    ImagePlay.this.currentFileIndex = (Integer)selectedFiles.firstElement();
                }
                while (ImagePlay.this.advancePlay) {
                    try {
                        if (selectedFiles.size() <= 1) {
                            ImagePlay imagePlay = ImagePlay.this;
                            imagePlay.currentFileIndex = imagePlay.currentFileIndex + ImagePlay.this.playStep;
                        } else {
                            if ((selectedFilesIndex += ImagePlay.this.playStep) >= selectedFiles.size()) {
                                selectedFilesIndex = 0;
                            }
                            ImagePlay.this.currentFileIndex = (Integer)selectedFiles.elementAt(selectedFilesIndex);
                        }
                        controller.getNext(ImagePlay.this.playStep);
                        if (controller.getCurrentsample() != null) {
                            if (ImagePlay.this.currentFileIndex >= controller.getCurrentsample().getFilteredfiles().size()) {
                                ImagePlay.this.currentFileIndex = 0;
                            } else if (ImagePlay.this.currentFileIndex < 0) {
                                ImagePlay.this.currentFileIndex = controller.getCurrentsample().getFilteredfiles().size() - 1;
                            }
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    iv.getController().setCurrentFileIndex(ImagePlay.this.currentFileIndex);
                                }
                            });
                        }
                        Thread.sleep(ImagePlay.this.playWait);
                    }
                    catch (InterruptedException ex) {
                        FableUtils.excTraceMsg((Object)this, (String)"PlayThread Interrupted", (Throwable)ex);
                    }
                }
                ImagePlay.this.playThread = null;
            }
        };
    }

    public static void setView(ImageView view) {
        iv = view;
    }
}

