/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.Token;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.VisitorException;
import org.omg.CORBA.TCKind;

public class StringValue
extends AbstractTCLNode {
    private final String value_;
    private final EvaluationResult result_;

    public StringValue(Token token) {
        super(token);
        this.setKind(TCKind.tk_string);
        this.value_ = token.getText();
        EvaluationResult evaluationResult = new EvaluationResult();
        evaluationResult.setString(this.value_);
        this.result_ = EvaluationResult.wrapImmutable(evaluationResult);
    }

    public void acceptInOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        abstractTCLVisitor.visitString(this);
    }

    public void acceptPostOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        abstractTCLVisitor.visitString(this);
    }

    public String toString() {
        return "'" + this.value_ + "'";
    }

    public EvaluationResult evaluate(EvaluationContext evaluationContext) {
        return this.result_;
    }

    public boolean isNumber() {
        return this.value_.length() == 1;
    }

    public boolean isStatic() {
        return true;
    }

    public boolean isString() {
        return true;
    }

    public String getName() {
        return "StringValue";
    }

    public void acceptPreOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        abstractTCLVisitor.visitString(this);
    }
}

