/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.jep.FableJep;
import fable.framework.toolbox.FabioFile;
import fable.framework.toolbox.FabioFileException;
import fable.framework.toolbox.ISampleListener;
import fable.framework.toolbox.SampleEvent;
import fable.framework.toolbox.SampleException;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import jep.JepException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class Sample {
    private String parentDirectoryName;
    private String directoryName;
    private String directoryPath;
    private String[] currentFiles;
    private static String DEFAULT_SAMPLE_PATH = "\\data\\opid11\\inhouse\\";
    private Vector<FabioFile> fabioFiles = new Vector();
    private Vector<FabioFile> filteredfabiofiles = new Vector();
    private Vector<ISampleListener> listListener = new Vector();
    private String fileFormat = "";
    public boolean headersRead = false;
    private String ndigits = "4";
    private String peaksearchOutStem = "";
    private ArrayList<IPropertyChangeListener> listeners = new ArrayList();
    private String[] keys = null;
    private int last = -1;
    int first = -1;
    private String filter = "";
    private boolean showInNavigator = true;
    private boolean isDirectory = true;
    private HashMap<String, double[]> headerValues = new HashMap();
    private HashMap<String, double[]> headerdiffValues = new HashMap();
    private FabioFile currentFabioFile;
    private boolean isValide = true;
    private FableJep fableJep;
    private String stem = null;

    public Sample(String experimentName, String sampleName, String path, String[] listFiles) throws FabioFileException {
        this.setDirectoryName(sampleName);
        this.setParentDirectoryName(experimentName);
        this.setDirectoryPath(path);
        this.fabioFiles = new Vector();
        this.filteredfabiofiles = (Vector)this.fabioFiles.clone();
        this.addFabioFiles(listFiles);
    }

    public Sample(String experimentName, String sampleName, String path) {
        this.setDirectoryName(sampleName);
        this.setParentDirectoryName(experimentName);
        this.setDirectoryPath(path);
    }

    public Sample(String experimentName, String sampleName) {
        this.setDirectoryName(sampleName);
        this.setParentDirectoryName(experimentName);
        String path = String.valueOf(DEFAULT_SAMPLE_PATH) + "\\" + experimentName + "\\" + sampleName;
        this.setDirectoryPath(path);
    }

    public Sample() {
    }

    public Sample(String path, File[] files) throws FabioFileException {
        this.setDirectoryPath(path);
        this.fabioFiles = new Vector();
        this.filteredfabiofiles = (Vector)this.fabioFiles.clone();
        this.addFabioFiles(files);
    }

    public Sample(String experimentName, String sampleName, String directory, File[] filesInDir) throws FabioFileException {
        this(directory, filesInDir);
        this.setDirectoryName(sampleName);
        this.setParentDirectoryName(experimentName);
    }

    private void addFabioFiles(File[] files) throws FabioFileException {
        int i = 0;
        while (files != null && i < files.length) {
            this.addFabioFile(new FabioFile(files[i].getAbsolutePath()));
            ++i;
        }
        this.currentFiles = new String[this.fabioFiles.size()];
        i = 0;
        while (this.fabioFiles != null && i < this.fabioFiles.size()) {
            this.currentFiles[i] = this.fabioFiles.elementAt(i).getFullFilename();
            ++i;
        }
        this.filteredfabiofiles = (Vector)this.fabioFiles.clone();
        this.fireSampleHasNewFiles();
    }

    public void addCurrentFiles(String[] newFiles) {
        this.currentFiles = newFiles;
        this.fireSampleHasNewFiles();
    }

    public void addFabioFiles(String[] newFiles) throws FabioFileException {
        int i = 0;
        while (newFiles != null && i < newFiles.length) {
            this.addFabioFile(new FabioFile(newFiles[i]));
            ++i;
        }
        this.currentFiles = new String[this.fabioFiles.size()];
        i = 0;
        while (this.fabioFiles != null && i < this.fabioFiles.size()) {
            this.currentFiles[i] = this.fabioFiles.elementAt(i).getFullFilename();
            ++i;
        }
        this.filteredfabiofiles = (Vector)this.fabioFiles.clone();
        this.fireSampleHasNewFiles();
    }

    public void updatefabioFiles(String[] newFiles) throws FabioFileException {
        this.fabioFiles.removeAllElements();
        int i = 0;
        while (newFiles != null && i < newFiles.length) {
            this.addFabioFile(new FabioFile(newFiles[i]));
            ++i;
        }
        this.currentFiles = new String[this.fabioFiles.size()];
        i = 0;
        while (this.fabioFiles != null && i < this.fabioFiles.size()) {
            this.currentFiles[i] = this.fabioFiles.elementAt(i).getFullFilename();
            ++i;
        }
        this.applyFilter();
        this.fireUpdatefiles();
    }

    public boolean addFabioFile(FabioFile _fabioFile) throws FabioFileException {
        this.addPropertyChangeListener(_fabioFile);
        _fabioFile.addIndex(this.fabioFiles.size());
        this.fabioFiles.add(_fabioFile);
        this.filteredfabiofiles.add(_fabioFile);
        return true;
    }

    public String[] getKeys() throws SampleException {
        if (this.fabioFiles != null && this.fabioFiles.size() > 0) {
            try {
                if (this.currentFabioFile != null) {
                    this.keys = this.currentFabioFile.getKeys();
                }
            }
            catch (FabioFileException fabioFileException) {
                throw new SampleException(this.getClass().getName(), "getKeys", "Header keys cannot be retrieve for current file ");
            }
            catch (JepException jepException) {
                throw new SampleException(this.getClass().getName(), "getKeys", "Header keys cannot be retrieve for current file ");
            }
        }
        return this.keys;
    }

    public boolean isValide() {
        return this.isValide;
    }

    public boolean hasFile() {
        return this.currentFiles != null && this.currentFiles.length > 0;
    }

    public String getParentDirectoryName() {
        return this.parentDirectoryName;
    }

    public void setParentDirectoryName(String experiment) {
        if (experiment != null) {
            this.parentDirectoryName = experiment;
        }
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String name) {
        if (name != null) {
            this.directoryName = name;
        }
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String path) {
        this.directoryPath = path;
    }

    public String toString() {
        return "Experiment : " + this.getParentDirectoryName() + " Sample name: " + this.getDirectoryName() + " Directory: " + this.getDirectoryPath();
    }

    public String[] getFabioFilesToProcess(boolean flag) {
        Vector<String> filesToGet = new Vector<String>();
        int i = 0;
        while (this.filteredfabiofiles != null && i < this.filteredfabiofiles.size() && this.filteredfabiofiles.elementAt(i).getFlag()) {
            filesToGet.add(this.filteredfabiofiles.elementAt(i).getFullFilename());
            ++i;
        }
        String[] files = new String[filesToGet.size()];
        int i2 = 0;
        while (i2 < filesToGet.size()) {
            files[i2] = (String)filesToGet.elementAt(i2);
            ++i2;
        }
        return files;
    }

    public String[] getFiles() {
        return this.currentFiles;
    }

    public void setFiles(String[] _files) {
        this.currentFiles = _files;
    }

    public void setCurrentFilesFromFabio() {
        this.currentFiles = new String[this.fabioFiles.size()];
        int i = 0;
        while (this.fabioFiles != null && i < this.fabioFiles.size()) {
            this.currentFiles[i] = this.fabioFiles.elementAt(i).getFullFilename();
            ++i;
        }
        this.fireSampleHasNewFiles();
    }

    public Vector<FabioFile> getFabioFiles() {
        return this.fabioFiles;
    }

    public Vector<FabioFile> getFilteredfiles() {
        return this.filteredfabiofiles;
    }

    public void setComparator(String Key2, int dir) {
        this.fireSetComparator(Key2);
        this.fireSetDirection(dir);
    }

    public Vector<FabioFile> getSortedFiles() {
        Collections.sort(this.fabioFiles);
        return this.fabioFiles;
    }

    private void fireSetComparator(String key) {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "comparator", null, (Object)key));
        }
    }

    private void fireSetDirection(int dir) {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "dir", null, (Object)dir));
        }
    }

    private void fireUpdatefiles() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "updatefiles", null, (Object)this));
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyrChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void removeFiles() {
        if (this.hasFile()) {
            this.currentFiles = null;
            this.fabioFiles.removeAllElements();
            this.fireSampleHasChanged();
        }
    }

    public void removeFileAt(int indice) {
        if (this.hasFile()) {
            this.fabioFiles.removeElementAt(indice);
            this.fireSampleHasChanged();
        }
    }

    public void removeFabioFile(FabioFile f) {
        if (this.hasFile() && f != null) {
            this.fabioFiles.removeElement(f);
            if (this.filteredfabiofiles != null && this.filteredfabiofiles.size() > 0) {
                this.filteredfabiofiles.remove(f);
            }
            this.fireSampleHasChanged();
        }
    }

    public void setFilter(String s_filter) {
        this.filter = s_filter;
        this.applyFilter();
    }

    private void applyFilter() {
        assert (this.fabioFiles != null);
        this.filteredfabiofiles = (Vector)this.fabioFiles.clone();
        if (this.filter != null && !this.filter.trim().equals("")) {
            for (FabioFile file : this.fabioFiles) {
                String filename = file.getFileName();
                if (!filename.contains(this.filter)) {
                    this.filteredfabiofiles.remove(file);
                    continue;
                }
                int updateIndex = this.filteredfabiofiles.indexOf(file);
                if (updateIndex < 0) continue;
                file.addHeaderInfo("#", String.valueOf(updateIndex));
            }
        } else {
            int i = 0;
            while (i < this.fabioFiles.size()) {
                this.fabioFiles.elementAt(i).addHeaderInfo("#", String.valueOf(i));
                ++i;
            }
        }
    }

    private void fireSampleHasNewFiles() {
        SampleEvent se = new SampleEvent(this);
        Enumeration<ISampleListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().newImages(se);
        }
    }

    private void fireSampleHasChanged() {
        SampleEvent se = new SampleEvent(this);
        Enumeration<ISampleListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().sampleHasChanged(se);
        }
    }

    public void fireSomeHeaderValuesLoaded() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "updateHeaderValues", null, null));
        }
    }

    public void addSampleListener(ISampleListener pl) {
        this.listListener.add(pl);
    }

    public void removeSampleListener(ISampleListener pl) {
        this.listListener.remove(pl);
    }

    public String getName() {
        return this.directoryName;
    }

    public int getFirst() {
        if (this.hasFile() && this.first == -1) {
            try {
                this.first = this.getFileNumber(this.fabioFiles.elementAt(0).getFileName());
            }
            catch (FabioFileException fabioFileException) {
                this.first = 0;
            }
        }
        return this.first;
    }

    public void setFirst(int one) {
        this.first = one;
    }

    public void setlast(int l) {
        this.last = l;
    }

    public int getLast() {
        if (this.hasFile() && this.last == -1) {
            try {
                this.last = this.getFileNumber(this.fabioFiles.lastElement().getFileName());
            }
            catch (FabioFileException fabioFileException) {
                this.last = 0;
            }
        }
        return this.last;
    }

    private int getFileNumber(String filename) throws FabioFileException {
        String first = "";
        int ret = -99;
        String format = this.getFileFormat();
        if (format != null) {
            if (format.equals("bruker")) {
                first = filename.substring(filename.lastIndexOf("."));
            } else {
                int index = filename.indexOf(".");
                if (index > 0 && (filename = filename.substring(0, index)).length() - 4 > 0) {
                    first = filename.substring(filename.length() - 4, filename.length());
                }
            }
            try {
                ret = Integer.valueOf(first);
            }
            catch (Exception exception) {
                throw new FabioFileException(this.getClass().getName(), "getFileNumber", "Sample can not get file number");
            }
        }
        return ret;
    }

    public String getFileFormat() {
        String fileName;
        int indexExtension;
        if (this.hasFile() && this.fileFormat.equals("") && (indexExtension = (fileName = this.fabioFiles.elementAt(0).getFileName()).indexOf(".")) >= 0) {
            this.fileFormat = fileName.substring(indexExtension);
            try {
                Integer.valueOf(this.fileFormat);
                this.fileFormat = "bruker";
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.fileFormat;
    }

    public void setFileFormat(String format) {
        this.fileFormat = format;
    }

    public void setNDigits(String val) {
        this.ndigits = val;
    }

    public String getNDigits() {
        return this.ndigits;
    }

    public void setPeaksearchOutfile(String outfile) {
        this.peaksearchOutStem = outfile;
    }

    public String getPeaksearchoutStem() {
        return this.peaksearchOutStem;
    }

    public double[] getHeaderValues(final String key) throws SampleException {
        int size = this.filteredfabiofiles.size();
        double[] values = this.headerValues.get(key);
        Job job = new Job("Get values for " + key){

            protected IStatus run(final IProgressMonitor monitor) {
                monitor.beginTask("Wait while getting values for " + key + " in sample " + Sample.this.getDirectoryName(), Sample.this.filteredfabiofiles.size());
                if (Sample.this.hasFile()) {
                    int i = 0;
                    Iterator it = Sample.this.filteredfabiofiles.iterator();
                    while (it.hasNext()) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        final FabioFile f = (FabioFile)it.next();
                        if (i >= ((double[])Sample.this.headerValues.get(key)).length) continue;
                        final int j = i++;
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                double[] fillValues = (double[])Sample.this.headerValues.get(key);
                                try {
                                    if (key.toLowerCase().contains("date")) {
                                        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.UK);
                                        try {
                                            Date date = dateFormat.parse(f.getValue(key));
                                            fillValues[j] = date.getTime();
                                        }
                                        catch (ParseException parseException) {}
                                    } else {
                                        fillValues[j] = Double.valueOf(f.getValue(key));
                                    }
                                    if (j % 10 == 0 && j > 0) {
                                        Sample.this.fireSomeHeaderValuesLoaded();
                                    } else if (j == fillValues.length - 1) {
                                        Sample.this.fireSomeHeaderValuesLoaded();
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    monitor.setCanceled(true);
                                }
                                catch (FabioFileException fabioFileException) {
                                    monitor.setCanceled(true);
                                }
                            }
                        });
                        monitor.worked(1);
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        if (values == null || values.length != size) {
            values = new double[size];
            this.headerValues.put(key, values);
            job.schedule();
        }
        return this.headerValues.get(key);
    }

    public void addHeaderValues(String key, double[] values) {
        this.headerValues.put(key, values);
    }

    public double[] getHeaderValuesDiff(final String key) throws SampleException {
        int size = this.filteredfabiofiles.size();
        double[] values = this.headerdiffValues.get(key);
        Job job = new Job("Get values for " + key){

            protected IStatus run(final IProgressMonitor monitor) {
                monitor.beginTask("Wait while getting values for " + key + " in sample " + Sample.this.getDirectoryName(), Sample.this.filteredfabiofiles.size());
                if (Sample.this.hasFile()) {
                    int it = 0;
                    while (it < Sample.this.filteredfabiofiles.size()) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        final FabioFile f = (FabioFile)Sample.this.filteredfabiofiles.elementAt(it);
                        if (it + 1 < Sample.this.filteredfabiofiles.size()) {
                            final FabioFile next = (FabioFile)Sample.this.filteredfabiofiles.elementAt(it + 1);
                            if (it < ((double[])Sample.this.headerdiffValues.get(key)).length) {
                                final int j = it;
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        double[] fillValues = (double[])Sample.this.headerdiffValues.get(key);
                                        try {
                                            double dnext = Double.valueOf(next.getValue(key));
                                            double delem = Double.valueOf(f.getValue(key));
                                            fillValues[j] = dnext - delem;
                                            if (j % 10 == 0 && j > 0) {
                                                Sample.this.fireSomeHeaderValuesLoaded();
                                            } else if (j == fillValues.length - 1) {
                                                Sample.this.fireSomeHeaderValuesLoaded();
                                            }
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            fillValues[j] = 0.0;
                                            if (j % 10 == 0 && j > 0) {
                                                Sample.this.fireSomeHeaderValuesLoaded();
                                            } else if (j == fillValues.length - 1) {
                                                Sample.this.fireSomeHeaderValuesLoaded();
                                            }
                                        }
                                        catch (FabioFileException fabioFileException) {
                                            monitor.setCanceled(true);
                                        }
                                    }
                                });
                                monitor.worked(1);
                            }
                        }
                        ++it;
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        if (values == null || values.length != size) {
            values = new double[size];
            this.headerdiffValues.put(key, values);
            job.schedule();
        }
        return this.headerdiffValues.get(key);
    }

    public void setCurrentFile(FabioFile fabio) {
        this.currentFabioFile = fabio;
    }

    public FabioFile getCurrentFabioFile() {
        return this.currentFabioFile;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isShowInNavigator() {
        return this.showInNavigator;
    }

    public void setShowInNavigator(boolean showInNavigator) {
        this.showInNavigator = showInNavigator;
    }

    public void setValide(boolean b) {
        this.isValide = b;
    }

    private boolean createFile_SeriesForPython() {
        boolean evalOk = true;
        if (this.fableJep == null) {
            try {
                this.fableJep = new FableJep();
            }
            catch (JepException e) {
                e.printStackTrace();
            }
        }
        try {
            FableJep.jepImportModules(this.fableJep.getJep(), "sys");
            FableJep.jepImportModules(this.fableJep.getJep(), "numpy");
            FableJep.jepImportModules(this.fableJep.getJep(), "PIL");
            FableJep.jepImportModules(this.fableJep.getJep(), "fabio.file_series");
            this.fableJep.eval("from fabio.file_series import file_series");
            this.fableJep.eval("fileList = []");
            int i = 0;
            while (i < this.filteredfabiofiles.size()) {
                this.fableJep.set("file", this.filteredfabiofiles.elementAt(i).getFullFilename());
                this.fableJep.eval("fileList.append(file)");
                ++i;
            }
            evalOk = this.fableJep.eval("fileseries = file_series(fileList)");
        }
        catch (JepException e) {
            evalOk = false;
            e.printStackTrace();
        }
        return evalOk;
    }

    public String getStem() {
        int numberOfFiles;
        assert (this.filteredfabiofiles != null);
        if (this.stem == null && this.createFile_SeriesForPython() && (numberOfFiles = this.fableJep.getIntegerValue("len(fileseries)").intValue()) > 0) {
            this.stem = this.fableJep.getStringValue("fabio.deconstruct_filename(fileseries[0]).stem");
        }
        return this.stem;
    }

    public void updateFabioFiles(File[] files) throws FabioFileException {
        Vector oldFabioFiles = (Vector)this.fabioFiles.clone();
        this.fabioFiles.removeAllElements();
        int i = 0;
        while (files != null && i < files.length) {
            boolean fileFound = false;
            int fileFoundIndex = -1;
            int j = 0;
            while (j < this.currentFiles.length && !fileFound) {
                if (this.currentFiles[j].equalsIgnoreCase(files[i].getAbsolutePath()) && j < oldFabioFiles.size()) {
                    fileFound = true;
                    fileFoundIndex = j;
                }
                ++j;
            }
            FabioFile fabioFile = !fileFound ? new FabioFile(files[i].getAbsolutePath()) : (FabioFile)oldFabioFiles.elementAt(fileFoundIndex);
            this.addFabioFile(fabioFile);
            ++i;
        }
        this.currentFiles = new String[this.fabioFiles.size()];
        i = 0;
        while (this.fabioFiles != null && i < this.fabioFiles.size()) {
            this.currentFiles[i] = this.fabioFiles.elementAt(i).getFullFilename();
            ++i;
        }
        this.applyFilter();
        this.fireUpdatefiles();
    }

    public void setStem(String val) {
        this.stem = val;
    }
}

