/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.ExceptionMessageDialog;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SWTUtils {
    public static final String LS = System.getProperty("line.separator");

    public void errMsg(String msg) {
        SWTUtils.errMsg(null, msg);
    }

    public static void errMsg(Shell shell, String msg) {
        MessageDialog.openError((Shell)shell, (String)"Error", (String)msg);
    }

    public static void errMsgAsync(String msg) {
        SWTUtils.errMsgAsync(null, msg);
    }

    public static void errMsgAsync(final Shell shell, final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)shell, (String)"Error", (String)msg);
            }
        });
    }

    public void warnMsg(String msg) {
        SWTUtils.warnMsg(null, msg);
    }

    public static void warnMsg(Shell shell, String msg) {
        MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)msg);
    }

    public static void warnMsgAsync(String msg) {
        SWTUtils.warnMsgAsync(null, msg);
    }

    public static void warnMsgAsync(final Shell shell, final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)msg);
            }
        });
    }

    public void infoMsg(String msg) {
        SWTUtils.infoMsg(null, msg);
    }

    public static void infoMsg(Shell shell, String msg) {
        MessageDialog.openInformation((Shell)shell, (String)"Information", (String)msg);
    }

    public static void infoMsgAsync(String msg) {
        SWTUtils.infoMsgAsync(null, msg);
    }

    public static void infoMsgAsync(final Shell shell, final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)shell, (String)"Information", (String)msg);
            }
        });
    }

    public void excMsg(String msg, Exception ex) {
        SWTUtils.excMsg(null, msg, ex);
    }

    public static void excMsg(Shell shell, String msg, Exception ex) {
        String fullMsg = String.valueOf(msg) + LS + LS + "Exception: " + ex + LS + "Message: " + ex.getMessage();
        MessageDialog.openError((Shell)shell, (String)"Exception", (String)fullMsg);
    }

    public static void excMsgAsync(String msg, Exception ex) {
        SWTUtils.excMsgAsync(null, msg, ex);
    }

    public static void excMsgAsync(final Shell shell, String msg, Exception ex) {
        final String fullMsg = String.valueOf(msg) + LS + LS + "Exception: " + ex + LS + "Message: " + ex.getMessage();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)shell, (String)"Exception", (String)fullMsg);
            }
        });
    }

    public void excTraceMsg(String msg, Exception ex) {
        SWTUtils.excTraceMsg(null, msg, ex);
    }

    public static void excTraceMsg(Shell shell, String msg, Exception ex) {
        ExceptionMessageDialog.openException(shell, "Exception", msg, ex);
    }

    public static void excTraceMsgAsync(String msg, Exception ex) {
        SWTUtils.excTraceMsgAsync(null, msg, ex);
    }

    public static void excTraceMsgAsync(final Shell shell, final String msg, final Exception ex) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExceptionMessageDialog.openException(shell, "Exception", msg, ex);
            }
        });
    }

    public static String convertText(String string) {
        String delimiter = Text.DELIMITER;
        if (delimiter.equals(LS)) {
            return string;
        }
        String out = "";
        char lf = '\n';
        char cr = '\r';
        char prev = '\u0000';
        int len = string.length();
        int i = 0;
        while (i < len) {
            char chr = string.charAt(i);
            char val = chr;
            out = val != lf ? String.valueOf(out) + chr : (i > 0 ? ((prev = string.charAt(i - 1)) == cr ? String.valueOf(out) + chr : String.valueOf(out) + delimiter) : String.valueOf(out) + delimiter);
            ++i;
        }
        return out;
    }

    public void createFileFromIFile(IFile fileHandle, InputStream contents, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            IPath path = fileHandle.getFullPath();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int numSegments = path.segmentCount();
            if (numSegments > 2 && !root.getFolder(path.removeLastSegments(1)).exists()) {
                int i = numSegments - 2;
                while (i > 0) {
                    IFolder folder = root.getFolder(path.removeLastSegments(i));
                    if (!folder.exists()) {
                        folder.create(false, true, monitor);
                    }
                    --i;
                }
            }
            fileHandle.create(contents, false, monitor);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static void enableControlTree(Control control, boolean enabled) {
        if (control == null) {
            return;
        }
        if (control instanceof Composite) {
            Control[] controls;
            Composite composite = (Composite)control;
            Control[] controlArray = controls = composite.getChildren();
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control1 = controlArray[n2];
                SWTUtils.enableControlTree(control1, enabled);
                ++n2;
            }
        }
        control.setEnabled(enabled);
    }

    public static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    bufferedImage.setRGB(x, y, rgb.red << 16 | rgb.green << 8 | rgb.blue);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int rgb = bufferedImage.getRGB(x, y);
                    int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                    data.setPixel(x, y, pixel);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }
}

