/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.jep;

import fable.framework.jep.PythonInfo;
import fable.framework.views.FableMessageConsole;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import jep.Jep;
import jep.JepException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FableJep {
    private Jep jep;
    private static FableJep fablejep;
    private static String jepError;
    private static long jepLastError;
    private FableMessageConsole fableConsole;
    Logger logger;
    private static String filename;
    private static boolean bRecord;

    static {
        jepLastError = 0L;
        filename = "";
        bRecord = false;
    }

    public Jep getJep() {
        return this.jep;
    }

    public static FableJep getFableJep() throws JepException {
        if (fablejep == null) {
            fablejep = new FableJep();
        }
        return fablejep;
    }

    public FableJep() throws JepException {
        block7: {
            this.jep = null;
            this.fableConsole = null;
            try {
                this.jep = new Jep();
                FableJep.jepImportModules(this.jep, "sys");
                this.jep.eval("if not hasattr(sys,'argv'):\n\tsys.argv = ['jep']");
                this.logger = Logger.getLogger(FableJep.class);
                this.logger.setLevel(Level.ERROR);
            }
            catch (JepException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError e) {
                if (System.currentTimeMillis() - jepLastError <= 5000L) break block7;
                jepLastError = System.currentTimeMillis();
                String os = System.getProperty("os.name");
                if (os.toLowerCase().contains("windows")) {
                    jepError = "Failed to create the Java embedded Python interpreter (jep).";
                    jepError = String.valueOf(jepError) + "The error was :\n\n";
                    jepError = String.valueOf(jepError) + e.getMessage() + "\n\n";
                    jepError = String.valueOf(jepError) + "Make sure Python 2.5 is installed. ";
                    jepError = String.valueOf(jepError) + "You can (partially) test your environment by typing python";
                } else if (os.toLowerCase().contains("mac")) {
                    jepError = "Failed to create the Java embedded Python interpreter (jep).";
                    jepError = String.valueOf(jepError) + "The error was :\n\n";
                    jepError = String.valueOf(jepError) + e.getMessage() + "\n\n";
                    jepError = String.valueOf(jepError) + "Make sure Python 2.5 is installed and and that you have a ";
                    jepError = String.valueOf(jepError) + "symbolic link from $IMAGEVIEWER_HOME/plugins/jep_2.0.1/lib.macosx ";
                    jepError = String.valueOf(jepError) + "to /Library/Java/Extensions e.g.\n\n";
                    jepError = String.valueOf(jepError) + "sudo ln -s $IMAGEVIEWER_HOME/plugins/jep_2.0.1/lib/macosx/libjep.dylib   /Library/Java/Extensions/libjep.jnilib";
                } else {
                    jepError = "Failed to create the Java embedded Python interpreter (jep). ";
                    jepError = String.valueOf(jepError) + "The error was :\n\n";
                    jepError = String.valueOf(jepError) + e.getMessage() + "\n\n";
                    jepError = String.valueOf(jepError) + "Make sure Python 2.5 is installed and that the environment ";
                    jepError = String.valueOf(jepError) + "variable LD_PRELOAD is pointing to your Python shared object interpreter ";
                    jepError = String.valueOf(jepError) + "e.g. LD_PRELOAD=/usr/lib/libpython2.5.so.1.0. ";
                    jepError = String.valueOf(jepError) + "Your current LD_PRELOAD is :\n\n" + System.getenv("LD_PRELOAD") + "\n\n";
                    jepError = String.valueOf(jepError) + "You can (partially) test your environment by typing python ";
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)jepError);
                    }
                });
                jepLastError = System.currentTimeMillis();
            }
        }
    }

    public static void jepImportModules(Jep _jep, String _modules) throws JepException {
        try {
            _jep.eval("import " + _modules);
            FableJep.writeScript("import " + _modules);
        }
        catch (JepException e) {
            if (System.currentTimeMillis() - jepLastError > 5000L) {
                jepLastError = System.currentTimeMillis();
                String os = System.getProperty("os.name");
                jepError = "Failed to import the modules " + _modules + " into " + "the Java embedded Python interpreter (jep). ";
                jepError = String.valueOf(jepError) + "The error was :\n\n";
                jepError = String.valueOf(jepError) + e.getMessage() + "\n\n";
                if (os.toLowerCase().contains("windows")) {
                    jepError = String.valueOf(jepError) + "Make sure Python 2.5 is installed and jep.dll is in your PATH ";
                } else {
                    jepError = String.valueOf(jepError) + "Make sure Python 2.5 is installed and that the environment ";
                    jepError = String.valueOf(jepError) + "variable LD_PRELOAD is pointing to your Python shared object interpreter ";
                    jepError = String.valueOf(jepError) + "e.g. LD_PRELOAD=/usr/lib/libpython2.5.so.1.0. ";
                    jepError = String.valueOf(jepError) + "Your current LD_PRELOAD is :\n\n" + System.getenv("LD_PRELOAD") + "\n\n";
                }
                jepError = String.valueOf(jepError) + "and that the Python modules " + _modules + " are installed and in your PYTHONPATH. ";
                jepError = String.valueOf(jepError) + "Your current PYTHONPATH is :\n\n" + PythonInfo.getPythonPathFromEnvironment("  ") + "\n";
                jepError = String.valueOf(jepError) + "You can test your environment by starting python and then typing :\n\nimport " + _modules;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)jepError);
                        jepLastError = System.currentTimeMillis();
                    }
                });
            }
            throw e;
        }
    }

    public static void jepImportSpecificDefinition(Jep _jep, String _from, String _import) throws JepException {
        try {
            _jep.eval("from " + _from + " import " + _import);
            FableJep.writeScript("from " + _from + " import " + _import);
        }
        catch (JepException e) {
            if (System.currentTimeMillis() - jepLastError > 5000L) {
                jepLastError = System.currentTimeMillis();
                jepError = "Failed to import the modules " + _from + " into the" + " Java embedded Python interpreter (jep).";
                jepError = String.valueOf(jepError) + "The error was :\n\n";
                jepError = String.valueOf(jepError) + e.getMessage() + "\n\n";
                jepError = String.valueOf(jepError) + "Make sure Python 2.5 is installed and jep.dll is in your PATH and that the Python modules " + _from + " are installed and in your PYTHONPATH. ";
                jepError = String.valueOf(jepError) + "Your current PYTHONPATH is :\n\n" + PythonInfo.getPythonPathFromEnvironment("  ") + "\n";
                jepError = String.valueOf(jepError) + "You can test your environment by starting python and then typing :\n\nimport " + _from;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)jepError);
                        jepLastError = System.currentTimeMillis();
                    }
                });
                jepLastError = System.currentTimeMillis();
            }
            throw e;
        }
    }

    public boolean eval(String str) throws JepException {
        this.logger.info((Object)str);
        if (this.fableConsole != null) {
            this.fableConsole.displayIn(str);
        }
        FableJep.writeScript(str);
        boolean b = this.jep.eval(str);
        return b;
    }

    public void set(String str1, String str2) throws JepException {
        this.logger.info((Object)(String.valueOf(str1) + "= " + str2));
        FableJep.writeScript(String.valueOf(str1) + "= \"" + str2 + "\"");
        this.jep.set(str1, str2);
    }

    public void set(String str1, double dbl) throws JepException {
        this.logger.info((Object)(String.valueOf(str1) + "= " + dbl));
        FableJep.writeScript(String.valueOf(str1) + "= " + dbl);
        this.jep.set(str1, dbl);
    }

    public void set(String str1, int str2) throws JepException {
        this.logger.info((Object)(String.valueOf(str1) + "= \"" + str2 + "\""));
        FableJep.writeScript(String.valueOf(str1) + "= " + str2);
        this.jep.set(str1, str2);
    }

    public void set(String str, float f1) throws JepException {
        this.logger.info((Object)(String.valueOf(str) + "= " + f1));
        FableJep.writeScript(String.valueOf(str) + "= " + f1);
        this.jep.set(str, f1);
    }

    public Object getValue(String str) throws JepException {
        this.logger.info((Object)str);
        Object value = null;
        try {
            value = this.jep.getValue(str);
        }
        catch (JepException jepException) {
        }
        catch (Exception exception) {}
        return value;
    }

    public Integer getIntegerValue(String str) {
        Integer value = null;
        try {
            value = (Integer)this.jep.getValue("int(" + str + ")");
        }
        catch (JepException jepException) {
        }
        catch (Exception exception) {}
        return value;
    }

    public Float getFloatValue(String str) {
        Float value = null;
        try {
            value = (Float)this.jep.getValue("float(" + str + ")");
        }
        catch (JepException jepException) {
        }
        catch (Exception exception) {}
        return value;
    }

    public String getStringValue(String str) {
        String value = null;
        try {
            value = (String)this.jep.getValue(str);
        }
        catch (JepException jepException) {
        }
        catch (Exception exception) {}
        return value;
    }

    public float[] getValue_floatarray(String str) throws JepException {
        this.logger.info((Object)"getValue_floatarray");
        return this.jep.getValue_floatarray(str);
    }

    public void redirectStdout(String filename) throws JepException {
        this.set("filename", filename);
        this.jep.eval("logstdout=open(filename, 'w')");
        this.jep.eval("sys.stdout=logstdout");
        this.flushStdout();
    }

    public void flushStdout() throws JepException {
        this.jep.eval("sys.stdout.flush()");
    }

    public void outputConsole(FableMessageConsole console) {
        this.fableConsole = console;
    }

    private static void writeScript(String addline) {
        if (bRecord) {
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(filename, true));
                out.write(addline);
                out.newLine();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void record(boolean b) {
        bRecord = b;
    }

    public static void setScriptFileName(String name) {
        filename = name;
    }
}

