/*
 * Decompiled with CFR 0.152.
 */
package fable.polyxsim.internal;

import fable.framework.jep.FableJep;
import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.views.FableMessageConsole;
import fable.polyxsim.views.PolyXSimInputView;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import jep.Jep;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class PolyXSim
implements IPropertyChangeListener {
    private static PolyXSimThread polyXSimThread;
    private IProgressMonitor polyXSimMonitor;
    ArrayList<IPropertyChangeListener> myListeners = new ArrayList();
    private static FableJep jep;
    private static String inputFileName;
    private static float wavelength;
    private static Float distance;
    private static Float polarisationFactor;
    private static Float polarisationDirection;
    private static Float detyCenter;
    private static Float detzCenter;
    private static Float ySize;
    private static Float zSize;
    private static Float detySize;
    private static Float detzSize;
    private static Float omegaStart;
    private static Float omegaEnd;
    private static Float omegaStep;
    private static Float thetaMin;
    private static Float thetaMax;
    private static Integer[] detOrientation;
    private static Integer numGrains;
    private static Integer numPhases;
    private static Integer[] phases;
    private static Integer[] phaseGrains;
    private static Float grainSize;
    private static Float grainMinSize;
    private static Float grainMaxSize;
    private static Integer genGrainOrientation;
    private static Integer genGrainPosition;
    private static Float[] sampleXYZ;
    private static Float[] unitCellA;
    private static Float[] unitCellB;
    private static Float[] unitCellC;
    private static Float[] unitCellAlpha;
    private static Float[] unitCellBeta;
    private static Float[] unitCellGamma;
    private static Integer[] unitCellSpaceGroup;
    private static Integer makeImages;
    private static String prefix;
    private static String format;
    private static Float flux;
    private static Integer noise;
    private static Integer background;
    private static Integer psf;
    private static Integer peakShape;
    private static Float detTiltX;
    private static Float detTiltY;
    private static Float detTiltZ;
    private static String[] structureFile;
    private static boolean outputFlt;
    private static boolean outputGve;
    private static boolean outputUbi;
    private static boolean outputPar;
    private StdoutReaderThread stdoutThread;
    private String killFile = ".polyxsim.killfile";
    static Logger logger;
    static File tempFile;
    private static float wedge;
    private static float mosaicity;
    private static Float intensityConstant;
    private static boolean polarisation;
    private static boolean lorentzFactor;
    private static String inputDirectory;
    private static String outputDirectory;
    private static Float[] peakParameters;
    private static Integer omegaSign;
    private static Float[] phaseGrainSize;
    private static Float[] phaseGrainMinSize;
    private static Float[] phaseGrainMaxSize;
    boolean runStatus = false;
    boolean jobCanceled = false;

    static {
        jep = null;
        detOrientation = new Integer[4];
        numGrains = 0;
        numPhases = 0;
        phases = null;
        phaseGrains = null;
        sampleXYZ = new Float[6];
        unitCellA = null;
        unitCellB = null;
        unitCellC = null;
        unitCellAlpha = null;
        unitCellBeta = null;
        unitCellGamma = null;
        unitCellSpaceGroup = null;
        format = "edf";
        structureFile = null;
        outputFlt = false;
        outputGve = false;
        outputUbi = false;
        outputPar = false;
        peakParameters = new Float[2];
        phaseGrainSize = null;
        phaseGrainMinSize = null;
        phaseGrainMaxSize = null;
    }

    public PolyXSim() {
        polyXSimThread = new PolyXSimThread();
        logger = Logger.getLogger(PolyXSim.class);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.myListeners.remove(listener);
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void fireProperty(String property) {
        for (IPropertyChangeListener element : this.myListeners) {
            element.propertyChange(new PropertyChangeEvent((Object)this, "polyxsim", null, (Object)property));
        }
    }

    public static boolean loadInputFile(String _inputFileName) {
        inputFileName = _inputFileName;
        try {
            jep = new FableJep();
            jep.outputConsole(FableMessageConsole.console);
            FableJep.jepImportModules((Jep)jep.getJep(), (String)"sys,os");
            FableJep.jepImportModules((Jep)jep.getJep(), (String)"CifFile");
            FableJep.jepImportModules((Jep)jep.getJep(), (String)"ImageD11");
            FableJep.jepImportModules((Jep)jep.getJep(), (String)"polyxsim");
            try {
                jep.eval("from polyxsim import check_input");
            }
            catch (JepException jepException) {}
            jep.eval("from polyxsim import check_input");
            jep.set("sim_filename", inputFileName);
            String currentDirectory = inputDirectory.replaceAll("\\\\", "/");
            jep.eval("os.chdir(\"" + currentDirectory + "\")");
            jep.eval("myinput = check_input.parse_input(input_file=sim_filename)");
            jep.eval("myinput.read()");
            jep.eval("myinput.check()");
            jep.eval("myinput.initialize()");
            jep.eval("print myinput.param");
            jep.eval("print myinput.param['gen_phase']");
            wavelength = jep.getFloatValue("myinput.param['wavelength']").floatValue();
            flux = jep.getFloatValue("myinput.param['beamflux']");
            distance = jep.getFloatValue("myinput.param['distance']");
            intensityConstant = jep.getFloatValue("myinput.param['intensity_const']");
            polarisation = false;
            if (jep.getIntegerValue("myinput.param['beampol_apply']") != null && jep.getIntegerValue("myinput.param['beampol_apply']") == 1) {
                polarisation = true;
            }
            lorentzFactor = false;
            if (jep.getIntegerValue("myinput.param['lorentz_apply']") != null && jep.getIntegerValue("myinput.param['lorentz_apply']") == 1) {
                lorentzFactor = true;
            }
            polarisationFactor = jep.getFloatValue("myinput.param['beampol_factor']");
            polarisationFactor = jep.getFloatValue("myinput.param['beampol_factor']");
            polarisationDirection = jep.getFloatValue("myinput.param['beampol_direct']");
            detyCenter = jep.getFloatValue("myinput.param['dety_center']");
            detzCenter = jep.getFloatValue("myinput.param['detz_center']");
            ySize = jep.getFloatValue("myinput.param['y_size']");
            zSize = jep.getFloatValue("myinput.param['z_size']");
            detySize = jep.getFloatValue("myinput.param['dety_size']");
            detzSize = jep.getFloatValue("myinput.param['detz_size']");
            detTiltX = jep.getFloatValue("myinput.param['tilt_x']");
            detTiltY = jep.getFloatValue("myinput.param['tilt_y']");
            detTiltZ = jep.getFloatValue("myinput.param['tilt_z']");
            detTiltZ = jep.getFloatValue("myinput.param['tilt_z']");
            PolyXSim.detOrientation[0] = jep.getIntegerValue("myinput.param['o11']");
            PolyXSim.detOrientation[1] = jep.getIntegerValue("myinput.param['o12']");
            PolyXSim.detOrientation[2] = jep.getIntegerValue("myinput.param['o21']");
            PolyXSim.detOrientation[3] = jep.getIntegerValue("myinput.param['o22']");
            wedge = jep.getFloatValue("myinput.param['wedge']").floatValue();
            omegaStart = jep.getFloatValue("myinput.param['omega_start']");
            omegaEnd = jep.getFloatValue("myinput.param['omega_end']");
            omegaStep = jep.getFloatValue("myinput.param['omega_step']");
            omegaSign = jep.getIntegerValue("myinput.param['omega_sign']");
            numPhases = jep.getIntegerValue("myinput.param['no_phases']");
            numGrains = jep.getIntegerValue("myinput.param['no_grains']");
            genGrainOrientation = jep.getIntegerValue("myinput.param['gen_U']");
            genGrainPosition = jep.getIntegerValue("myinput.param['gen_pos'][0]");
            int i = 0;
            while (i < 3) {
                PolyXSim.sampleXYZ[i] = jep.getFloatValue("myinput.param['sample_xyz'][" + i + "]");
                ++i;
            }
            makeImages = jep.getIntegerValue("myinput.param['make_image']");
            outputDirectory = (String)jep.getValue("myinput.param['direc']");
            String os = System.getProperty("os.name");
            if (os.toLowerCase().contains("windows")) {
                if (outputDirectory.indexOf(":") == -1) {
                    outputDirectory = String.valueOf(inputDirectory) + File.separator + outputDirectory;
                }
            } else if (!outputDirectory.startsWith(File.separator)) {
                outputDirectory = String.valueOf(inputDirectory) + File.separator + outputDirectory;
            }
            prefix = (String)jep.getValue("myinput.param['stem']");
            noise = jep.getIntegerValue("myinput.param['noise']");
            background = jep.getIntegerValue("myinput.param['bg']");
            psf = jep.getIntegerValue("myinput.param['psf']");
            peakShape = jep.getIntegerValue("myinput.param['peakshape'][0]");
            PolyXSim.peakParameters[0] = jep.getFloatValue("myinput.param['peakshape'][1]");
            PolyXSim.peakParameters[1] = jep.getFloatValue("myinput.param['peakshape'][2]");
            grainSize = jep.getFloatValue("myinput.param['gen_size'][1]");
            grainMinSize = jep.getFloatValue("float(myinput.param['gen_size'][2])");
            grainMaxSize = jep.getFloatValue("myinput.param['gen_size'][3]");
            phases = new Integer[numPhases.intValue()];
            phaseGrains = new Integer[numPhases.intValue()];
            phaseGrainSize = new Float[numPhases.intValue()];
            phaseGrainMinSize = new Float[numPhases.intValue()];
            phaseGrainMaxSize = new Float[numPhases.intValue()];
            structureFile = new String[numPhases.intValue()];
            int i2 = 0;
            while (i2 < numPhases) {
                int phaseIndex = 1 + i2 * 2;
                PolyXSim.phases[i2] = jep.getIntegerValue("myinput.param['gen_phase'][" + phaseIndex + "]");
                PolyXSim.phaseGrains[i2] = jep.getIntegerValue("myinput.param['gen_phase'][" + ++phaseIndex + "]");
                PolyXSim.phaseGrainSize[i2] = jep.getFloatValue("myinput.param['gen_size_phase_" + i2 + "'][1]");
                PolyXSim.phaseGrainMinSize[i2] = jep.getFloatValue("myinput.param['gen_size_phase_" + i2 + "'][2]");
                PolyXSim.phaseGrainMaxSize[i2] = jep.getFloatValue("myinput.param['gen_size_phase_" + i2 + "'][3]");
                PolyXSim.structureFile[i2] = jep.getStringValue("myinput.param['structure_phase_" + i2 + "']");
                ++i2;
            }
        }
        catch (JepException e) {
            e.printStackTrace();
            return false;
        }
        unitCellA = new Float[numPhases.intValue()];
        unitCellB = new Float[numPhases.intValue()];
        unitCellC = new Float[numPhases.intValue()];
        unitCellAlpha = new Float[numPhases.intValue()];
        unitCellBeta = new Float[numPhases.intValue()];
        unitCellGamma = new Float[numPhases.intValue()];
        unitCellSpaceGroup = new Integer[numPhases.intValue()];
        int i = 0;
        while (i < numPhases) {
            PolyXSim.unitCellA[i] = jep.getFloatValue("myinput.param['unit_cell_phase_" + i + "'][0]");
            PolyXSim.unitCellB[i] = jep.getFloatValue("myinput.param['unit_cell_phase_" + i + "'][1]");
            PolyXSim.unitCellC[i] = jep.getFloatValue("myinput.param['unit_cell_phase_" + i + "'][2]");
            PolyXSim.unitCellAlpha[i] = jep.getFloatValue("myinput.param['unit_cell_phase_" + i + "'][3]");
            PolyXSim.unitCellBeta[i] = jep.getFloatValue("myinput.param['unit_cell_phase_" + i + "'][4]");
            PolyXSim.unitCellGamma[i] = jep.getFloatValue("myinput.param['unit_cell_phase_" + i + "'][5]");
            PolyXSim.unitCellSpaceGroup[i] = jep.getIntegerValue("myinput.param['sgno_phase_" + i + "']");
            logger.debug((Object)("unit cell space group no " + unitCellSpaceGroup[i]));
            ++i;
        }
        try {
            int outFiles = jep.getIntegerValue("len(myinput.param['output'])");
            logger.debug((Object)("outFiles " + outFiles));
            int i3 = 0;
            while (i3 < outFiles) {
                if (((String)jep.getValue("myinput.param['output'][" + i3 + "]")).endsWith("tif")) {
                    format = "tif";
                }
                if (((String)jep.getValue("myinput.param['output'][" + i3 + "]")).endsWith("tif16bit")) {
                    format = "tif16bit";
                }
                if (((String)jep.getValue("myinput.param['output'][" + i3 + "]")).endsWith("edf")) {
                    format = "edf";
                }
                if (((String)jep.getValue("myinput.param['output'][" + i3 + "]")).endsWith("flt")) {
                    outputFlt = true;
                }
                if (((String)jep.getValue("myinput.param['output'][" + i3 + "]")).endsWith("gve")) {
                    outputGve = true;
                }
                if (((String)jep.getValue("myinput.param['output'][" + i3 + "]")).endsWith("ubi")) {
                    outputUbi = true;
                }
                if (((String)jep.getValue("myinput.param['output'][" + i3 + "]")).endsWith("par")) {
                    outputPar = true;
                }
                ++i3;
            }
        }
        catch (JepException jepException) {}
        return true;
    }

    public void run() {
        Job job = new Job("Running PolyXSim "){

            protected IStatus run(IProgressMonitor monitor) {
                String fileName = inputFileName;
                if (inputFileName != null && !inputFileName.equals("")) {
                    if (inputFileName.lastIndexOf(File.separatorChar) != -1) {
                        fileName = inputFileName.substring(inputFileName.lastIndexOf(File.separatorChar) + 1);
                    }
                    PolyXSim.this.polyXSimMonitor = monitor;
                    PolyXSim.this.polyXSimMonitor.beginTask("Running PolyXSim " + fileName + " ... ", 150);
                    polyXSimThread.run();
                    PolyXSim.this.polyXSimMonitor.done();
                    return Status.OK_STATUS;
                }
                FableMessageConsole.console.displayError("no input file specified - run aborted");
                return Status.CANCEL_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (PolyXSim.this.runStatus) {
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayOut(String.valueOf(event.getJob().getName()) + " completed successfully");
                    }
                    if (makeImages == 1 && !Display.getDefault().isDisposed()) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                PolyXSim.this.openImageViewer(outputDirectory);
                            }
                        });
                    }
                } else if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayOut(String.valueOf(event.getJob().getName()) + " did not complete successfully !");
                    if (!PolyXSim.this.jobCanceled) {
                        FableMessageConsole.console.displayOut(" Please check input file " + inputFileName);
                    }
                }
            }
        });
    }

    protected void openImageViewer(String directory) {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            activeWindow.getWorkbench().showPerspective("fable.imageviewer.perspective", activeWindow);
            SampleNavigatorView sampleView = (SampleNavigatorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("fable.framework.navigator.views.SampleNavigatorViewid");
            sampleView.addDirectory(directory);
        }
        catch (WorkbenchException workbenchException) {
            MessageDialog.openError((Shell)activeWindow.getShell(), (String)"Polyxsim", (String)"ImageViewer cannot be opened");
        }
    }

    public static void updateValues(FableJep jep) {
        if (!Display.getDefault().isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    PolyXSimInputView.setInputValues();
                }
            });
        }
        try {
            logger.trace((Object)("noGrains = " + numGrains));
            jep.eval("myinput.param['no_grains']=" + numGrains);
            jep.eval("myinput.param['wavelength']=" + wavelength);
            jep.eval("myinput.param['beamflux']=" + flux);
            if (polarisation) {
                jep.eval("myinput.param['beampol_factor']=1");
            } else {
                jep.eval("myinput.param['beampol_factor']=0");
            }
            if (lorentzFactor) {
                jep.eval("myinput.param['lorentz_factor']=1");
            } else {
                jep.eval("myinput.param['lorentz_factor']=0");
            }
            jep.eval("myinput.param['beampol_factor']=" + polarisationFactor);
            jep.eval("myinput.param['beampol_direct']=" + polarisationDirection);
            jep.eval("myinput.param['wavelength']=" + wavelength);
            jep.eval("myinput.param['distance']=" + distance);
            jep.eval("myinput.param['dety_center']=" + detyCenter);
            jep.eval("myinput.param['detz_center']=" + detzCenter);
            jep.eval("myinput.param['y_size']=" + ySize);
            jep.eval("myinput.param['z_size']=" + zSize);
            jep.eval("myinput.param['dety_size']=" + detySize);
            jep.eval("myinput.param['detz_size']=" + detzSize);
            jep.eval("myinput.param['tilt_x']=" + detTiltX);
            jep.eval("myinput.param['tilt_y']=" + detTiltY);
            jep.eval("myinput.param['tilt_z']=" + detTiltZ);
            if (detOrientation[0] != null) {
                jep.eval("myinput.param['o11']=" + detOrientation[0]);
            }
            if (detOrientation[1] != null) {
                jep.eval("myinput.param['o12']=" + detOrientation[1]);
            }
            if (detOrientation[2] != null) {
                jep.eval("myinput.param['o21']=" + detOrientation[2]);
            }
            if (detOrientation[3] != null) {
                jep.eval("myinput.param['o22']=" + detOrientation[3]);
            }
            jep.eval("myinput.param['wedge']=" + wedge);
            jep.eval("myinput.param['omega_start']=" + omegaStart);
            jep.eval("myinput.param['omega_end']=" + omegaEnd);
            jep.eval("myinput.param['omega_step']=" + omegaStep);
            jep.eval("myinput.param['no_phases']=" + numPhases);
            jep.eval("myinput.param['no_grains']=" + numGrains);
            if (genGrainOrientation == 1) {
                jep.eval("myinput.param['gen_size'][1]=" + grainSize);
                jep.eval("myinput.param['gen_size'][2]=" + grainMinSize);
                jep.eval("myinput.param['gen_size'][3]=" + grainMaxSize);
            }
            int i = 0;
            while (i < 3) {
                if (sampleXYZ[i] != null) {
                    jep.eval("myinput.param['sample_xyz'][" + i + "]=" + sampleXYZ[i]);
                }
                ++i;
            }
            i = 0;
            while (i < numPhases) {
                int phaseIndex = 2 + i * 2;
                jep.eval("myinput.param['gen_phase'][" + phaseIndex + "]=" + phaseGrains[i]);
                jep.eval("myinput.param['no_grains_phase_" + i + "']=" + phaseGrains[i]);
                String evalString = "myinput.param['gen_size_phase_" + i + "'][2]=" + phaseGrainMinSize[i];
                evalString = "myinput.param['gen_size_phase_" + i + "'][3]=" + phaseGrainMaxSize[i];
                evalString = "myinput.param['gen_size_phase_" + i + "'][1]=" + phaseGrainSize[i];
                if (i < unitCellA.length) {
                    if (unitCellA[i] != null) {
                        evalString = "myinput.param['unit_cell_phase_" + i + "'][0]=" + unitCellA[i];
                        jep.eval(evalString);
                    }
                    if (unitCellB[i] != null) {
                        evalString = "myinput.param['unit_cell_phase_" + i + "'][1]=" + unitCellB[i];
                        jep.eval(evalString);
                    }
                    if (unitCellC[i] != null) {
                        evalString = "myinput.param['unit_cell_phase_" + i + "'][2]=" + unitCellC[i];
                        jep.eval(evalString);
                    }
                    if (unitCellAlpha[i] != null) {
                        evalString = "myinput.param['unit_cell_phase_" + i + "'][3]=" + unitCellAlpha[i];
                        jep.eval(evalString);
                    }
                    if (unitCellBeta[i] != null) {
                        evalString = "myinput.param['unit_cell_phase_" + i + "'][4]=" + unitCellBeta[i];
                        jep.eval(evalString);
                    }
                    if (unitCellGamma[i] != null) {
                        evalString = "myinput.param['unit_cell_phase_" + i + "'][5]=" + unitCellGamma[i];
                        jep.eval(evalString);
                    }
                    if (unitCellSpaceGroup[i] != null) {
                        evalString = "myinput.param['sgno_phase_" + i + "']=" + unitCellSpaceGroup[i];
                        jep.eval(evalString);
                    }
                }
                ++i;
            }
            jep.eval("myinput.param['make_image']=" + makeImages);
            String tempOutputDirectory = outputDirectory.replaceAll("\\\\", "/");
            jep.eval("myinput.param['direc']='" + tempOutputDirectory + "'");
            jep.eval("myinput.param['stem']='" + prefix + "'");
            jep.eval("myinput.param['noise']=" + noise);
            jep.eval("myinput.param['bg']=" + background);
            jep.eval("myinput.param['psf']=" + psf);
            jep.eval("myinput.param['peakshape'][0]=" + peakShape);
            if (peakParameters[0] != null) {
                jep.eval("myinput.param['peakshape'][1]=" + peakParameters[0]);
            }
            if (peakParameters[1] != null) {
                jep.eval("myinput.param['peakshape'][2]=" + peakParameters[1]);
            }
            int i2 = 0;
            while (i2 < numPhases) {
                if (i2 < structureFile.length && structureFile[i2] != null) {
                    jep.eval("myinput.param['structure_phase_" + i2 + "']='" + structureFile[i2] + "'");
                }
                ++i2;
            }
            jep.eval("myinput.param['make_image']=" + makeImages);
            String output = "'" + format + "'";
            if (outputFlt || outputGve || outputUbi || outputPar) {
                if (outputFlt) {
                    output = String.valueOf(output) + ",'.flt'";
                }
                if (outputGve) {
                    output = String.valueOf(output) + ",'.gve'";
                }
                if (outputUbi) {
                    output = String.valueOf(output) + ",'.ubi'";
                }
                if (outputPar) {
                    output = String.valueOf(output) + ",'.par'";
                }
            }
            jep.eval("myinput.param['output']=[" + output + "]");
            if (format.startsWith("tif")) {
                jep.eval("myinput.param['format']='.tif'");
            } else {
                jep.eval("myinput.param['format']='" + format + "'");
            }
        }
        catch (JepException e) {
            e.printStackTrace();
        }
    }

    public static String getFileName() {
        return inputFileName;
    }

    public static float getWavelength() {
        return wavelength;
    }

    public static void setWavelength(float value) {
        wavelength = value;
    }

    public static Float getFlux() {
        return flux;
    }

    public static void setFlux(float value) {
        flux = Float.valueOf(value);
    }

    public static Float getDistance() {
        return distance;
    }

    public static void setDistance(float value) {
        distance = Float.valueOf(value);
    }

    public static Float getDetyCenter() {
        return detyCenter;
    }

    public static void setDetyCenter(float value) {
        detyCenter = Float.valueOf(value);
    }

    public static Float getDetzCenter() {
        return detzCenter;
    }

    public static void setDetzCenter(float value) {
        detzCenter = Float.valueOf(value);
    }

    public static Float getYSize() {
        return ySize;
    }

    public static void setYSize(float value) {
        ySize = Float.valueOf(value);
    }

    public static Float getZSize() {
        return zSize;
    }

    public static void setZSize(float value) {
        zSize = Float.valueOf(value);
    }

    public static Float getDetySize() {
        return detySize;
    }

    public static void setDetySize(float value) {
        detySize = Float.valueOf(value);
    }

    public static Float getDetzSize() {
        return detzSize;
    }

    public static void setDetzSize(float value) {
        detzSize = Float.valueOf(value);
    }

    public static Float getOmegaStart() {
        return omegaStart;
    }

    public static void setOmegaStart(float value) {
        omegaStart = Float.valueOf(value);
    }

    public static Float getOmegaEnd() {
        return omegaEnd;
    }

    public static void setOmegaEnd(float value) {
        omegaEnd = Float.valueOf(value);
    }

    public static Integer getOmegaSign() {
        return omegaSign;
    }

    public static void setOmegaSign(int value) {
        omegaSign = value;
    }

    public static Float getOmegaStep() {
        return omegaStep;
    }

    public static void setOmegaStep(float value) {
        omegaStep = Float.valueOf(value);
    }

    public static Float getDetTiltX() {
        return detTiltX;
    }

    public static void setDetTiltX(float value) {
        detTiltX = Float.valueOf(value);
    }

    public static Float getDetTiltY() {
        return detTiltY;
    }

    public static void setDetTiltY(float value) {
        detTiltY = Float.valueOf(value);
    }

    public static Float getDetTiltZ() {
        return detTiltZ;
    }

    public static void setDetTiltZ(float value) {
        detTiltZ = Float.valueOf(value);
    }

    public static Float getThetaMin() {
        return thetaMin;
    }

    public static void setThetaMin(float value) {
        thetaMin = Float.valueOf(value);
    }

    public static Float getThetaMax() {
        return thetaMax;
    }

    public static void setThetaMax(float value) {
        thetaMax = Float.valueOf(value);
    }

    public static Integer getNoGrains() {
        return numGrains;
    }

    public static void setNoGrains(int value) {
        numGrains = value;
    }

    public static Float getGrainSize() {
        return grainSize;
    }

    public static void setGrainSize(float value) {
        grainSize = Float.valueOf(value);
    }

    public static Float getGrainMinSize() {
        return grainMinSize;
    }

    public static void setGrainMinSize(float value) {
        grainMinSize = Float.valueOf(value);
    }

    public static Float getGrainMaxSize() {
        return grainMaxSize;
    }

    public static void setGrainMaxSize(float value) {
        grainMaxSize = Float.valueOf(value);
    }

    public static Float[] getSampleXyz() {
        return sampleXYZ;
    }

    public static void setSampleXyz(Float[] array) {
        sampleXYZ = array;
    }

    public static Float[] getUnitCellA() {
        return unitCellA;
    }

    public static void setUnitCellA(Float[] array) {
        unitCellA = array;
    }

    public static Float[] getUnitCellB() {
        return unitCellB;
    }

    public static void setUnitCellB(Float[] array) {
        unitCellB = array;
    }

    public static Float[] getUnitCellC() {
        return unitCellC;
    }

    public static void setUnitCellC(Float[] array) {
        unitCellC = array;
    }

    public static Float[] getUnitCellAlpha() {
        return unitCellAlpha;
    }

    public static void setUnitCellAlpha(Float[] array) {
        unitCellAlpha = array;
    }

    public static Float[] getUnitCellBeta() {
        return unitCellBeta;
    }

    public static void setUnitCellBeta(Float[] array) {
        unitCellBeta = array;
    }

    public static Float[] getUnitCellGamma() {
        return unitCellGamma;
    }

    public static void setUnitCellGamma(Float[] array) {
        unitCellGamma = array;
    }

    public static Integer[] getUnitCellSpaceGroup() {
        return unitCellSpaceGroup;
    }

    public static void setUnitCellSpaceGroup(Integer[] array) {
        unitCellSpaceGroup = array;
    }

    public static String getStructureFile(int i) {
        return structureFile[i];
    }

    public static void setStructureFile(String file, int i) {
        PolyXSim.structureFile[i] = file;
    }

    public static Integer getMakeImages() {
        return makeImages;
    }

    public static void setMakeImages(int value) {
        makeImages = value;
    }

    public static String getOutputDirectory() {
        return outputDirectory;
    }

    public static void setOutputDirectory(String file) {
        outputDirectory = file.replaceAll("\\\\", "/");
    }

    public static String getPrefix() {
        return prefix;
    }

    public static void setPrefix(String file) {
        prefix = file;
    }

    public static String getFormat() {
        return format;
    }

    public static void setFormat(String value) {
        format = value;
    }

    public static Integer getNoise() {
        return noise;
    }

    public static void setNoise(int value) {
        noise = value;
    }

    public static Integer getBackground() {
        return background;
    }

    public static void setBackground(int value) {
        background = value;
    }

    public static Integer getPsf() {
        return psf;
    }

    public static void setPsf(int value) {
        psf = value;
    }

    public static Integer getPeakShape() {
        return peakShape;
    }

    public static void setPeakShape(int value) {
        peakShape = value;
    }

    public static int getGenGrainOrientation() {
        return genGrainOrientation;
    }

    public static void setGenGrainOrientation(int value) {
        genGrainOrientation = value;
    }

    public static int getGenGrainPosition() {
        return genGrainPosition;
    }

    public static void setGenGrainPosition(int value) {
        genGrainPosition = value;
    }

    public static boolean getOutputFlt() {
        return outputFlt;
    }

    public static void setOutputFlt(boolean flt) {
        outputFlt = flt;
    }

    public static boolean getOutputGve() {
        return outputGve;
    }

    public static void setOutputGve(boolean gve) {
        outputGve = gve;
    }

    public static boolean getOutputUbi() {
        return outputUbi;
    }

    public static void setOutputUbi(boolean ubi) {
        outputUbi = ubi;
    }

    public static boolean getOutputPar() {
        return outputPar;
    }

    public static void setOutputPar(boolean par) {
        outputPar = par;
    }

    public static int getNumPhases() {
        return numPhases;
    }

    public static void setWedge(float value) {
        wedge = value;
    }

    public static float getWedge() {
        return wedge;
    }

    public static float getPolarisationFactor() {
        return polarisationFactor.floatValue();
    }

    public static float getPolarisationDirection() {
        return polarisationDirection.floatValue();
    }

    public static void setPolarisationFactor(float value) {
        polarisationFactor = Float.valueOf(value);
    }

    public static void setPolarisationDirection(float value) {
        polarisationDirection = Float.valueOf(value);
    }

    public static float getMosaicity() {
        return mosaicity;
    }

    public static void setMosaicity(float value) {
        mosaicity = value;
    }

    public static Float getIntensityConstant() {
        return intensityConstant;
    }

    public static void setIntensityConstant(Float value) {
        intensityConstant = value;
    }

    public static boolean getPolarisation() {
        return polarisation;
    }

    public static void setPolarisation(boolean value) {
        polarisation = value;
    }

    public static boolean getLorentzFactor() {
        return lorentzFactor;
    }

    public static void setLorentzFactor(boolean value) {
        lorentzFactor = value;
    }

    public static void setInputFileDirectory(String value) {
        inputDirectory = value;
    }

    public static void setNumPhases(int value) {
        numPhases = value;
    }

    public static Integer[] getDetOrientation() {
        return detOrientation;
    }

    public static void setDetOrientation(Integer[] value) {
        int i = 0;
        while (i < 4) {
            PolyXSim.detOrientation[i] = value[i];
            ++i;
        }
    }

    public static Float[] getPeakParameters() {
        return peakParameters;
    }

    public static void setPeakParameters(Float[] value) {
        PolyXSim.peakParameters[0] = value[0];
        PolyXSim.peakParameters[1] = value[1];
    }

    public static Integer[] getPhaseGrains() {
        return phaseGrains;
    }

    public static void setPhaseGrains(Integer[] value) {
        phaseGrains = new Integer[value.length];
        int i = 0;
        while (i < value.length) {
            PolyXSim.phaseGrains[i] = value[i];
            ++i;
        }
    }

    public static Integer[] getPhases() {
        return phases;
    }

    public static void setPhases(Integer[] value) {
        phases = new Integer[value.length];
        int i = 0;
        while (i < value.length) {
            PolyXSim.phases[i] = value[i];
            ++i;
        }
    }

    public static Float[] getPhaseGrainSize() {
        return phaseGrainSize;
    }

    public static void setPhaseGrainSize(Float[] value) {
        phaseGrainSize = value;
    }

    public static Float[] getPhaseGrainMinSize() {
        return phaseGrainMinSize;
    }

    public static void setPhaseGrainMinSize(Float[] value) {
        phaseGrainMinSize = value;
    }

    public static Float[] getPhaseGrainMaxSize() {
        return phaseGrainMaxSize;
    }

    public static void setPhaseGrainMaxSize(Float[] value) {
        phaseGrainMaxSize = value;
    }

    class PolyXSimThread
    implements Runnable {
        String outputMessage;

        PolyXSimThread() {
        }

        @Override
        public void run() {
            this.setCursor(1);
            PolyXSim.this.jobCanceled = false;
            try {
                jep = new FableJep();
                jep.outputConsole(FableMessageConsole.console);
                FableJep.jepImportModules((Jep)jep.getJep(), (String)"sys,os");
                FableJep.jepImportModules((Jep)jep.getJep(), (String)"CifFile");
                FableJep.jepImportModules((Jep)jep.getJep(), (String)"ImageD11");
                FableJep.jepImportModules((Jep)jep.getJep(), (String)"polyxsim");
                try {
                    jep.eval("from polyxsim import check_input");
                }
                catch (JepException jepException) {}
                try {
                    jep.eval("from polyxsim import find_refl");
                }
                catch (JepException jepException) {}
                try {
                    jep.eval("from polyxsim import generate_grains");
                }
                catch (JepException jepException) {}
                try {
                    jep.eval("from polyxsim import make_image");
                }
                catch (JepException jepException) {}
                try {
                    jep.eval("from polyxsim import make_imagestack");
                }
                catch (JepException jepException) {}
                try {
                    jep.eval("from polyxsim import reflections");
                }
                catch (JepException jepException) {}
                try {
                    jep.eval("from polyxsim import file_io");
                }
                catch (JepException jepException) {}
                jep.eval("from polyxsim import check_input");
                jep.eval("from polyxsim import find_refl");
                jep.eval("from polyxsim import generate_grains");
                jep.eval("from polyxsim import make_image");
                jep.eval("from polyxsim import make_imagestack");
                jep.eval("from polyxsim import reflections");
                jep.eval("from polyxsim import file_io");
                jep.eval("from optparse import OptionParser");
                tempFile = File.createTempFile("polyxsim", ".stdout");
                tempFile.deleteOnExit();
                logger.debug((Object)("tempFile = " + tempFile.getAbsolutePath()));
                PolyXSim.this.killFile = tempFile.getAbsolutePath().replaceAll("stdout", "kill");
                logger.debug((Object)("killFile = " + PolyXSim.this.killFile));
                jep.redirectStdout(tempFile.getAbsolutePath());
                String currentDirectory = inputDirectory.replaceAll("\\\\", "/");
                jep.eval("os.chdir(\"" + currentDirectory + "\")");
                jep.set("sim_filename", inputFileName);
                PolyXSim.this.stdoutThread = new StdoutReaderThread(tempFile.getAbsolutePath());
                PolyXSim.this.stdoutThread.start();
                jep.eval("myinput = check_input.parse_input(input_file=sim_filename)");
                if (this.updateMonitorStatus("Read input", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("read input");
                jep.eval("myinput.read()");
                PolyXSim.updateValues(jep);
                if (this.updateMonitorStatus("Check input", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("check input");
                jep.eval("myinput.check()");
                if (this.updateMonitorStatus("Initialise", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("initialise");
                jep.eval("myinput.initialize()");
                if (this.updateMonitorStatus("Generate grains", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("generate reflections");
                jep.eval("hkl = []");
                jep.eval("print myinput.param['phase_list']");
                int i = 0;
                while (i < numPhases) {
                    jep.eval("phase = " + i);
                    jep.eval("print 'phase = ',phase");
                    if (jep.getValue("myinput.param['structure_phase_" + i + "']") != null) {
                        jep.eval("xtal_structure = reflections.open_structure(myinput.param,phase)");
                        jep.eval("print 'UNIT CELL', myinput.param['unit_cell_phase_" + i + "']");
                        jep.eval("print 'Generating miller indices'");
                        jep.eval("hkl_tmp = reflections.gen_miller(myinput.param,phase)");
                        if ((Integer)jep.getValue("myinput.param['structure_factors']") != 0) {
                            jep.eval("print 'Structure factor calculation'");
                            jep.eval("hkl.append(reflections.calc_intensity(hkl_tmp,xtal_structure,'" + PolyXSim.this.killFile + "'))");
                        } else {
                            jep.eval("print 'No structure factor calculation'");
                            jep.eval("hkl.append(reflections.add_intensity(hkl,myinput.param))");
                        }
                    } else {
                        jep.eval("hkl_tmp = reflections.gen_miller(myinput.param,phase)");
                        jep.eval("hkl.append(reflections.add_intensity(hkl_tmp,myinput.param))");
                    }
                    ++i;
                }
                FableMessageConsole.console.displayOut("generate grains");
                jep.eval("generate_grains.generate_grains(myinput.param)");
                if (this.updateMonitorStatus("Write grains", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("write grains");
                jep.eval("file_io.write_grains(myinput.param)");
                if (this.updateMonitorStatus("Write res", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("write reflections");
                jep.eval("file_io.write_res(myinput.param)");
                if (this.updateMonitorStatus("Generate reflections", 60)) {
                    return;
                }
                if (this.updateMonitorStatus("Determine the reflection parameters for grains", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("grain reflections");
                jep.eval("graindata = find_refl.find_refl(myinput.param,hkl,'" + PolyXSim.this.killFile + "')");
                jep.eval("graindata.frameinfo = myinput.frameinfo");
                jep.eval("graindata.run()");
                if (this.updateMonitorStatus("Save grains", 1)) {
                    return;
                }
                FableMessageConsole.console.displayOut("save grains");
                jep.eval("graindata.save()");
                if (outputGve) {
                    if (this.updateMonitorStatus("Save gvectors", 1)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("save gve");
                    jep.eval("graindata.write_gve()");
                }
                if (outputFlt) {
                    if (this.updateMonitorStatus("Save filtered peaks", 1)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("save flt");
                    jep.eval("graindata.write_flt()");
                }
                if (this.updateMonitorStatus("Determine the reflection parameters for grains", 20)) {
                    return;
                }
                FableMessageConsole.console.displayOut("determine the reflection parameters for grains");
                jep.eval("graindata = find_refl.find_refl(myinput.param,hkl)");
                jep.eval("graindata.frameinfo = myinput.frameinfo");
                jep.eval("graindata.run()");
                jep.eval("graindata.save()");
                if (outputGve) {
                    jep.eval("graindata.write_gve()");
                }
                if (outputFlt) {
                    jep.eval("graindata.write_flt()");
                }
                if (peakShape == 2) {
                    if (this.updateMonitorStatus("Make image stack", 20)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("make images");
                    jep.eval("image = make_imagestack.make_image(graindata,'" + PolyXSim.this.killFile + "')");
                    if (this.updateMonitorStatus("Setup odf", 1)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("setup odf");
                    jep.eval("image.setup_odf()");
                    if (this.updateMonitorStatus("Write images", 15)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("write images");
                    jep.eval("image.make_image()");
                    jep.eval("image.correct_image()");
                } else {
                    if (this.updateMonitorStatus("Make images", 20)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("make images");
                    jep.eval("image = make_image.make_image(graindata,'" + PolyXSim.this.killFile + "')");
                    if (this.updateMonitorStatus("Write images", 15)) {
                        return;
                    }
                    FableMessageConsole.console.displayOut("write images");
                    jep.eval("image.make_image()");
                }
                Thread.sleep(1000L);
                PolyXSim.this.runStatus = true;
            }
            catch (JepException e) {
                e.printStackTrace();
                PolyXSim.this.runStatus = false;
                FableMessageConsole.console.displayError(e.getMessage());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                PolyXSim.this.runStatus = false;
                FableMessageConsole.console.displayError(e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
                PolyXSim.this.runStatus = false;
                FableMessageConsole.console.displayError(e.getMessage());
            }
            if (PolyXSim.this.runStatus) {
                FableMessageConsole.console.displayOut("polyxsim simulation finished");
            } else {
                FableMessageConsole.console.displayError("polyxsim simulation failed ");
            }
            PolyXSim.this.fireProperty("stopped");
            ((PolyXSim)PolyXSim.this).stdoutThread.stopped = true;
            try {
                PolyXSim.this.stdoutThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setCursor(0);
        }

        void setCursor(final int cursor) {
            if (!Display.getDefault().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Cursor arrowCursor = new Cursor((Device)Display.getDefault(), cursor);
                        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        activeWindow.getShell().setCursor(arrowCursor);
                    }
                });
            }
        }

        boolean updateMonitorStatus(String task, int work) {
            PolyXSim.this.polyXSimMonitor.subTask(task);
            PolyXSim.this.polyXSimMonitor.worked(work);
            if (PolyXSim.this.polyXSimMonitor.isCanceled()) {
                File killfile = new File(PolyXSim.this.killFile);
                try {
                    killfile.createNewFile();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                FableMessageConsole.console.displayOut("canceled polyxsim simulation");
                PolyXSim.this.fireProperty("stopped");
                ((PolyXSim)PolyXSim.this).stdoutThread.stopped = true;
                try {
                    PolyXSim.this.stdoutThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.setCursor(0);
                killfile.delete();
                PolyXSim.this.jobCanceled = true;
                return true;
            }
            return false;
        }
    }

    public class StdoutReaderThread
    extends Thread {
        String outputMessage;
        BufferedReader outputread;
        public boolean stopped = false;

        public StdoutReaderThread(String fileName) {
            try {
                this.outputread = new BufferedReader(new FileReader(fileName));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

